/*
 * Decompiled with CFR 0.152.
 */
package org.planit.gap;

import org.planit.gap.GapFunction;
import org.planit.gap.StopCriterion;

public class LinkBasedRelativeDualityGapFunction
extends GapFunction {
    protected double measuredNetworkCost = 0.0;
    protected double minimumNetworkCost = 0.0;
    protected double gap = Double.POSITIVE_INFINITY;

    public LinkBasedRelativeDualityGapFunction(StopCriterion stopCriterion) {
        super(stopCriterion);
    }

    public double computeGap() {
        this.gap = (this.measuredNetworkCost - this.minimumNetworkCost) / this.measuredNetworkCost;
        return this.gap;
    }

    public double getMeasuredNetworkCost() {
        return this.measuredNetworkCost;
    }

    public void increaseMeasuredNetworkCost(double increaseValue) {
        this.measuredNetworkCost += increaseValue;
    }

    public void increaseConvexityBound(double increaseMinimumSystemCost) {
        this.minimumNetworkCost += increaseMinimumSystemCost;
    }

    @Override
    public void reset() {
        this.measuredNetworkCost = 0.0;
        this.minimumNetworkCost = 0.0;
    }

    @Override
    public double getGap() {
        return this.gap;
    }
}

