/*
 * Decompiled with CFR 0.152.
 */
package org.planit.cost.virtual;

import org.planit.cost.virtual.AbstractVirtualCost;
import org.planit.cost.virtual.FixedVirtualCostConfigurator;
import org.planit.cost.virtual.SpeedVirtualCostConfigurator;
import org.planit.cost.virtual.VirtualCost;
import org.planit.cost.virtual.VirtualCostConfigurator;
import org.planit.utils.exceptions.PlanItException;

public class VirtualCostConfiguratorFactory {
    public static VirtualCostConfigurator<? extends AbstractVirtualCost> createConfigurator(String virtualCostType) throws PlanItException {
        if (virtualCostType.equals(VirtualCost.FIXED)) {
            return new FixedVirtualCostConfigurator();
        }
        if (virtualCostType.equals(VirtualCost.SPEED)) {
            return new SpeedVirtualCostConfigurator();
        }
        throw new PlanItException(String.format("unable to construct configurator for given virtualCostType %s", virtualCostType));
    }
}

