/*
 * Decompiled with CFR 0.152.
 */
package org.planit.cost.virtual;

import org.planit.cost.virtual.AbstractVirtualCost;
import org.planit.network.virtual.VirtualNetwork;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.virtual.ConnectoidSegment;

public class SpeedConnectoidTravelTimeCost
extends AbstractVirtualCost {
    private static final long serialVersionUID = 2813935702895030693L;
    public static final double DEFAULT_CONNECTOID_SPEED_KPH = 25.0;
    private double connectoidSpeed = 25.0;

    public SpeedConnectoidTravelTimeCost(IdGroupingToken groupId) {
        super(groupId);
    }

    public void setConnectoidSpeed(double connectoidSpeed) {
        this.connectoidSpeed = connectoidSpeed;
    }

    @Override
    public double getSegmentCost(Mode mode, ConnectoidSegment connectoidSegment) {
        return connectoidSegment.getParentEdge().getLengthKm() / this.connectoidSpeed;
    }

    @Override
    public void populateWithCost(Mode mode, double[] costToFill) throws PlanItException {
    }

    @Override
    public void initialiseBeforeSimulation(VirtualNetwork virtualNetwork) throws PlanItException {
    }
}

