/*
 * Decompiled with CFR 0.152.
 */
package org.planit.assignment.traditionalstatic;

import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.planit.algorithms.shortestpath.DijkstraShortestPathAlgorithm;
import org.planit.algorithms.shortestpath.ShortestPathResult;
import org.planit.assignment.StaticTrafficAssignment;
import org.planit.assignment.traditionalstatic.ModeData;
import org.planit.assignment.traditionalstatic.TraditionalStaticAssignmentSimulationData;
import org.planit.cost.Cost;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.physical.initial.InitialPhysicalCost;
import org.planit.gap.LinkBasedRelativeDualityGapFunction;
import org.planit.interactor.LinkVolumeAccessee;
import org.planit.network.InfrastructureLayer;
import org.planit.network.macroscopic.MacroscopicNetwork;
import org.planit.network.macroscopic.physical.MacroscopicPhysicalNetwork;
import org.planit.od.odmatrix.ODMatrixIterator;
import org.planit.od.odmatrix.demand.ODDemandMatrix;
import org.planit.od.odmatrix.skim.ODSkimMatrix;
import org.planit.od.odpath.ODPathMatrix;
import org.planit.output.adapter.OutputTypeAdapter;
import org.planit.output.adapter.OutputTypeAdapterImpl;
import org.planit.output.adapter.TraditionalStaticAssignmentLinkOutputTypeAdapter;
import org.planit.output.adapter.TraditionalStaticAssignmentODOutputTypeAdapter;
import org.planit.output.adapter.TraditionalStaticPathOutputTypeAdapter;
import org.planit.output.configuration.ODOutputTypeConfiguration;
import org.planit.output.enums.ODSkimSubOutputType;
import org.planit.output.enums.OutputType;
import org.planit.output.enums.SubOutputTypeEnum;
import org.planit.path.Path;
import org.planit.time.TimePeriod;
import org.planit.utils.arrays.ArrayUtils;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.LoggingUtils;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.virtual.ConnectoidSegment;
import org.planit.utils.zoning.Centroid;
import org.planit.utils.zoning.Zone;

public class TraditionalStaticAssignment
extends StaticTrafficAssignment
implements LinkVolumeAccessee {
    private static final long serialVersionUID = -4610905345414397908L;
    private static final Logger LOGGER = Logger.getLogger(TraditionalStaticAssignment.class.getCanonicalName());
    private static final double DEFAULT_FLOW_EPSILON = 1.0E-6;
    private TraditionalStaticAssignmentSimulationData simulationData = null;
    private MacroscopicPhysicalNetwork networkLayer;

    protected String createLoggingPrefix() {
        return super.createLoggingPrefix(this.simulationData.getIterationIndex());
    }

    @Override
    protected void verifyComponentCompatibility() throws PlanItException {
        PlanItException.throwIf(!(this.transportNetwork.getInfrastructureNetwork() instanceof MacroscopicNetwork), "Traditional static assignment is only compatible with macroscopic networks");
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)this.transportNetwork.getInfrastructureNetwork();
        PlanItException.throwIf(macroscopicNetwork.infrastructureLayers.size() != 1, "Traditional static assignment  is currently only compatible with networks using a single infrastructure layer");
        InfrastructureLayer infrastructureLayer = macroscopicNetwork.infrastructureLayers.getFirst();
        PlanItException.throwIf(!(infrastructureLayer instanceof MacroscopicPhysicalNetwork), "Traditional static assignment is only compatible with macroscopic physical network layers");
        if (this.transportNetwork.getInfrastructureNetwork().modes.size() != infrastructureLayer.getSupportedModes().size()) {
            LOGGER.warning("network wide modes do not match modes supported by the single available layer, consider removing unused modes");
        }
        this.networkLayer = (MacroscopicPhysicalNetwork)infrastructureLayer;
    }

    private void initialiseTimePeriod(TimePeriod timePeriod, Set<Mode> modes) throws PlanItException {
        this.simulationData = new TraditionalStaticAssignmentSimulationData(this.tokenId);
        this.simulationData.setIterationIndex(0);
        this.simulationData.getModeSpecificData().clear();
        for (Mode mode : modes) {
            this.simulationData.getModeSpecificData().put(mode, new ModeData(new double[this.numberOfNetworkSegments]));
            double[] modalLinkSegmentCosts = this.initialiseLinkSegmentCosts(mode, timePeriod);
            this.simulationData.setModalLinkSegmentCosts(mode, modalLinkSegmentCosts);
        }
    }

    private void applySmoothing(Mode mode, ModeData modeData) {
        double[] smoothedSegmentFlows = this.smoothing.applySmoothing(modeData.getCurrentSegmentFlows(), modeData.getNextSegmentFlows(), this.numberOfNetworkSegments);
        modeData.setCurrentSegmentFlows(smoothedSegmentFlows);
        this.simulationData.getModeSpecificData().put(mode, modeData);
    }

    private void executeTimePeriodAndMode(Mode mode, TimePeriod timePeriod, ModeData currentModeData, double[] modalNetworkSegmentCosts) throws PlanItException {
        DijkstraShortestPathAlgorithm shortestPathAlgorithm = new DijkstraShortestPathAlgorithm(modalNetworkSegmentCosts, this.numberOfNetworkSegments, this.numberOfNetworkVertices);
        ODDemandMatrix odDemandMatrix = this.demands.get(mode, timePeriod);
        LinkBasedRelativeDualityGapFunction dualityGapFunction = (LinkBasedRelativeDualityGapFunction)this.getGapFunction();
        ODPathMatrix odpathMatrix = this.simulationData.getODPathMatrix(mode);
        Map<ODSkimSubOutputType, ODSkimMatrix> skimMatrixMap = this.simulationData.getSkimMatrixMap(mode);
        long previousOriginZoneId = -1L;
        ShortestPathResult shortestPathResult = null;
        ODMatrixIterator odDemandMatrixIter = odDemandMatrix.iterator();
        while (odDemandMatrixIter.hasNext()) {
            double odDemand = odDemandMatrixIter.next();
            Zone currentOriginZone = odDemandMatrixIter.getCurrentOrigin();
            Zone currentDestinationZone = odDemandMatrixIter.getCurrentDestination();
            if (currentOriginZone.getId() == currentDestinationZone.getId() || !this.getOutputManager().getOutputConfiguration().isPersistZeroFlow() && !(odDemand - 1.0E-6 > 0.0)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("(O,D)=(%d,%d) --> demand (pcu/h): %f (mode: %d)", currentOriginZone.getExternalId(), currentDestinationZone.getExternalId(), odDemand, mode.getExternalId()));
            }
            if (previousOriginZoneId != currentOriginZone.getId()) {
                Centroid originCentroid = currentOriginZone.getCentroid();
                if (originCentroid.getExitEdgeSegments().isEmpty()) {
                    throw new PlanItException(String.format("edge segments have not been assigned to Centroid for Zone %d", currentOriginZone.getExternalId()));
                }
                shortestPathResult = shortestPathAlgorithm.executeOneToAll(originCentroid);
            }
            if (odDemand - 1.0E-6 > 0.0) {
                double odShortestPathCost = shortestPathResult.getCostToReach(currentDestinationZone.getCentroid());
                if (odShortestPathCost == Double.POSITIVE_INFINITY) {
                    LOGGER.warning(this.createLoggingPrefix() + "impossible path from origin zone " + currentOriginZone.getExternalId() + " to destination zone " + currentDestinationZone.getExternalId() + " (mode " + mode.getExternalId() + ")");
                } else {
                    this.updateNetworkFlowsForPath(shortestPathResult, currentOriginZone, currentDestinationZone, odDemand, currentModeData);
                    dualityGapFunction.increaseConvexityBound(odDemand * odShortestPathCost);
                }
            }
            previousOriginZoneId = currentOriginZone.getId();
            this.updateODOutputData(skimMatrixMap, currentOriginZone, currentDestinationZone, odDemand, shortestPathResult);
            this.updatePathOutputData(odpathMatrix, currentOriginZone, currentDestinationZone, shortestPathResult);
        }
    }

    private void smoothTimePeriodAndMode(Mode mode, TimePeriod timePeriod, ModeData currentModeData, double[] modalNetworkSegmentCosts) {
        double totalModeSystemTravelTime = ArrayUtils.dotProduct(currentModeData.getCurrentSegmentFlows(), modalNetworkSegmentCosts, this.numberOfNetworkSegments);
        LinkBasedRelativeDualityGapFunction dualityGapFunction = (LinkBasedRelativeDualityGapFunction)this.getGapFunction();
        dualityGapFunction.increaseMeasuredNetworkCost(totalModeSystemTravelTime);
        this.applySmoothing(mode, currentModeData);
    }

    private void executeAndSmoothTimePeriodAndMode(TimePeriod timePeriod, Mode mode) throws PlanItException {
        LOGGER.fine(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("[mode %s (id:%d)]", mode.getExternalId(), mode.getId()));
        double[] modalLinkSegmentCosts = this.simulationData.getModalLinkSegmentCosts(mode);
        ModeData currentModeData = this.simulationData.getModeSpecificData().get(mode);
        currentModeData.resetNextNetworkSegmentFlows();
        this.executeTimePeriodAndMode(mode, timePeriod, currentModeData, modalLinkSegmentCosts);
        this.smoothTimePeriodAndMode(mode, timePeriod, currentModeData, modalLinkSegmentCosts);
    }

    private void updateNetworkFlowsForPath(ShortestPathResult shortestPathResult, Zone origin, Zone destination, double odDemand, ModeData currentModeData) throws PlanItException {
        EdgeSegment currentEdgeSegment = null;
        DirectedVertex currentVertex = destination.getCentroid();
        while (currentVertex.getId() != origin.getCentroid().getId()) {
            currentEdgeSegment = shortestPathResult.getIncomingEdgeSegmentForVertex(currentVertex);
            if (currentEdgeSegment == null) {
                PlanItException.throwIf(currentVertex instanceof Centroid, "The solution could not find an Edge Segment for the connectoid for zone " + currentVertex.getParentZone().getExternalId());
            }
            currentModeData.addToNextSegmentFlows(currentEdgeSegment.getId(), odDemand);
            currentVertex = currentEdgeSegment.getUpstreamVertex();
        }
    }

    private void updateODOutputData(Map<ODSkimSubOutputType, ODSkimMatrix> skimMatrixMap, Zone currentOriginZone, Zone currentDestinationZone, double odDemand, ShortestPathResult shortestPathResult) {
        if (this.getOutputManager().isOutputTypeActive(OutputType.OD)) {
            Set<SubOutputTypeEnum> activeSubOutputTypes = ((ODOutputTypeConfiguration)this.getOutputManager().getOutputTypeConfiguration(OutputType.OD)).getActiveSubOutputTypes();
            for (SubOutputTypeEnum odSkimOutputType : activeSubOutputTypes) {
                if (!odSkimOutputType.equals(ODSkimSubOutputType.COST)) continue;
                double odGeneralisedCost = shortestPathResult.getCostToReach(currentDestinationZone.getCentroid());
                ODSkimMatrix odSkimMatrix = skimMatrixMap.get(odSkimOutputType);
                odSkimMatrix.setValue(currentOriginZone, currentDestinationZone, odGeneralisedCost);
            }
        }
    }

    private void updatePathOutputData(ODPathMatrix odpathMatrix, Zone currentOriginZone, Zone currentDestinationZone, ShortestPathResult shortestPathResult) {
        if (this.getOutputManager().isOutputTypeActive(OutputType.PATH)) {
            Path path = shortestPathResult.createPath(this.tokenId, currentOriginZone.getCentroid(), currentDestinationZone.getCentroid());
            odpathMatrix.setValue(currentOriginZone, currentDestinationZone, path);
        }
    }

    private Calendar logIterationInformation(Calendar startTime, double measuredNetworkCost, double dualityGap) {
        Calendar currentTime = Calendar.getInstance();
        LOGGER.info(this.createLoggingPrefix() + String.format("network travel time: %f", measuredNetworkCost));
        LOGGER.info(this.createLoggingPrefix() + String.format("duality gap: %.6f (%d ms)", dualityGap, currentTime.getTimeInMillis() - startTime.getTimeInMillis()));
        return currentTime;
    }

    private void populateModalConnectoidCosts(Mode mode, double[] currentSegmentCosts) throws PlanItException {
        for (ConnectoidSegment currentSegment : this.transportNetwork.getVirtualNetwork().connectoidSegments) {
            currentSegmentCosts[(int)currentSegment.getId()] = this.virtualCost.getSegmentCost(mode, currentSegment);
        }
    }

    private void calculateModalLinkSegmentCosts(Mode mode, double[] currentSegmentCosts) throws PlanItException {
        this.getPhysicalCost().populateWithCost(mode, currentSegmentCosts);
    }

    private boolean populateToInitialCost(Mode mode, double[] segmentCostToPopulate) throws PlanItException {
        if (this.initialLinkSegmentCost == null || !this.initialLinkSegmentCost.isSegmentCostsSetForMode(mode)) {
            return false;
        }
        this.populateCost(this.initialLinkSegmentCost, mode, segmentCostToPopulate);
        return true;
    }

    private boolean populateToInitialCost(Mode mode, TimePeriod timePeriod, double[] segmentCostToPopulate) throws PlanItException {
        InitialLinkSegmentCost initialLinkSegmentCostForTimePeriod = (InitialLinkSegmentCost)this.initialLinkSegmentCostByTimePeriod.get(timePeriod);
        if (initialLinkSegmentCostForTimePeriod == null || !initialLinkSegmentCostForTimePeriod.isSegmentCostsSetForMode(mode)) {
            return this.populateToInitialCost(mode, segmentCostToPopulate);
        }
        InitialPhysicalCost initialTimePeriodCost = (InitialPhysicalCost)this.initialLinkSegmentCostByTimePeriod.get(timePeriod);
        this.populateCost(initialTimePeriodCost, mode, segmentCostToPopulate);
        return true;
    }

    private void populateCost(Cost<MacroscopicLinkSegment> cost, Mode mode, double[] costsToPopulate) throws PlanItException {
        for (MacroscopicLinkSegment linkSegment : this.networkLayer.linkSegments) {
            double currentSegmentCost = cost.getSegmentCost(mode, linkSegment);
            if (currentSegmentCost < 0.0) {
                throw new PlanItException(String.format("link segment cost is negative for link segment %d (id: %d)", linkSegment.getExternalId(), linkSegment.getId()));
            }
            costsToPopulate[(int)linkSegment.getId()] = currentSegmentCost;
        }
    }

    private double[] initialiseLinkSegmentCosts(Mode mode, TimePeriod timePeriod) throws PlanItException {
        double[] currentSegmentCosts = new double[this.transportNetwork.getTotalNumberOfEdgeSegments()];
        this.populateModalConnectoidCosts(mode, currentSegmentCosts);
        if (this.populateToInitialCost(mode, timePeriod, currentSegmentCosts)) {
            return currentSegmentCosts;
        }
        this.calculateModalLinkSegmentCosts(mode, currentSegmentCosts);
        return currentSegmentCosts;
    }

    private double[] recalculateModalLinkSegmentCosts(Mode mode, TimePeriod timePeriod) throws PlanItException {
        double[] currentSegmentCosts = new double[this.transportNetwork.getTotalNumberOfEdgeSegments()];
        this.populateModalConnectoidCosts(mode, currentSegmentCosts);
        this.calculateModalLinkSegmentCosts(mode, currentSegmentCosts);
        return currentSegmentCosts;
    }

    @Override
    public OutputTypeAdapter createOutputTypeAdapter(OutputType outputType) {
        OutputTypeAdapterImpl outputTypeAdapter = null;
        switch (outputType) {
            case LINK: {
                outputTypeAdapter = new TraditionalStaticAssignmentLinkOutputTypeAdapter(outputType, this);
                break;
            }
            case OD: {
                outputTypeAdapter = new TraditionalStaticAssignmentODOutputTypeAdapter(outputType, this);
                break;
            }
            case PATH: {
                outputTypeAdapter = new TraditionalStaticPathOutputTypeAdapter(outputType, this);
                break;
            }
            default: {
                LOGGER.warning(LoggingUtils.createRunIdPrefix(this.getId()) + outputType.value() + " has not been defined yet.");
            }
        }
        return outputTypeAdapter;
    }

    @Override
    protected void executeTimePeriod(TimePeriod timePeriod, Set<Mode> modes) throws PlanItException {
        this.initialiseTimePeriod(timePeriod, modes);
        LinkBasedRelativeDualityGapFunction dualityGapFunction = (LinkBasedRelativeDualityGapFunction)this.getGapFunction();
        boolean converged = false;
        Calendar iterationStartTime = Calendar.getInstance();
        while (!converged) {
            dualityGapFunction.reset();
            this.smoothing.update(this.simulationData.getIterationIndex());
            for (Mode mode : modes) {
                if (this.getOutputManager().isOutputTypeActive(OutputType.OD)) {
                    this.simulationData.resetSkimMatrix(mode, this.getTransportNetwork().getZoning().odZones, (ODOutputTypeConfiguration)this.getOutputManager().getOutputTypeConfiguration(OutputType.OD));
                }
                if (this.getOutputManager().isOutputTypeActive(OutputType.PATH)) {
                    this.simulationData.resetPathMatrix(mode, this.getTransportNetwork().getZoning().odZones);
                }
                this.executeAndSmoothTimePeriodAndMode(timePeriod, mode);
            }
            dualityGapFunction.computeGap();
            this.simulationData.incrementIterationIndex();
            iterationStartTime = this.logIterationInformation(iterationStartTime, dualityGapFunction.getMeasuredNetworkCost(), dualityGapFunction.getGap());
            for (Mode mode : modes) {
                double[] modalLinkSegmentCosts = this.recalculateModalLinkSegmentCosts(mode, timePeriod);
                this.simulationData.setModalLinkSegmentCosts(mode, modalLinkSegmentCosts);
            }
            converged = dualityGapFunction.hasConverged(this.simulationData.getIterationIndex());
            this.getOutputManager().persistOutputData(timePeriod, modes, converged);
        }
    }

    public TraditionalStaticAssignment(IdGroupingToken groupId) {
        super(groupId);
    }

    @Override
    public int getIterationIndex() {
        return this.getIterationData() == null ? 0 : this.getIterationData().getIterationIndex();
    }

    @Override
    public double getLinkSegmentFlow(LinkSegment linkSegment) {
        return this.simulationData.collectTotalNetworkSegmentFlow(linkSegment);
    }

    @Override
    public double[] getLinkSegmentFlows() {
        return this.simulationData.collectTotalNetworkSegmentFlows();
    }

    public TraditionalStaticAssignmentSimulationData getIterationData() {
        return this.simulationData;
    }
}

