/*
 * Decompiled with CFR 0.152.
 */
package org.planit.assignment;

import java.util.List;
import java.util.logging.Logger;
import org.planit.assignment.TrafficAssignment;
import org.planit.cost.physical.AbstractPhysicalCost;
import org.planit.cost.physical.PhysicalCostConfigurator;
import org.planit.cost.physical.PhysicalCostConfiguratorFactory;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCostPeriod;
import org.planit.cost.virtual.AbstractVirtualCost;
import org.planit.cost.virtual.VirtualCostConfigurator;
import org.planit.cost.virtual.VirtualCostConfiguratorFactory;
import org.planit.demands.Demands;
import org.planit.gap.GapFunction;
import org.planit.gap.GapFunctionConfigurator;
import org.planit.network.InfrastructureNetwork;
import org.planit.output.OutputManager;
import org.planit.output.configuration.OutputConfiguration;
import org.planit.output.configuration.OutputTypeConfiguration;
import org.planit.output.enums.OutputType;
import org.planit.output.formatter.OutputFormatter;
import org.planit.sdinteraction.smoothing.Smoothing;
import org.planit.sdinteraction.smoothing.SmoothingConfigurator;
import org.planit.sdinteraction.smoothing.SmoothingConfiguratorFactory;
import org.planit.time.TimePeriod;
import org.planit.utils.builder.Configurator;
import org.planit.utils.exceptions.PlanItException;
import org.planit.zoning.Zoning;

public class TrafficAssignmentConfigurator<T extends TrafficAssignment>
extends Configurator<T> {
    private static final Logger LOGGER = Logger.getLogger(TrafficAssignmentConfigurator.class.getCanonicalName());
    protected static final String SET_OUTPUT_MANAGER = "setOutputManager";
    protected static final String SET_GAP_FUNCTION = "setGapFunction";
    protected static final String SET_VIRTUAL_COST = "setVirtualCost";
    protected static final String SET_PHYSICAL_COST = "setPhysicalCost";
    protected static final String SET_INITIAL_LINK_SEGMENT_COST = "setInitialLinkSegmentCost";
    protected static final String SET_INFRASTRUCTURE_NETWORK = "setInfrastructureNetwork";
    protected static final String SET_ZONING = "setZoning";
    protected static final String SET_DEMANDS = "setDemands";
    private SmoothingConfigurator<? extends Smoothing> smoothingConfigurator = null;
    private PhysicalCostConfigurator<? extends AbstractPhysicalCost> physicalCostConfigurator = null;
    private VirtualCostConfigurator<? extends AbstractVirtualCost> virtualCostConfigurator = null;
    private GapFunctionConfigurator<? extends GapFunction> gapFunctionConfigurator = null;

    protected void setGapFunction(GapFunctionConfigurator<? extends GapFunction> gapFunctionConfigurator) {
        this.gapFunctionConfigurator = gapFunctionConfigurator;
    }

    protected void setInfrastructureNetwork(InfrastructureNetwork network) {
        this.registerDelayedMethodCall(SET_INFRASTRUCTURE_NETWORK, network);
    }

    protected void setZoning(Zoning zoning) {
        this.registerDelayedMethodCall(SET_ZONING, zoning);
    }

    protected void setDemands(Demands demands) {
        this.registerDelayedMethodCall(SET_DEMANDS, demands);
    }

    protected void setOutputManager(OutputManager outputManager) {
        this.registerDelayedMethodCall(SET_OUTPUT_MANAGER, outputManager);
    }

    protected OutputManager getOutputManager() {
        return (OutputManager)this.getFirstParameterOfDelayedMethodCall(SET_OUTPUT_MANAGER);
    }

    public TrafficAssignmentConfigurator(Class<T> instanceType) {
        super(instanceType);
    }

    public InfrastructureNetwork getInfrastructureNetwork() {
        return (InfrastructureNetwork)this.getFirstParameterOfDelayedMethodCall(SET_INFRASTRUCTURE_NETWORK);
    }

    public Zoning getZoning() {
        return (Zoning)this.getFirstParameterOfDelayedMethodCall(SET_ZONING);
    }

    public Demands getDemands() {
        return (Demands)this.getFirstParameterOfDelayedMethodCall(SET_DEMANDS);
    }

    public SmoothingConfigurator<? extends Smoothing> createAndRegisterSmoothing(String smoothingType) throws PlanItException {
        this.smoothingConfigurator = SmoothingConfiguratorFactory.createConfigurator(smoothingType);
        return this.smoothingConfigurator;
    }

    public PhysicalCostConfigurator<? extends AbstractPhysicalCost> createAndRegisterPhysicalCost(String physicalTraveltimeCostFunctionType) throws PlanItException {
        this.physicalCostConfigurator = PhysicalCostConfiguratorFactory.createConfigurator(physicalTraveltimeCostFunctionType);
        return this.physicalCostConfigurator;
    }

    public VirtualCostConfigurator<? extends AbstractVirtualCost> createAndRegisterVirtualCost(String virtualTraveltimeCostFunctionType) throws PlanItException {
        this.virtualCostConfigurator = VirtualCostConfiguratorFactory.createConfigurator(virtualTraveltimeCostFunctionType);
        return this.virtualCostConfigurator;
    }

    public void registerOutputFormatter(OutputFormatter outputFormatter) throws PlanItException {
        this.getOutputManager().registerOutputFormatter(outputFormatter);
    }

    public void unregisterOutputFormatter(OutputFormatter outputFormatter) throws PlanItException {
        this.getOutputManager().unregisterOutputFormatter(outputFormatter);
    }

    public List<OutputFormatter> getOutputFormatters() {
        return this.getOutputManager().getOutputFormatters();
    }

    public void registerInitialLinkSegmentCost(InitialLinkSegmentCost initialLinkSegmentCost) {
        this.registerDelayedMethodCall(SET_INITIAL_LINK_SEGMENT_COST, initialLinkSegmentCost);
    }

    public void registerInitialLinkSegmentCost(InitialLinkSegmentCostPeriod initialLinkSegmentCost) throws PlanItException {
        this.registerInitialLinkSegmentCost(initialLinkSegmentCost.getTimePeriod(), initialLinkSegmentCost);
    }

    public void registerInitialLinkSegmentCost(TimePeriod timePeriod, InitialLinkSegmentCost initialLinkSegmentCost) throws PlanItException {
        PlanItException.throwIf(timePeriod == null, "time period null when registering initial link segment costs");
        this.registerDelayedMethodCall(SET_INITIAL_LINK_SEGMENT_COST, timePeriod, initialLinkSegmentCost);
    }

    public OutputTypeConfiguration activateOutput(OutputType outputType) throws PlanItException {
        if (!this.isOutputTypeActive(outputType)) {
            return this.getOutputManager().createAndRegisterOutputTypeConfiguration(outputType);
        }
        return this.getOutputManager().getOutputTypeConfiguration(outputType);
    }

    public void deactivateOutput(OutputType outputType) {
        if (this.isOutputTypeActive(outputType)) {
            this.getOutputManager().deregisterOutputTypeConfiguration(outputType);
            this.getOutputManager().deregisterOutputTypeAdapter(outputType);
        }
    }

    public boolean isOutputTypeActive(OutputType outputType) {
        return this.getOutputManager().isOutputTypeActive(outputType);
    }

    public OutputConfiguration getOutputConfiguration() {
        return this.getOutputManager().getOutputConfiguration();
    }

    public GapFunctionConfigurator<? extends GapFunction> getGapFunction() {
        return this.gapFunctionConfigurator;
    }

    public PhysicalCostConfigurator<? extends AbstractPhysicalCost> getPhysicalCost() {
        return this.physicalCostConfigurator;
    }

    public VirtualCostConfigurator<? extends AbstractVirtualCost> getVirtualCost() {
        return this.virtualCostConfigurator;
    }

    public SmoothingConfigurator<? extends Smoothing> getSmoothing() {
        return this.smoothingConfigurator;
    }
}

