/*
 * Decompiled with CFR 0.152.
 */
package org.planit.assignment;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.djutils.event.Event;
import org.djutils.event.EventProducer;
import org.djutils.event.EventType;
import org.planit.assignment.TrafficAssignmentComponent;
import org.planit.assignment.traditionalstatic.TraditionalStaticAssignment;
import org.planit.cost.physical.AbstractPhysicalCost;
import org.planit.cost.physical.BPRLinkTravelTimeCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCostPeriod;
import org.planit.cost.physical.initial.InitialPhysicalCost;
import org.planit.cost.virtual.AbstractVirtualCost;
import org.planit.cost.virtual.FixedConnectoidTravelTimeCost;
import org.planit.cost.virtual.SpeedConnectoidTravelTimeCost;
import org.planit.demands.Demands;
import org.planit.network.Network;
import org.planit.network.macroscopic.MacroscopicNetwork;
import org.planit.path.ODPathSets;
import org.planit.path.choice.PathChoice;
import org.planit.path.choice.logit.LogitChoiceModel;
import org.planit.path.choice.logit.MultinomialLogit;
import org.planit.sdinteraction.smoothing.MSASmoothing;
import org.planit.sdinteraction.smoothing.Smoothing;
import org.planit.supply.fundamentaldiagram.FundamentalDiagram;
import org.planit.supply.fundamentaldiagram.NewellFundamentalDiagram;
import org.planit.supply.network.nodemodel.NodeModel;
import org.planit.supply.network.nodemodel.TampereNodeModel;
import org.planit.supply.networkloading.NetworkLoading;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.reflection.ReflectionUtils;
import org.planit.zoning.Zoning;

public class TrafficAssignmentComponentFactory<T extends Serializable>
extends EventProducer
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(TrafficAssignmentComponentFactory.class.getCanonicalName());
    private static final long serialVersionUID = -4507287133047792042L;
    public static final EventType TRAFFICCOMPONENT_CREATE = new EventType("TRAFFICCOMPONENT.CREATE");
    protected final String componentSuperTypeCanonicalName;
    protected static final HashMap<String, TreeSet<String>> registeredTrafficAssignmentComponents = new HashMap();

    private static void registerDefaultImplementations() {
        try {
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(Zoning.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(TraditionalStaticAssignment.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(MSASmoothing.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(Demands.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(MacroscopicNetwork.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(BPRLinkTravelTimeCost.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(InitialLinkSegmentCost.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(InitialLinkSegmentCostPeriod.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(FixedConnectoidTravelTimeCost.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(SpeedConnectoidTravelTimeCost.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(NewellFundamentalDiagram.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(TampereNodeModel.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(MultinomialLogit.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(ODPathSets.class);
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            e.printStackTrace();
        }
    }

    private T createTrafficComponent(String trafficAssignmentComponentClassName, Object[] constructorParameters) throws PlanItException {
        TreeSet<String> eligibleComponentTypes = registeredTrafficAssignmentComponents.get(this.componentSuperTypeCanonicalName);
        PlanItException.throwIf(eligibleComponentTypes == null || !eligibleComponentTypes.contains(trafficAssignmentComponentClassName), "provided Traffic Assignment Component class is not eligible for construction");
        Object instance = ReflectionUtils.createInstance(trafficAssignmentComponentClassName, constructorParameters);
        PlanItException.throwIf(!(instance instanceof TrafficAssignmentComponent), "provided factory class is not eligible for construction since it is not derived from TrafficAssignmentComponent<?>");
        return (T)((Serializable)instance);
    }

    private void dispatchTrafficComponentEvent(T newTrafficComponent, Object[] parameters) throws PlanItException {
        this.fireEvent(new Event(TRAFFICCOMPONENT_CREATE, this, (Serializable)new Object[]{newTrafficComponent, parameters}));
        PlanItException.throwIf(!this.listeners.containsKey(TRAFFICCOMPONENT_CREATE), String.format("error during dispatchTrafficComponentEvent for %s", newTrafficComponent.getClass().getCanonicalName()));
    }

    public <U extends TrafficAssignmentComponent<U>> TrafficAssignmentComponentFactory(Class<U> componentSuperType) {
        this.componentSuperTypeCanonicalName = componentSuperType.getCanonicalName();
    }

    public TrafficAssignmentComponentFactory(String componentSuperTypeCanonicalName) {
        this.componentSuperTypeCanonicalName = componentSuperTypeCanonicalName;
    }

    public static void registerTrafficAssignmentComponentType(Class<? extends TrafficAssignmentComponent<?>> trafficAssignmentComponent) throws PlanItException {
        for (Class<TrafficAssignmentComponent<?>> currentClass = trafficAssignmentComponent; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Type currentSuperClass = currentClass.getGenericSuperclass();
            if (!(currentSuperClass instanceof ParameterizedType) || ((ParameterizedType)currentSuperClass).getRawType() != TrafficAssignmentComponent.class) continue;
            TreeSet<String> treeSet = registeredTrafficAssignmentComponents.get(currentClass.getCanonicalName());
            PlanItException.throwIf(treeSet == null, "Base class of traffic assignment component not registered as eligible on PLANit");
            treeSet.add(trafficAssignmentComponent.getCanonicalName());
            registeredTrafficAssignmentComponents.get(currentClass.getCanonicalName()).add(trafficAssignmentComponent.getCanonicalName());
            return;
        }
        throw new PlanItException("trafficAssignmentComponent not eligible for registration");
    }

    public T create(String trafficAssignmentComponentClassName, Object[] constructorParameters) throws PlanItException {
        T newTrafficComponent = this.createTrafficComponent(trafficAssignmentComponentClassName, constructorParameters);
        this.dispatchTrafficComponentEvent(newTrafficComponent, constructorParameters);
        return newTrafficComponent;
    }

    public T create(String trafficAssignmentComponentClassName, Object[] constructorParameters, Object ... eventParameters) throws PlanItException {
        T newTrafficComponent = this.createTrafficComponent(trafficAssignmentComponentClassName, constructorParameters);
        this.dispatchTrafficComponentEvent(newTrafficComponent, eventParameters);
        return newTrafficComponent;
    }

    @Override
    public Serializable getSourceId() {
        return this;
    }

    static {
        registeredTrafficAssignmentComponents.put(Zoning.class.getCanonicalName(), new TreeSet());
        registeredTrafficAssignmentComponents.put(NetworkLoading.class.getCanonicalName(), new TreeSet());
        registeredTrafficAssignmentComponents.put(Smoothing.class.getCanonicalName(), new TreeSet());
        registeredTrafficAssignmentComponents.put(Demands.class.getCanonicalName(), new TreeSet());
        registeredTrafficAssignmentComponents.put(Network.class.getCanonicalName(), new TreeSet());
        registeredTrafficAssignmentComponents.put(AbstractPhysicalCost.class.getCanonicalName(), new TreeSet());
        registeredTrafficAssignmentComponents.put(InitialPhysicalCost.class.getCanonicalName(), new TreeSet());
        registeredTrafficAssignmentComponents.put(AbstractVirtualCost.class.getCanonicalName(), new TreeSet());
        registeredTrafficAssignmentComponents.put(FundamentalDiagram.class.getCanonicalName(), new TreeSet());
        registeredTrafficAssignmentComponents.put(NodeModel.class.getCanonicalName(), new TreeSet());
        registeredTrafficAssignmentComponents.put(PathChoice.class.getCanonicalName(), new TreeSet());
        registeredTrafficAssignmentComponents.put(LogitChoiceModel.class.getCanonicalName(), new TreeSet());
        registeredTrafficAssignmentComponents.put(ODPathSets.class.getCanonicalName(), new TreeSet());
        TrafficAssignmentComponentFactory.registerDefaultImplementations();
    }
}

