/*
 * Decompiled with CFR 0.152.
 */
package org.planit.assignment;

import java.util.logging.Logger;
import org.planit.assignment.TrafficAssignment;
import org.planit.assignment.TrafficAssignmentComponentFactory;
import org.planit.assignment.TrafficAssignmentConfigurator;
import org.planit.assignment.TrafficComponentBuilder;
import org.planit.cost.physical.AbstractPhysicalCost;
import org.planit.cost.virtual.AbstractVirtualCost;
import org.planit.demands.Demands;
import org.planit.gap.GapFunction;
import org.planit.gap.GapFunctionConfigurator;
import org.planit.gap.GapFunctionConfiguratorFactory;
import org.planit.gap.LinkBasedRelativeDualityGapFunction;
import org.planit.gap.LinkBasedRelativeGapConfigurator;
import org.planit.gap.StopCriterion;
import org.planit.input.InputBuilderListener;
import org.planit.interactor.LinkVolumeAccessee;
import org.planit.interactor.LinkVolumeAccessor;
import org.planit.network.InfrastructureNetwork;
import org.planit.output.OutputManager;
import org.planit.output.enums.OutputType;
import org.planit.sdinteraction.smoothing.Smoothing;
import org.planit.supply.networkloading.NetworkLoading;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;
import org.planit.zoning.Zoning;

public abstract class TrafficAssignmentBuilder<T extends TrafficAssignment>
extends TrafficComponentBuilder<T> {
    protected static final Logger LOGGER = Logger.getLogger(TrafficAssignmentBuilder.class.getCanonicalName());

    private void registerDemandZoningAndNetwork(Demands demands, Zoning zoning, InfrastructureNetwork network) throws PlanItException {
        if (zoning == null || demands == null || network == null) {
            PlanItException.throwIf(zoning == null, "zoning in registerDemandZoningAndNetwork is null");
            PlanItException.throwIf(demands == null, "demands in registerDemandZoningAndNetwork is null");
            PlanItException.throwIf(network == null, "network in registerDemandZoningAndNetwork is null");
        }
        PlanItException.throwIf(!zoning.isCompatibleWithDemands(demands, network.modes), "Zoning structure is incompatible with one or more of the demands, likely the number of zones does not match the number of origins and/or destinations");
        for (Mode mode : network.modes) {
            for (TimePeriod timePeriod : demands.timePeriods.asSortedSetByStartTime()) {
                if (demands.get(mode, timePeriod) != null) continue;
                LOGGER.warning("no demand matrix defined for Mode " + mode.getExternalId() + " and Time Period " + timePeriod.getExternalId());
            }
        }
        TrafficAssignmentConfigurator configurator = (TrafficAssignmentConfigurator)this.getConfigurator();
        configurator.setInfrastructureNetwork(network);
        configurator.setZoning(zoning);
        configurator.setDemands(demands);
    }

    private void createOutputManager() {
        TrafficAssignmentConfigurator configurator = (TrafficAssignmentConfigurator)this.getConfigurator();
        configurator.setOutputManager(new OutputManager());
    }

    private void initialiseOutputAdapters(T trafficAssignment) {
        TrafficAssignmentConfigurator configurator = (TrafficAssignmentConfigurator)this.getConfigurator();
        configurator.getOutputManager().initialiseOutputAdapters((TrafficAssignment)trafficAssignment);
    }

    protected T createTrafficAssignmentInstance() throws PlanItException {
        String trafficAssignmentClassName = this.getClassToBuild().getCanonicalName();
        TrafficAssignmentComponentFactory assignmentFactory = new TrafficAssignmentComponentFactory(NetworkLoading.class.getCanonicalName());
        assignmentFactory.addListener(this.getInputBuilderListener(), TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        NetworkLoading networkLoadingAndAssignment = (NetworkLoading)assignmentFactory.create(trafficAssignmentClassName, new Object[]{this.groupId});
        PlanItException.throwIf(!(networkLoadingAndAssignment instanceof TrafficAssignment), "not a valid traffic assignment type");
        return (T)((TrafficAssignment)networkLoadingAndAssignment);
    }

    protected Smoothing createSmoothingInstance(TrafficAssignmentConfigurator<?> configurator) throws PlanItException {
        TrafficAssignmentComponentFactory smoothingFactory = new TrafficAssignmentComponentFactory(Smoothing.class);
        smoothingFactory.addListener(this.getInputBuilderListener(), TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        return (Smoothing)smoothingFactory.create(configurator.getSmoothing().getClassTypeToConfigure().getCanonicalName(), new Object[]{this.getGroupIdToken()});
    }

    protected AbstractPhysicalCost createPhysicalCostInstance(TrafficAssignmentConfigurator<?> configurator) throws PlanItException {
        TrafficAssignmentComponentFactory physicalCostFactory = new TrafficAssignmentComponentFactory(AbstractPhysicalCost.class);
        physicalCostFactory.addListener(this.getInputBuilderListener(), TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        return (AbstractPhysicalCost)physicalCostFactory.create(configurator.getPhysicalCost().getClassTypeToConfigure().getCanonicalName(), new Object[]{this.getGroupIdToken()});
    }

    protected AbstractVirtualCost createVirtualCostInstance(TrafficAssignmentConfigurator<?> configurator) throws PlanItException {
        TrafficAssignmentComponentFactory virtualCostFactory = new TrafficAssignmentComponentFactory(AbstractVirtualCost.class);
        virtualCostFactory.addListener(this.getInputBuilderListener(), TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        return (AbstractVirtualCost)virtualCostFactory.create(configurator.getVirtualCost().getClassTypeToConfigure().getCanonicalName(), new Object[]{this.getGroupIdToken()});
    }

    protected GapFunction createGapFunctionInstance(TrafficAssignmentConfigurator<?> configurator, StopCriterion stopCriterion) throws PlanItException {
        PlanItException.throwIf(!(configurator.getGapFunction() instanceof LinkBasedRelativeGapConfigurator), "invalid gap function chosen");
        return new LinkBasedRelativeDualityGapFunction(stopCriterion);
    }

    protected void buildSubComponents(T trafficAssignmentInstance) throws PlanItException {
        TrafficAssignmentConfigurator configurator = (TrafficAssignmentConfigurator)this.getConfigurator();
        if (configurator.getSmoothing() != null) {
            Smoothing smoothing = this.createSmoothingInstance(configurator);
            configurator.getSmoothing().configure(smoothing);
            ((TrafficAssignment)trafficAssignmentInstance).setSmoothing(smoothing);
        }
        if (configurator.getPhysicalCost() != null) {
            AbstractPhysicalCost physicalCost = this.createPhysicalCostInstance(configurator);
            configurator.getPhysicalCost().configure(physicalCost);
            ((TrafficAssignment)trafficAssignmentInstance).setPhysicalCost(physicalCost);
            if (physicalCost instanceof LinkVolumeAccessor) {
                PlanItException.throwIf(!(trafficAssignmentInstance instanceof LinkVolumeAccessee), "traffic assignment instance is expected to provide link volumes for physical cost by implementing the LinkVolumeAccessee interface");
                ((LinkVolumeAccessor)((Object)physicalCost)).setLinkVolumeAccessee((LinkVolumeAccessee)trafficAssignmentInstance);
            }
        }
        if (configurator.getVirtualCost() != null) {
            AbstractVirtualCost virtualCost = this.createVirtualCostInstance(configurator);
            configurator.getVirtualCost().configure(virtualCost);
            ((TrafficAssignment)trafficAssignmentInstance).setVirtualCost(virtualCost);
            if (virtualCost instanceof LinkVolumeAccessor && trafficAssignmentInstance instanceof LinkVolumeAccessee) {
                PlanItException.throwIf(!(trafficAssignmentInstance instanceof LinkVolumeAccessee), "traffic assignment instance is expected to provide link volumes for virtual cost by implementing the LinkVolumeAccessee interface");
                ((LinkVolumeAccessor)((Object)virtualCost)).setLinkVolumeAccessee((LinkVolumeAccessee)trafficAssignmentInstance);
            }
        }
        if (configurator.getGapFunction() != null) {
            StopCriterion stopCriterion = new StopCriterion();
            configurator.getGapFunction().getStopCriterion().configure(stopCriterion);
            GapFunction gapFunction = this.createGapFunctionInstance(configurator, stopCriterion);
            configurator.getGapFunction().configure(gapFunction);
            ((TrafficAssignment)trafficAssignmentInstance).setGapFunction(gapFunction);
        }
    }

    protected void createGapFunction() throws PlanItException {
        TrafficAssignmentConfigurator configurator = (TrafficAssignmentConfigurator)this.getConfigurator();
        GapFunctionConfigurator<? extends GapFunction> gapFunctionConfigurator = GapFunctionConfiguratorFactory.createConfigurator(GapFunction.LINK_BASED_RELATIVE_GAP);
        configurator.setGapFunction(gapFunctionConfigurator);
    }

    protected TrafficAssignmentBuilder(Class<T> trafficAssignmentClass, IdGroupingToken projectToken, InputBuilderListener inputBuilderListener, Demands demands, Zoning zoning, InfrastructureNetwork network) throws PlanItException {
        super(trafficAssignmentClass, projectToken, inputBuilderListener);
        this.registerDemandZoningAndNetwork(demands, zoning, network);
        this.createOutputManager();
        this.createGapFunction();
        ((TrafficAssignmentConfigurator)this.getConfigurator()).activateOutput(OutputType.LINK);
    }

    @Override
    public T build() throws PlanItException {
        T trafficAssignment = this.createTrafficAssignmentInstance();
        this.buildSubComponents(trafficAssignment);
        this.getConfigurator().configure(trafficAssignment);
        this.initialiseOutputAdapters(trafficAssignment);
        return trafficAssignment;
    }
}

