/*
 * Decompiled with CFR 0.152.
 */
package org.planit.assignment;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.planit.assignment.algorithmb.AlgorithmB;
import org.planit.assignment.eltm.ELTM;
import org.planit.assignment.traditionalstatic.TraditionalStaticAssignment;
import org.planit.cost.physical.AbstractPhysicalCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.virtual.AbstractVirtualCost;
import org.planit.demands.Demands;
import org.planit.gap.GapFunction;
import org.planit.network.InfrastructureNetwork;
import org.planit.network.macroscopic.physical.MacroscopicLinkSegmentImpl;
import org.planit.network.transport.TransportNetwork;
import org.planit.output.OutputManager;
import org.planit.output.adapter.OutputTypeAdapter;
import org.planit.output.enums.OutputType;
import org.planit.sdinteraction.smoothing.Smoothing;
import org.planit.supply.networkloading.NetworkLoading;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.LoggingUtils;
import org.planit.zoning.Zoning;

public abstract class TrafficAssignment
extends NetworkLoading {
    private static final long serialVersionUID = 801775330292422910L;
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentImpl.class.getCanonicalName());
    private Zoning zoning;
    private GapFunction gapFunction;
    private OutputManager outputManager;
    private InfrastructureNetwork network;
    protected TransportNetwork transportNetwork = null;
    protected AbstractVirtualCost virtualCost;
    protected int numberOfNetworkSegments;
    protected int numberOfNetworkVertices;
    protected Smoothing smoothing = null;
    protected Demands demands = null;
    protected InitialLinkSegmentCost initialLinkSegmentCost;
    protected AbstractPhysicalCost physicalCost;
    protected Map<TimePeriod, InitialLinkSegmentCost> initialLinkSegmentCostByTimePeriod = new HashMap<TimePeriod, InitialLinkSegmentCost>();
    public static String TRADITIONAL_STATIC_ASSIGNMENT = TraditionalStaticAssignment.class.getCanonicalName();
    public static String ALGORITHM_B = AlgorithmB.class.getCanonicalName();
    public static String ELTM = ELTM.class.getCanonicalName();

    private void logRegisteredComponent(Object item, boolean register) {
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + LoggingUtils.logActiveStateByClassName(item, register));
    }

    protected String createLoggingPrefix(int iterationIndex) {
        return LoggingUtils.createRunIdPrefix(this.getId()) + LoggingUtils.createIterationPrefix(iterationIndex);
    }

    protected void checkForEmptyComponents() throws PlanItException {
        PlanItException.throwIf(this.demands == null, "Demand is null");
        PlanItException.throwIf(this.network == null, "Network is null");
        PlanItException.throwIf(this.smoothing == null, "Smoothing is null");
        PlanItException.throwIf(this.zoning == null, "Zoning is null");
    }

    protected void verifyComponentCompatibility() throws PlanItException {
    }

    protected void createTransportNetwork() throws PlanItException {
        this.transportNetwork = new TransportNetwork(this.network, this.zoning);
        this.transportNetwork.integrateConnectoidsAndLinks();
        if (this.getTransportNetwork().getTotalNumberOfEdgeSegments() > Integer.MAX_VALUE) {
            throw new PlanItException("currently assignment internals expect to be castable to int, but max value is exceeded for link segments");
        }
        if (this.getTransportNetwork().getTotalNumberOfVertices() > Integer.MAX_VALUE) {
            throw new PlanItException("currently assignment internals expect to be castable to int, but max value is exceeded for vertices");
        }
        this.numberOfNetworkSegments = this.getTransportNetwork().getTotalNumberOfEdgeSegments();
        this.numberOfNetworkVertices = this.getTransportNetwork().getTotalNumberOfVertices();
    }

    protected void disbandTransportNetwork() throws PlanItException {
        this.transportNetwork.removeVirtualNetworkFromPhysicalNetwork();
    }

    protected void initialiseBeforeExecution() throws PlanItException {
        this.checkForEmptyComponents();
        this.createTransportNetwork();
        this.verifyComponentCompatibility();
        this.outputManager.initialiseBeforeSimulation(this.getId());
        this.physicalCost.initialiseBeforeSimulation(this.network);
        this.virtualCost.initialiseBeforeSimulation(this.zoning.getVirtualNetwork());
    }

    protected void finalizeAfterExecution() throws PlanItException {
        this.outputManager.finaliseAfterSimulation();
        this.disbandTransportNetwork();
    }

    protected OutputManager getOutputManager() {
        return this.outputManager;
    }

    public TrafficAssignment(IdGroupingToken groupId) {
        super(groupId);
    }

    public abstract OutputTypeAdapter createOutputTypeAdapter(OutputType var1);

    public abstract void executeEquilibration() throws PlanItException;

    public abstract int getIterationIndex();

    public void execute() throws PlanItException {
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("----------------- %s -----------------", this.getClass().getSimpleName()));
        this.initialiseBeforeExecution();
        this.executeEquilibration();
        this.finalizeAfterExecution();
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("----------------- %s ----------------", this.getClass().getSimpleName()));
    }

    public TransportNetwork getTransportNetwork() {
        return this.transportNetwork;
    }

    public void setSmoothing(Smoothing smoothing) {
        this.logRegisteredComponent(smoothing, true);
        this.smoothing = smoothing;
    }

    public Smoothing getSmoothing() {
        return this.smoothing;
    }

    public void setGapFunction(GapFunction gapfunction) {
        this.logRegisteredComponent(gapfunction, true);
        this.gapFunction = gapfunction;
    }

    public GapFunction getGapFunction() {
        return this.gapFunction;
    }

    public void setInfrastructureNetwork(InfrastructureNetwork network) {
        this.logRegisteredComponent(network, true);
        this.network = network;
    }

    public void setDemands(Demands demands) {
        this.logRegisteredComponent(demands, true);
        this.demands = demands;
    }

    public void setZoning(Zoning zoning) {
        this.logRegisteredComponent(zoning, true);
        this.zoning = zoning;
    }

    public void setInitialLinkSegmentCost(InitialLinkSegmentCost initialLinkSegmentCost) {
        this.initialLinkSegmentCost = initialLinkSegmentCost;
    }

    public void setInitialLinkSegmentCost(TimePeriod timePeriod, InitialLinkSegmentCost initialLinkSegmentCost) {
        this.initialLinkSegmentCostByTimePeriod.put(timePeriod, initialLinkSegmentCost);
    }

    public void setPhysicalCost(AbstractPhysicalCost physicalCost) throws PlanItException {
        this.logRegisteredComponent(physicalCost, true);
        this.physicalCost = physicalCost;
    }

    public AbstractPhysicalCost getPhysicalCost() {
        return this.physicalCost;
    }

    public AbstractVirtualCost getVirtualCost() {
        return this.virtualCost;
    }

    public void setVirtualCost(AbstractVirtualCost virtualCost) throws PlanItException {
        this.logRegisteredComponent(virtualCost, true);
        this.virtualCost = virtualCost;
    }

    public void setOutputManager(OutputManager outputManager) {
        this.outputManager = outputManager;
        outputManager.getOutputFormatters().forEach(of -> this.logRegisteredComponent(of, false));
        outputManager.getRegisteredOutputTypeConfigurations().forEach(oc -> LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + "activated: OutputType." + oc.getOutputType()));
    }
}

