/*
 * Decompiled with CFR 0.152.
 */
package org.planit.algorithms.nodemodel;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Set;
import org.ojalgo.array.Array1D;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;

public class TampereNodeModelFixedInput {
    protected ArrayList<MacroscopicLinkSegment> incomingLinkSegments;
    protected ArrayList<MacroscopicLinkSegment> outgoingLinkSegments;
    protected Array1D<Double> incomingLinkSegmentCapacities;
    protected Array1D<Double> outgoingLinkSegmentReceivingFlows;

    private void mapLinkSegments(ArrayList<MacroscopicLinkSegment> linkSegments, Set<EdgeSegment> edgeSegments) throws PlanItException {
        PlanItException.throwIf(edgeSegments == null, "edge segments to map are null");
        for (EdgeSegment incomingLinkSegment : edgeSegments) {
            PlanItException.throwIf(!(incomingLinkSegment instanceof MacroscopicLinkSegment), "Edges of node are not of type MacroScopicLinkSegment when mapping in Tampere node model");
            linkSegments.add((MacroscopicLinkSegment)incomingLinkSegment);
        }
    }

    private void initialiseWithCapacity(Array1D<Double> arrayToInitialise, ArrayList<MacroscopicLinkSegment> linkSegments) throws PlanItException {
        PlanItException.throwIf(linkSegments == null, "link segments to extract capacity from are null");
        arrayToInitialise = Array1D.PRIMITIVE64.makeZero(linkSegments.size());
        for (MacroscopicLinkSegment linkSegment : linkSegments) {
            ((AbstractList)((Object)arrayToInitialise)).add(linkSegment.computeCapacityPcuH());
        }
    }

    private void mapIncomingLinkSegments(Set<EdgeSegment> incomingEdgeSegments) throws PlanItException {
        this.incomingLinkSegments = new ArrayList(incomingEdgeSegments.size());
        this.mapLinkSegments(this.incomingLinkSegments, incomingEdgeSegments);
    }

    private void mapOutgoingLinkSegments(Set<EdgeSegment> outgoingEdgeSegments) throws PlanItException {
        this.outgoingLinkSegments = new ArrayList(outgoingEdgeSegments.size());
        this.mapLinkSegments(this.outgoingLinkSegments, outgoingEdgeSegments);
    }

    private void initialiseIncomingLinkSegmentCapacities() throws PlanItException {
        this.initialiseWithCapacity(this.incomingLinkSegmentCapacities, this.incomingLinkSegments);
    }

    private void initialiseOutoingLinkSegmentReceivingFlows(boolean initialiseReceivingFlowsAtCapacity) throws PlanItException {
        if (initialiseReceivingFlowsAtCapacity) {
            this.initialiseWithCapacity(this.outgoingLinkSegmentReceivingFlows, this.outgoingLinkSegments);
        } else {
            this.outgoingLinkSegmentReceivingFlows = null;
        }
    }

    public TampereNodeModelFixedInput(Node node, boolean initialiseReceivingFlowsAtCapacity) throws PlanItException {
        this.mapIncomingLinkSegments(node.getEntryEdgeSegments());
        this.mapOutgoingLinkSegments(node.getEntryEdgeSegments());
        this.initialiseIncomingLinkSegmentCapacities();
        this.initialiseOutoingLinkSegmentReceivingFlows(initialiseReceivingFlowsAtCapacity);
    }

    public TampereNodeModelFixedInput(Array1D<Double> incomingLinkSegmentCapacities, Array1D<Double> outgoingLinkSegmentReceivingFlows) throws PlanItException {
        this.incomingLinkSegmentCapacities = incomingLinkSegmentCapacities.copy();
        this.outgoingLinkSegmentReceivingFlows = incomingLinkSegmentCapacities.copy();
    }

    public TampereNodeModelFixedInput(Array1D<Double> incomingLinkSegmentCapacities) throws PlanItException {
        this.incomingLinkSegmentCapacities = incomingLinkSegmentCapacities.copy();
        this.outgoingLinkSegmentReceivingFlows = null;
    }

    public int getNumberOfIncomingLinkSegments() {
        return this.incomingLinkSegmentCapacities.size();
    }

    public int getNumberOfOutgoingLinkSegments() {
        return this.outgoingLinkSegmentReceivingFlows.size();
    }
}

