/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.algebra.VectorSpace;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.TypeUtils;

public final class FillMatchingSingle
extends MatrixOperation {
    public static final FillMatchingSingle SETUP = new FillMatchingSingle();
    public static int THRESHOLD = 256;

    public static void conjugate(BigDecimal[] data, int structure, int firstColumn, int limitColumn, Access2D<?> source) {
        FillMatchingSingle.transpose(data, structure, firstColumn, limitColumn, source);
    }

    public static void conjugate(double[] data, int structure, int firstColumn, int limitColumn, Access2D<?> source) {
        FillMatchingSingle.transpose(data, structure, firstColumn, limitColumn, source);
    }

    public static <N extends Number> void conjugate(N[] data, int structure, int firstColumn, int limitColumn, Access2D<?> source, Scalar.Factory<N> scalar) {
        int index = structure * firstColumn;
        for (int j = firstColumn; j < limitColumn; ++j) {
            for (int i = 0; i < structure; ++i) {
                data[index++] = ((Scalar)((VectorSpace)scalar.cast((Number)source.get(j, i))).conjugate()).get();
            }
        }
    }

    public static void copy(BigDecimal[] data, int structure, int firstColumn, int limitColumn, Access2D<? extends Number> source) {
        int index = structure * firstColumn;
        for (int j = firstColumn; j < limitColumn; ++j) {
            for (int i = 0; i < structure; ++i) {
                data[index++] = TypeUtils.toBigDecimal(source.get(i, j));
            }
        }
    }

    public static void copy(double[] data, int structure, int firstColumn, int limitColumn, Access2D<? extends Number> source) {
        int index = structure * firstColumn;
        for (int j = firstColumn; j < limitColumn; ++j) {
            for (int i = 0; i < structure; ++i) {
                data[index++] = source.doubleValue(i, j);
            }
        }
    }

    public static <N extends Number> void copy(N[] data, int structure, int firstColumn, int limitColumn, Access2D<?> source, Scalar.Factory<N> scalar) {
        int index = structure * firstColumn;
        for (int j = firstColumn; j < limitColumn; ++j) {
            for (int i = 0; i < structure; ++i) {
                data[index++] = scalar.cast((Number)source.get(i, j));
            }
        }
    }

    public static void transpose(BigDecimal[] data, int structure, int firstColumn, int limitColumn, Access2D<?> source) {
        int index = structure * firstColumn;
        for (int j = firstColumn; j < limitColumn; ++j) {
            for (int i = 0; i < structure; ++i) {
                data[index++] = TypeUtils.toBigDecimal(source.get(j, i));
            }
        }
    }

    public static void transpose(double[] data, int structure, int firstColumn, int limitColumn, Access2D<?> source) {
        int index = structure * firstColumn;
        for (int j = firstColumn; j < limitColumn; ++j) {
            for (int i = 0; i < structure; ++i) {
                data[index++] = source.doubleValue(j, i);
            }
        }
    }

    public static <N extends Number> void transpose(N[] data, int structure, int firstColumn, int limitColumn, Access2D<?> source, Scalar.Factory<N> scalar) {
        int index = structure * firstColumn;
        for (int j = firstColumn; j < limitColumn; ++j) {
            for (int i = 0; i < structure; ++i) {
                data[index++] = scalar.cast((Number)source.get(j, i));
            }
        }
    }

    private FillMatchingSingle() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

