/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.ShadingStore;
import org.ojalgo.scalar.Scalar;

final class LowerHessenbergStore<N extends Number>
extends ShadingStore<N> {
    private LowerHessenbergStore(int aRowDim, int aColDim, MatrixStore<N> base) {
        this(base);
        ProgrammingError.throwForIllegalInvocation();
    }

    LowerHessenbergStore(MatrixStore<N> base) {
        super(base, (int)base.countRows(), (int)Math.min(base.countRows(), base.countColumns()));
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row + 1L < col) {
            return PrimitiveMath.ZERO;
        }
        return this.getBase().doubleValue(row, col);
    }

    @Override
    public int firstInColumn(int col) {
        if (col == 0) {
            return 0;
        }
        return col - 1;
    }

    @Override
    public N get(long row, long col) {
        if (row + 1L < col) {
            return this.physical().scalar().zero().get();
        }
        return this.getBase().get(row, col);
    }

    @Override
    public int limitOfRow(int row) {
        return Math.min(row + 2, this.getColDim());
    }

    @Override
    public Scalar<N> toScalar(long row, long col) {
        if (row + 1L < col) {
            return this.physical().scalar().zero();
        }
        return this.getBase().toScalar(row, col);
    }
}

