/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.array.BasicArray;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.DiagonalBasicArray;
import org.ojalgo.matrix.decomposition.TridiagonalDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.structure.Access2D;

class SimultaneousTridiagonal
extends TridiagonalDecomposition<Double> {
    private BasicArray<Double> myDiagD;
    private BasicArray<Double> myDiagE;

    SimultaneousTridiagonal() {
        super(PrimitiveDenseStore.FACTORY);
    }

    @Override
    public boolean decompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        this.setInPlace(matrix);
        int size = this.getMinDim();
        if (this.myDiagD == null || this.myDiagD.count() == (long)size) {
            this.myDiagD = Primitive64Array.make(size);
            this.myDiagE = Primitive64Array.make(size);
        }
        this.getInPlace().tred2(this.myDiagD, this.myDiagE, true);
        return this.computed(true);
    }

    @Override
    protected void supplyDiagonalTo(double[] d, double[] e) {
        this.myDiagD.supplyTo(d);
        this.myDiagE.supplyTo(e);
    }

    @Override
    MatrixStore<Double> makeD() {
        DiagonalBasicArray<Double> tmpAccess = new DiagonalBasicArray<Double>(this.myDiagD, this.myDiagE, this.myDiagE, Double.valueOf(PrimitiveMath.ZERO));
        return this.wrap(tmpAccess).get();
    }

    @Override
    DecompositionStore<Double> makeQ() {
        return this.getInPlace();
    }
}

