/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.math.MathUtil;

public class Distance {
    public static double segmentToSegment(Coordinate A, Coordinate B, Coordinate C, Coordinate D2) {
        if (A.equals(B)) {
            return Distance.pointToSegment(A, C, D2);
        }
        if (C.equals(D2)) {
            return Distance.pointToSegment(D2, A, B);
        }
        boolean noIntersection = false;
        if (!Envelope.intersects(A, B, C, D2)) {
            noIntersection = true;
        } else {
            double denom = (B.x - A.x) * (D2.y - C.y) - (B.y - A.y) * (D2.x - C.x);
            if (denom == 0.0) {
                noIntersection = true;
            } else {
                double r_num = (A.y - C.y) * (D2.x - C.x) - (A.x - C.x) * (D2.y - C.y);
                double s_num = (A.y - C.y) * (B.x - A.x) - (A.x - C.x) * (B.y - A.y);
                double s = s_num / denom;
                double r = r_num / denom;
                if (r < 0.0 || r > 1.0 || s < 0.0 || s > 1.0) {
                    noIntersection = true;
                }
            }
        }
        if (noIntersection) {
            return MathUtil.min(Distance.pointToSegment(A, C, D2), Distance.pointToSegment(B, C, D2), Distance.pointToSegment(C, A, B), Distance.pointToSegment(D2, A, B));
        }
        return 0.0;
    }

    public static double pointToSegmentString(Coordinate p, Coordinate[] line) {
        if (line.length == 0) {
            throw new IllegalArgumentException("Line array must contain at least one vertex");
        }
        double minDistance = p.distance(line[0]);
        for (int i = 0; i < line.length - 1; ++i) {
            double dist = Distance.pointToSegment(p, line[i], line[i + 1]);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    public static double pointToSegment(Coordinate p, Coordinate A, Coordinate B) {
        if (A.x == B.x && A.y == B.y) {
            return p.distance(A);
        }
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y);
        double r = ((p.x - A.x) * (B.x - A.x) + (p.y - A.y) * (B.y - A.y)) / len2;
        if (r <= 0.0) {
            return p.distance(A);
        }
        if (r >= 1.0) {
            return p.distance(B);
        }
        double s = ((A.y - p.y) * (B.x - A.x) - (A.x - p.x) * (B.y - A.y)) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }

    public static double pointToLinePerpendicular(Coordinate p, Coordinate A, Coordinate B) {
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y);
        double s = ((A.y - p.y) * (B.x - A.x) - (A.x - p.x) * (B.y - A.y)) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }
}

