/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.Classes;
import org.geotools.util.logging.Logging;

public class LoggedFormat<T>
extends Format {
    private static final long serialVersionUID = 4578880360344271325L;
    private final Format format;
    private final Class<T> type;
    private Level level;
    private String logger;
    private String className;
    private String methodName;

    protected LoggedFormat(Format format, Class<T> type) {
        this.format = format;
        this.type = type;
        this.level = Level.WARNING;
    }

    public static <T> LoggedFormat<T> getInstance(Format format, Class<T> type) {
        return new LoggedFormat<T>(format, type);
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public void setLevel(Level level) {
        if (level != null) {
            this.level = level;
        }
    }

    public void setCaller(Class<?> caller, String method) {
        this.className = caller != null ? caller.getName() : null;
        this.methodName = method;
    }

    public T parse(String text) {
        if (text == null || (text = text.trim()).length() == 0) {
            return null;
        }
        ParsePosition position = new ParsePosition(0);
        Object value = this.parseObject(text, position);
        int index = position.getIndex();
        int error = position.getErrorIndex();
        if (error >= 0 && error < index) {
            index = error;
        }
        if (index < text.length()) {
            this.doLogWarning(LoggedFormat.formatUnparsable(text, 0, index, this.getWarningLocale(), this.level));
        } else if (value != null && !this.type.isInstance(value)) {
            this.doLogWarning(Errors.getResources(this.getWarningLocale()).getLogRecord(this.level, 61, value.getClass(), this.type));
            return null;
        }
        return this.type.cast(value);
    }

    @Override
    public Object parseObject(String text) throws ParseException {
        return this.format.parseObject(text);
    }

    @Override
    public Object parseObject(String text, ParsePosition position) {
        return this.format.parseObject(text, position);
    }

    @Override
    public StringBuffer format(Object value, StringBuffer toAppendTo, FieldPosition position) {
        return this.format.format(value, toAppendTo, position);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object value) {
        return this.format.formatToCharacterIterator(value);
    }

    private void doLogWarning(LogRecord warning) {
        if (this.className != null) {
            warning.setSourceClassName(this.className);
        }
        if (this.methodName != null) {
            warning.setSourceMethodName(this.methodName);
        }
        this.logWarning(warning);
    }

    protected void logWarning(LogRecord warning) {
        if (this.logger != null) {
            Logger logger = Logging.getLogger(this.logger);
            warning.setLoggerName(logger.getName());
            logger.log(warning);
        }
    }

    protected Locale getWarningLocale() {
        return Locale.getDefault();
    }

    public static String formatUnparsable(String text, int index, int errorIndex, Locale locale) {
        return (String)LoggedFormat.doFormatUnparsable(text, index, errorIndex, locale, null);
    }

    public static LogRecord formatUnparsable(String text, int index, int errorIndex, Locale locale, Level level) {
        if (level == null) {
            level = Level.WARNING;
        }
        return (LogRecord)LoggedFormat.doFormatUnparsable(text, index, errorIndex, locale, level);
    }

    private static Object doFormatUnparsable(String text, int index, int errorIndex, Locale locale, Level level) {
        Errors resources = Errors.getResources(locale);
        int length = text.length();
        if (errorIndex < index) {
            errorIndex = index;
        }
        if (errorIndex == length) {
            if (level != null) {
                return resources.getLogRecord(level, 174);
            }
            return resources.getString(174);
        }
        int upper = errorIndex;
        if (upper < length) {
            int type = Character.getType(text.charAt(upper));
            while (++upper < length && Character.getType(text.charAt(upper)) == type) {
            }
        }
        String error = text.substring(errorIndex, upper);
        text = text.substring(index);
        if (level != null) {
            return resources.getLogRecord(level, 192, text, error);
        }
        return resources.getString(192, text, error);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(this)).append('[').append(Classes.getShortClassName(this.format));
        if (this.logger != null) {
            buffer.append(", logger=").append(this.logger);
        }
        return buffer.append(']').toString();
    }
}

