/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.event.ref;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.djutils.event.ref.Reference;
import org.pmw.tinylog.Logger;

public class StrongReference<T extends Serializable>
extends Reference<T> {
    private static final long serialVersionUID = 20191230L;
    private final transient T referent;

    public StrongReference(T referent) {
        this.referent = referent;
    }

    @Override
    public final T get() {
        return this.referent;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.get());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            Field field = this.getClass().getDeclaredField("referent");
            field.setAccessible(true);
            field.set(this, in.readObject());
            field.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            Logger.error((Throwable)exception, "Error using ReadObject on StrongReference");
        }
    }
}

