from setuptools import setup

setup(
    name = 'asciibars', 
    version = '0.0.3',
    description = 'Bar charts in ASCII',
    py_modules = ["asciibars"],
    package_dir = {'':'src'},
    author = 'Andrea Bonetti',
    author_email = '',
    long_description = open('README.md').read() + '\n\n' + open('CHANGELOG.md').read(),
    long_description_content_type = "text/markdown",
    url='https://github.com/andreabonetti/asciibars',
    include_package_data=True,
    classifiers  = [
        'Development Status :: 3 - Alpha',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.0',
        'Programming Language :: Python :: 3.1',
        'Programming Language :: Python :: 3.2',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: 3.11',
        'Programming Language :: Python :: 3.12',
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        'Intended Audience :: Developers',
        'Intended Audience :: Education',
        'Intended Audience :: Information Technology',
        'Intended Audience :: Other Audience',
        'Intended Audience :: Science/Research',
        'Topic :: Text Processing',
        'Topic :: Documentation',
        'Topic :: Office/Business',
        'Topic :: Other/Nonlisted Topic',
        'Topic :: Printing',
        'Topic :: Scientific/Engineering :: Visualization',
        'Topic :: Software Development :: Documentation',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Operating System :: Microsoft :: Windows',
        'Operating System :: OS Independent',
        'Operating System :: MacOS',
        'Operating System :: Unix',
    ],
    install_requires = [
    ],
    keywords = [
        'Documentation',
        'Bar chart',
        'Plot',
        'Python module',
        'Visualization',
    ],
)
