"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const kong_core = require("kong-core");
// import * as kong_core from '../../kong-core/';
const index_1 = require("./resources/helm-charts/kong/index");
const index_2 = require("./resources/helm-charts/private-ca/index");
/**
 * @summary The KongEks class.
 */
class KongEks extends constructs_1.Construct {
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        this.clusterDns = `cluster.${props.hostedZoneName}`;
        this.telemetryDns = `telemetry.${props.hostedZoneName}`;
        const control_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'CPSecretsKey');
        this.controlPlane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'CP', {
            ...props.controlPlaneClusterProps,
            secretsEncryptionKey: control_plane_secretskey,
            defaultCapacity: 0,
        });
        const cp_nodegroup = this.controlPlane.addNodegroupCapacity('CpASG', props.controlPlaneNodeProps);
        cp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: 'kube-system',
        });
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: this.controlPlane,
        //   nodegroup: cp_nodegroup,
        // });
        new kong_core.MetricsServer(this, 'MetricsServer', {
            cluster: this.controlPlane,
        });
        const kong_rds_instance = new kong_core.RdsStack(this, 'KongRds', {
            vpc: this.controlPlane.vpc,
            databasename: props.rdsProps.databasename,
            postgresversion: props.rdsProps.postgresversion,
            username: props.rdsProps.username,
        });
        const private_ca_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPcaNestedStack');
        const private_ca = new index_2.PrivateCA(private_ca_nested_stack, 'KongPCA', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: props.namespace,
            cacertname: kong_core.Tls.KONG_CP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            // commonname: 'www.dummy.com',
            hostedZoneName: 'kong-cp.internal',
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
        });
        this.privateCaArn = private_ca.private_ca_arn;
        const kong_control_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongCpNestedStack');
        new index_1.KongControlPlane(kong_control_plane_nested_stack, 'KongCPHelmInstall', {
            cluster: this.controlPlane,
            rds: kong_rds_instance.kongPostgresSql,
            namespace: props.namespace,
            nodegroup: cp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.KONG_CP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            // commonname: 'www.dummy.com',
            hostedZoneName: 'kong-cp.internal',
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
        });
        kong_control_plane_nested_stack.node.addDependency(private_ca_nested_stack, kong_rds_instance);
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryNestedStack');
        new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            cluster: this.controlPlane,
            namespace: kong_core.Namespace.TELEMETRY,
            cacertname: kong_core.Tls.ADOT_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
            hostedZoneName: props.hostedZoneName,
        });
        telemetry_nested_stack.node.addDependency(private_ca_nested_stack);
        // telemetry.node.addDependency(private_ca_nested_stack.node);
        // telemetry.node.findAll().forEach (function (value) {
        //   value.node.addDependency(private_ca.node.findChild(''));
        // });
    }
    ;
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-control-plane.KongEks", version: "2.0.5" };
//# sourceMappingURL=data:application/json;base64,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