# Easy LUT Init String manipulation

You only need two things:

1. A pin mapping given by rapidwright.
2. An initstring in hex format like `"0x0123456789ABCDEF"`

Then by using the following you can obtain the init string found in the bitstream
```python
from lutstrings import lut
bitstream_init_string = lut.fullConversion(pin_mapping, init_string)
```


The pin mapping can be obtained using rapidwright from a LUT cell with

```python
pin_mapping = cell_lut.getPinMappingsL2P()
```

Currently works for any number input luts

### Testing

A self test can be run by running pytest in the lutstrings/lutstrings directory

```python
PYTHONPATH=. pytest
```

or by simply running the test file

```python
python3 test_init_string.py
```