import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
    * The user’s alias. For example, jsmith.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user#alias User#alias}
    */
    readonly alias: string;
    /**
    * The user’s email address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user#email User#email}
    */
    readonly email: string;
    /**
    * The email encoding for the user, such as ISO-8859-1 or UTF-8. Defaults to UTF-8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user#email_encoding_key User#email_encoding_key}
    */
    readonly emailEncodingKey?: string;
    /**
    * The user’s language. Defaults to en_US.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user#language_locale_key User#language_locale_key}
    */
    readonly languageLocaleKey?: string;
    /**
    * The user’s last name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user#last_name User#last_name}
    */
    readonly lastName: string;
    /**
    * The value of the field affects formatting and parsing of values, especially numeric values, in the user interface. It doesn’t affect the API. The field values are named according to the language, and the country if necessary, using two-letter ISO codes. The set of names is based on the ISO standard. You can also manually set a user’s locale in the user interface, and then use that value for inserting or updating other users via the API. Defaults to en_US.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user#locale_sid_key User#locale_sid_key}
    */
    readonly localeSidKey?: string;
    /**
    * ID of the user’s Profile. Use this value to cache metadata based on profile.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user#profile_id User#profile_id}
    */
    readonly profileId: string;
    /**
    * Reset password and send an email to the user. No reset is performed if this field is omitted, is false, or was true and remained true on subsequent apply. Please set to false and then true in subsequent applies, or have it set to true on create to trigger the reset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user#reset_password User#reset_password}
    */
    readonly resetPassword?: boolean | cdktf.IResolvable;
    /**
    * A User time zone affects the offset used when displaying or entering times in the user interface. But the API doesn’t use a User time zone when querying or setting values. Values for this field are named using region and key city, according to ISO standards. You can also manually set one User time zone in the user interface, and then use that value for creating or updating other User records via the API. Defaults to America/New_York.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user#time_zone_sid_key User#time_zone_sid_key}
    */
    readonly timeZoneSidKey?: string;
    /**
    * ID of the user’s UserRole.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user#user_role_id User#user_role_id}
    */
    readonly userRoleId?: string;
    /**
    * Contains the name that a user enters to log in to the API or the user interface. The value for this field must be in the form of an email address, using all lowercase characters. It must also be unique across all organizations. If you try to create or update a User with a duplicate value for this field, the operation is rejected. Each inserted User also counts as a license. Every organization has a maximum number of licenses. If you attempt to exceed the maximum number of licenses by inserting User records, the create request is rejected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user#username User#username}
    */
    readonly username: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/salesforce/r/user salesforce_user}
*/
export declare class User extends cdktf.TerraformResource {
    static readonly tfResourceType = "salesforce_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/salesforce/r/user salesforce_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope: Construct, id: string, config: UserConfig);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    get aliasInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _emailEncodingKey?;
    get emailEncodingKey(): string;
    set emailEncodingKey(value: string);
    resetEmailEncodingKey(): void;
    get emailEncodingKeyInput(): string | undefined;
    get id(): string;
    private _languageLocaleKey?;
    get languageLocaleKey(): string;
    set languageLocaleKey(value: string);
    resetLanguageLocaleKey(): void;
    get languageLocaleKeyInput(): string | undefined;
    private _lastName?;
    get lastName(): string;
    set lastName(value: string);
    get lastNameInput(): string | undefined;
    private _localeSidKey?;
    get localeSidKey(): string;
    set localeSidKey(value: string);
    resetLocaleSidKey(): void;
    get localeSidKeyInput(): string | undefined;
    private _profileId?;
    get profileId(): string;
    set profileId(value: string);
    get profileIdInput(): string | undefined;
    private _resetPassword?;
    get resetPassword(): boolean | cdktf.IResolvable;
    set resetPassword(value: boolean | cdktf.IResolvable);
    resetResetPassword(): void;
    get resetPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _timeZoneSidKey?;
    get timeZoneSidKey(): string;
    set timeZoneSidKey(value: string);
    resetTimeZoneSidKey(): void;
    get timeZoneSidKeyInput(): string | undefined;
    private _userRoleId?;
    get userRoleId(): string;
    set userRoleId(value: string);
    resetUserRoleId(): void;
    get userRoleIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
