import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The unique name of the object in the API. This name can contain only underscores and alphanumeric characters, and must be unique in your org. It must begin with a letter, not include spaces, not end with an underscore, and not contain two consecutive underscores. In managed packages, this field prevents naming conflicts on package installations. With this field, a developer can change the object’s name in a managed package and the changes are reflected in a subscriber’s organization. Corresponds to Role Name in the user interface.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user_role#developer_name UserRole#developer_name}
    */
    readonly developerName: string;
    /**
    * Name of the role. Corresponds to Label on the user interface.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user_role#name UserRole#name}
    */
    readonly name: string;
    /**
    * The ID of the parent role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/salesforce/r/user_role#parent_role_id UserRole#parent_role_id}
    */
    readonly parentRoleId?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/salesforce/r/user_role salesforce_user_role}
*/
export declare class UserRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "salesforce_user_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/salesforce/r/user_role salesforce_user_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserRoleConfig
    */
    constructor(scope: Construct, id: string, config: UserRoleConfig);
    private _developerName?;
    get developerName(): string;
    set developerName(value: string);
    get developerNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parentRoleId?;
    get parentRoleId(): string;
    set parentRoleId(value: string);
    resetParentRoleId(): void;
    get parentRoleIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
