# FElupe - Finite Element Analysis

[![PyPI version shields.io](https://img.shields.io/pypi/v/felupe.svg)](https://pypi.python.org/pypi/felupe/) [![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0) ![Made with love in Graz (Austria)](https://camo.githubusercontent.com/a544d346292339f9c32365b654a582020955e8b33cb0ed2ac3b7390c49b283f0/68747470733a2f2f6d616465776974686c6f76652e6e6f772e73682f61743f68656172743d7472756526636f6c6f72423d25323331663734346626746578743d4772617a2b25323841757374726961253239) ![Codestyle black](https://img.shields.io/badge/code%20style-black-black)

![FElupe](https://raw.githubusercontent.com/adtzlr/felupe/main/docs/images/felupe_logo.svg)

FElupe is an open-source finite element package focussing on the formulation and numerical solution of nonlinear problems in continuum mechanics of solid bodies. Its name is a combination of FE (finite element) and the german word *Lupe* (magnifying glass) as a synonym for getting a little insight how a finite element analysis code looks like under the hood.

## Installation
Install Python, fire up a terminal and run `pip install felupe`; import FElupe as follows in your script.

```python
import felupe as fe
```

## Documentation
The documentation is located [here](https://adtzlr.github.io/felupe).

## License
FElupe - finite element analysis (C) 2021 Andreas Dutzler, Graz (Austria).

This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.