# Generated by Django 2.2.4 on 2019-08-14 14:55

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="EventType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("verb", models.CharField(max_length=255, null=True, unique=True)),
                ("enabled", models.BooleanField(default=True, verbose_name="enabled")),
            ],
            options={
                "verbose_name": "event type",
                "verbose_name_plural": "event types",
                "ordering": ("verb",),
            },
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "actor_object_id",
                    models.PositiveIntegerField(
                        null=True, verbose_name="actor object id"
                    ),
                ),
                (
                    "verb",
                    models.CharField(max_length=255, null=True, verbose_name="verb"),
                ),
                (
                    "trigger_object_id",
                    models.PositiveIntegerField(
                        blank=True, null=True, verbose_name="trigger object id"
                    ),
                ),
                (
                    "target_object_id",
                    models.PositiveIntegerField(
                        blank=True, null=True, verbose_name="target object id"
                    ),
                ),
                (
                    "notified",
                    models.BooleanField(default=False, verbose_name="notified"),
                ),
                (
                    "actor_content_type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="actor_actions",
                        to="contenttypes.ContentType",
                        verbose_name="actor content type",
                    ),
                ),
                (
                    "target_content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="target_actions",
                        to="contenttypes.ContentType",
                        verbose_name="target content type",
                    ),
                ),
                (
                    "trigger_content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="trigger_actions",
                        to="contenttypes.ContentType",
                        verbose_name="trigger content type",
                    ),
                ),
            ],
            options={"verbose_name": "event", "verbose_name_plural": "events"},
        ),
        migrations.CreateModel(
            name="Notification",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("sent", models.BooleanField(default=False, verbose_name="sent")),
                (
                    "received",
                    models.BooleanField(default=False, verbose_name="received"),
                ),
                ("read", models.BooleanField(default=False, verbose_name="read")),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notifications",
                        to="snitch.Event",
                        verbose_name="event",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notifications",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "notification",
                "verbose_name_plural": "notifications",
                "ordering": ("-created",),
                "abstract": False,
                "swappable": "SNITCH_NOTIFICATION_MODEL",
            },
        ),
    ]
