places_dict = {
    'Alabama': {'lat': 33.2588817, 'lon': -86.8295337,
                'cities': {'Anniston': {'lat': 33.6594422, 'lon': -85.8316326},
                           'Birmingham': {'lat': 33.5206824, 'lon': -86.8024326},
                           'Decatur': {'lat': 34.623709, 'lon': -87.06705096491828},
                           'Dothan': {'lat': 31.2237434, 'lon': -85.3933906},
                           'Huntsville': {'lat': 34.729847, 'lon': -86.5859011},
                           'Mobile': {'lat': 30.6943566, 'lon': -88.0430541},
                           'Montgomery': {'lat': 32.3669656, 'lon': -86.3006485},
                           'Selma': {'lat': 32.4078632, 'lon': -87.0207473},
                           'Tuscaloosa': {'lat': 33.2095614, 'lon': -87.5675258}}},
    'Alaska': {'lat': 64.4459613, 'lon': -149.680909,
               'cities': {'Anchorage': {'lat': 61.2163129, 'lon': -149.894852}}},
    'Arizona': {'lat': 34.395342, 'lon': -111.763275,
                'cities': {'Apache Junction': {'lat': 33.4150485, 'lon': -111.549577},
                           'Avondale': {'lat': 33.4355977, 'lon': -112.349602},
                           'Buckeye': {'lat': 33.3703197, 'lon': -112.5837766},
                           'Casa Grande': {'lat': 32.8795022, 'lon': -111.7573521},
                           'Chandler': {'lat': 33.3061605, 'lon': -111.84125},
                           'El Mirage': {'lat': 33.6130338, 'lon': -112.3244866},
                           'Gilbert': {'lat': 33.3527632, 'lon': -111.7890373},
                           'Goodyear': {'lat': 33.4353672, 'lon': -112.3576005},
                           'Greer': {'lat': 34.0100477, 'lon': -109.4587014},
                           'Litchfield Park': {'lat': 33.4933796, 'lon': -112.3581244},
                           'Maricopa': {'lat': 33.34883, 'lon': -112.49123},
                           'Mesa': {'lat': 33.4151117, 'lon': -111.8314792},
                           'Phoenix': {'lat': 33.4484367, 'lon': -112.0741417},
                           'Queen Creek': {'lat': 33.2483858, 'lon': -111.6341585},
                           'San Tan Valley': {'lat': 33.1775233, 'lon': -111.5478925},
                           'Scottsdale': {'lat': 33.4942189, 'lon': -111.9260184},
                           'Sierra Vista': {'lat': 31.5455709, 'lon': -110.2772249},
                           'Sun City': {'lat': 33.6290111, 'lon': -112.2819337},
                           'Surprise': {'lat': 33.6292271, 'lon': -112.3680189},
                           'Tempe': {'lat': 33.4255056, 'lon': -111.9400091},
                           'Tolleson': {'lat': 33.4500497, 'lon': -112.2593093},
                           'Tucson': {'lat': 32.2228765, 'lon': -110.9748477},
                           'Yuma': {'lat': 32.665135, 'lon': -114.47603157249804}}},
    'Arkansas': {'lat': 35.2048883, 'lon': -92.4479108,
                 'cities': {'El Dorado': {'lat': 33.20763, 'lon': -92.6662674},
                            'Fayetteville': {'lat': 36.0625843, 'lon': -94.1574328},
                            'Fort Smith': {'lat': 35.3872218, 'lon': -94.4248983},
                            'Ft. Smith': {'lat': 35.3872218, 'lon': -94.4248983},
                            'Jonesboro': {'lat': 35.8428646, 'lon': -90.7034522},
                            'Little Rock': {'lat': 34.7464809, 'lon': -92.2895948},
                            'Pine Bluff': {'lat': 34.2157064, 'lon': -92.0140402},
                            'Rogers': {'lat': 36.3320197, 'lon': -94.1185366},
                            'Springdale': {'lat': 36.1867442, 'lon': -94.1288142}}},
    'California': {'lat': 36.7014631, 'lon': -118.755997,
                   'cities': {'Alameda': {'lat': 37.6090291, 'lon': -121.899142},
                              'Alhambra': {'lat': 34.093042, 'lon': -118.12706},
                              'Anaheim': {'lat': 33.8347516, 'lon': -117.911732},
                              'Antioch': {'lat': 38.0049214, 'lon': -121.805789},
                              'Apple Valley': {'lat': 34.5008311, 'lon': -117.1858759},
                              'Arcadia': {'lat': 34.1362075, 'lon': -118.0401497},
                              'Azusa': {'lat': 34.1338751, 'lon': -117.9056046},
                              'Bakersfield': {'lat': 35.3738712, 'lon': -119.0194639},
                              'Baldwin Park': {'lat': 34.0854739, 'lon': -117.9611761},
                              'Bellflower': {'lat': 33.8825705, 'lon': -118.1167679},
                              'Beverly Hills': {'lat': 34.0696501, 'lon': -118.3963062},
                              'Brea': {'lat': 33.9170444, 'lon': -117.888855},
                              'Buena Park': {'lat': 33.870413, 'lon': -117.9962165},
                              'Burbank': {'lat': 34.1816482, 'lon': -118.3258554},
                              'Carlsbad': {'lat': 33.1580933, 'lon': -117.3505966},
                              'Carson': {'lat': 33.8322043, 'lon': -118.2517547},
                              'Castro Valley': {'lat': 37.71573685, 'lon': -122.09063177147789},
                              'Ceres': {'lat': 37.5949316, 'lon': -120.9577098},
                              'Cerritos': {'lat': 33.8644291, 'lon': -118.0539323},
                              'Chico': {'lat': 39.7284945, 'lon': -121.8374777},
                              'Chino': {'lat': 34.0133561, 'lon': -117.690075},
                              'Chino Hills': {'lat': 33.9926803, 'lon': -117.760056},
                              'Chula Vista': {'lat': 32.6400541, 'lon': -117.0841955},
                              'Citrus Heights': {'lat': 38.7071247, 'lon': -121.2810611},
                              'City of Industry': {'lat': 34.005, 'lon': -117.939},
                              'Claremont': {'lat': 34.0966764, 'lon': -117.7197785},
                              'Clovis': {'lat': 36.8252277, 'lon': -119.7029194},
                              'Colton': {'lat': 34.0739016, 'lon': -117.3136547},
                              'Compton': {'lat': 33.894927, 'lon': -118.226624},
                              'Corona': {'lat': 33.8752945, 'lon': -117.5664449},
                              'Costa Mesa': {'lat': 33.6633386, 'lon': -117.903317},
                              'Cudahy': {'lat': 33.9620584, 'lon': -118.1835395},
                              'Cypress': {'lat': 33.8248235, 'lon': -118.0399368},
                              'Daly City': {'lat': 37.6904826, 'lon': -122.4726708},
                              'Diamond Bar': {'lat': 34.0286226, 'lon': -117.8103367},
                              'Downey': {'lat': 33.942215, 'lon': -118.1235646},
                              'East Los Angeles': {'lat': 34.0239015, 'lon': -118.1720157},
                              'El Cajon': {'lat': 32.7947731, 'lon': -116.9625269},
                              'El Centro': {'lat': 32.792, 'lon': -115.5630514},
                              'El Monte': {'lat': 34.0751571, 'lon': -118.036849},
                              'Elk Grove': {'lat': 38.4087993, 'lon': -121.3716178},
                              'Escondido': {'lat': 33.1216751, 'lon': -117.0814849},
                              'Eureka': {'lat': 40.8020712, 'lon': -124.1636729},
                              'Fairfield': {'lat': 38.2493581, 'lon': -122.039966},
                              'Fallbrook': {'lat': 33.3764196, 'lon': -117.2511466},
                              'Fontana': {'lat': 34.0922335, 'lon': -117.435048},
                              'Fountain Valley': {'lat': 33.7038145, 'lon': -117.9627349},
                              'Fremont': {'lat': 37.5482697, 'lon': -121.9885719},
                              'Fresno': {'lat': 36.7394421, 'lon': -119.7848307},
                              'Fullerton': {'lat': 33.8708215, 'lon': -117.9294165},
                              'Garden Grove': {'lat': 33.7746292, 'lon': -117.9463717},
                              'Gardena': {'lat': 33.8963593, 'lon': -118.3053037},
                              'Glendale': {'lat': 34.1469416, 'lon': -118.2478471},
                              'Glendora': {'lat': 34.1361187, 'lon': -117.865339},
                              'Hacienda Heights': {'lat': 33.9930677, 'lon': -117.968675},
                              'Hawthorne': {'lat': 33.9188589, 'lon': -118.3483256},
                              'Hayward': {'lat': 37.6688205, 'lon': -122.080796},
                              'Hemet': {'lat': 33.7475203, 'lon': -116.9719684},
                              'Hesperia': {'lat': 34.4263886, 'lon': -117.3008784},
                              'Highland': {'lat': 34.1283442, 'lon': -117.2086513},
                              'Huntington Beach': {'lat': 33.6783336, 'lon': -118.0000166},
                              'Huntington Park': {'lat': 33.9827043, 'lon': -118.2120343},
                              'Imperial Beach': {'lat': 32.5839444, 'lon': -117.1130849},
                              'Inglewood': {'lat': 33.9562003, 'lon': -118.353132},
                              'Irvine': {'lat': 33.6856969, 'lon': -117.8259819},
                              'Jurupa Valley': {'lat': 33.9798472, 'lon': -117.4515754},
                              'La Habra': {'lat': 33.9316066, 'lon': -117.9454867},
                              'La Mesa': {'lat': 32.7678288, 'lon': -117.0230839},
                              'La Mirada': {'lat': 33.9060971, 'lon': -118.0107092},
                              'La Puente': {'lat': 34.01979, 'lon': -117.9503677},
                              'La Verne': {'lat': 34.1008426, 'lon': -117.7678355},
                              'Lake Elsinore': {'lat': 33.6680772, 'lon': -117.3272615},
                              'Lemon Grove': {'lat': 32.7425516, 'lon': -117.0314172},
                              'Livermore': {'lat': 37.6820583, 'lon': -121.7680531},
                              'Lodi': {'lat': 38.097198, 'lon': -121.3878496465736},
                              'Long Beach': {'lat': 33.7690164, 'lon': -118.191604},
                              'Los Angeles': {'lat': 34.0536909, 'lon': -118.242766},
                              'Lynwood': {'lat': 33.924831, 'lon': -118.2024154},
                              'Manteca': {'lat': 37.7986184, 'lon': -121.2117148},
                              'Menifee': {'lat': 33.6864432, 'lon': -117.1770437},
                              'Merced': {'lat': 37.1641544, 'lon': -120.7678602},
                              'Milpitas': {'lat': 37.4282724, 'lon': -121.9066238},
                              'Mission Viejo': {'lat': 33.5965685, 'lon': -117.659405},
                              'Modesto': {'lat': 37.6390972, 'lon': -120.9968782},
                              'Monrovia': {'lat': 34.1483499, 'lon': -118.0014517},
                              'Montebello': {'lat': 34.0159398, 'lon': -118.111975},
                              'Monterey': {'lat': 36.2231079, 'lon': -121.3877428},
                              'Monterey Park': {'lat': 34.051522, 'lon': -118.129807},
                              'Moreno Valley': {'lat': 33.937517, 'lon': -117.2305944},
                              'Mountain View': {'lat': 37.3893889, 'lon': -122.0832101},
                              'Murrieta': {'lat': 33.577752399999994, 'lon': -117.18845420205307},
                              'National City': {'lat': 32.6781085, 'lon': -117.0991967},
                              'Newport Beach': {'lat': 33.6170092, 'lon': -117.9294401},
                              'Norco': {'lat': 33.9323307, 'lon': -117.5508901},
                              'Oakland': {'lat': 37.8044557, 'lon': -122.2713563},
                              'Oceanside': {'lat': 33.1958696, 'lon': -117.3794834},
                              'Orange': {'lat': 33.7500378, 'lon': -117.8704931},
                              'Oxnard': {'lat': 34.1976308, 'lon': -119.1803818},
                              'Palm Springs': {'lat': 33.772179449999996, 'lon': -116.49529769785079},
                              'Palmdale': {'lat': 34.5793131, 'lon': -118.1171108},
                              'Palo Alto': {'lat': 37.4443293, 'lon': -122.1598465},
                              'Paramount': {'lat': 33.898917, 'lon': -118.171005},
                              'Pasadena': {'lat': 34.1476452, 'lon': -118.1444779},
                              'Perris': {'lat': 33.7825194, 'lon': -117.2286478},
                              'Pico Rivera': {'lat': 33.9830688, 'lon': -118.096735},
                              'Pittsburg': {'lat': 38.0181745, 'lon': -121.8901232},
                              'Pleasanton': {'lat': 37.6624312, 'lon': -121.8746789},
                              'Pomona': {'lat': 34.0553813, 'lon': -117.7517496},
                              'Poway': {'lat': 32.9628234, 'lon': -117.0358646},
                              'Rancho Cordova': {'lat': 38.5890723, 'lon': -121.302728},
                              'Rancho Cucamonga': {'lat': 34.1033192, 'lon': -117.5751735},
                              'Redding': {'lat': 40.5863563, 'lon': -122.3916754},
                              'Redlands': {'lat': 34.0550328, 'lon': -117.1827445},
                              'Redondo Beach': {'lat': 33.8455911, 'lon': -118.3886766},
                              'Redwood City': {'lat': 37.4863239, 'lon': -122.232523},
                              'Rialto': {'lat': 34.1064001, 'lon': -117.3703235},
                              'Riverside': {'lat': 33.9533546, 'lon': -117.3961623},
                              'Rosemead': {'lat': 34.0676169, 'lon': -118.0879763},
                              'Roseville': {'lat': 38.7521235, 'lon': -121.2880059},
                              'Rowland Heights': {'lat': 33.9761238, 'lon': -117.905339},
                              'Sacramento': {'lat': 38.5810606, 'lon': -121.4938951},
                              'Salinas': {'lat': 36.6744117, 'lon': -121.6550372},
                              'San Bernardino': {'lat': 34.8253019, 'lon': -116.0833144},
                              'San Diego': {'lat': 32.7174202, 'lon': -117.1627728},
                              'San Dimas': {'lat': 34.1066756, 'lon': -117.8067257},
                              'San Fernando': {'lat': 34.28497, 'lon': -118.437652},
                              'San Francisco': {'lat': 37.7790262, 'lon': -122.419906},
                              'San Jose': {'lat': 37.3361905, 'lon': -121.890583},
                              'San Leandro': {'lat': 37.7249296, 'lon': -122.1560768},
                              'San Lorenzo': {'lat': 37.673589500000006, 'lon': -122.13185702134774},
                              'San Luis Obispo': {'lat': 35.3540209, 'lon': -120.3757163},
                              'San Mateo': {'lat': 37.496904, 'lon': -122.3330573},
                              'Sanger': {'lat': 36.708006, 'lon': -119.5559652},
                              'Santa Ana': {'lat': 33.7494951, 'lon': -117.8732213},
                              'Santa Barbara': {'lat': 34.4221319, 'lon': -119.7026673},
                              'Santa Clara': {'lat': 37.2333253, 'lon': -121.6846349},
                              'Santa Clarita': {'lat': 34.3916641, 'lon': -118.542586},
                              'Santa Fe Springs': {'lat': 33.9480787, 'lon': -118.0691499},
                              'Santa Maria': {'lat': 34.9531295, 'lon': -120.4358577},
                              'Santa Monica': {'lat': 34.0194704, 'lon': -118.4912273},
                              'Santee': {'lat': 32.8383828, 'lon': -116.9739167},
                              'South Gate': {'lat': 33.9463456, 'lon': -118.200981},
                              'South San Francisco': {'lat': 37.6535403, 'lon': -122.4168664},
                              'Stockton': {'lat': 37.9577016, 'lon': -121.2907796},
                              'Sunnyvale': {'lat': 37.3688301, 'lon': -122.0363496},
                              'Temecula': {'lat': 33.4946353, 'lon': -117.1473661},
                              'Torrance': {'lat': 33.8358492, 'lon': -118.3406288},
                              'Tracy': {'lat': 37.718829, 'lon': -121.43437985945519},
                              'Tulare': {'lat': 36.2516475, 'lon': -118.852583},
                              'Turlock': {'lat': 37.4946568, 'lon': -120.8465941},
                              'Tustin': {'lat': 33.7458511, 'lon': -117.826166},
                              'Union City': {'lat': 37.5963232, 'lon': -122.0816297},
                              'Upland': {'lat': 34.09751, 'lon': -117.6483876},
                              'Vacaville': {'lat': 38.3565773, 'lon': -121.9877444},
                              'Vallejo': {'lat': 38.1040864, 'lon': -122.2566367},
                              'Vernon': {'lat': 34.007135, 'lon': -118.22525},
                              'Victorville': {'lat': 34.5361067, 'lon': -117.2911565},
                              'Visalia': {'lat': 36.3302284, 'lon': -119.2920585},
                              'Vista': {'lat': 33.2000368, 'lon': -117.2425355},
                              'West Covina': {'lat': 34.0686208, 'lon': -117.9389526},
                              'Whittier': {'lat': 33.9708782, 'lon': -118.0308396},
                              'Wildomar': {'lat': 33.5939372, 'lon': -117.2414989},
                              'Woodland': {'lat': 38.6786109, 'lon': -121.7733285},
                              'Yucaipa': {'lat': 34.033625, 'lon': -117.0430865}}},
    'Colorado': {'lat': 38.7251776, 'lon': -105.607716,
                 'cities': {'Arvada': {'lat': 39.8005505, 'lon': -105.0811573},
                            'Colorado Springs': {'lat': 38.8339578, 'lon': -104.8253485},
                            'Denver': {'lat': 39.7392364, 'lon': -104.9848623},
                            'Grand Junction': {'lat': 39.063956, 'lon': -108.5507317},
                            'Lakeside': {'lat': 39.7793949, 'lon': -105.054869},
                            'Littleton': {'lat': 39.613321, 'lon': -105.0166498},
                            'Montrose': {'lat': 38.4375391, 'lon': -108.2403855},
                            'Pueblo': {'lat': 38.2544472, 'lon': -104.609141},
                            'Thornton': {'lat': 39.8695516, 'lon': -104.985181}}},
    'Connecticut': {'lat': 41.6500201, 'lon': -72.7342163,
                    'cities': {'Bridgeport': {'lat': 41.184722300000004, 'lon': -73.18672053183846},
                               'Bristol': {'lat': 41.6735209, 'lon': -72.9464859},
                               'Hartford': {'lat': 41.7655582, 'lon': -72.69061276146614},
                               'Meriden': {'lat': 41.5378215, 'lon': -72.80033880043175},
                               'Middletown': {'lat': 41.54961415, 'lon': -72.65157756750801},
                               'New Britain': {'lat': 41.6796456, 'lon': -72.78834682044055},
                               'New Haven': {'lat': 41.298434349999994, 'lon': -72.93102342707913},
                               'Norwalk': {'lat': 41.1175966, 'lon': -73.4078968},
                               'Shelton': {'lat': 41.31561, 'lon': -73.14016262885858},
                               'Waterbury': {'lat': 41.5538091, 'lon': -73.0438362},
                               'Woodbridge': {'lat': 41.352597, 'lon': -73.0084385}}},
    'Delaware': {'lat': 38.6920451, 'lon': -75.4013315,
                 'cities': {'Wilmington': {'lat': 39.7459468, 'lon': -75.546589}}},
    'Florida': {'lat': 27.7567667, 'lon': -81.4639835,
                'cities': {'Altamonte Springs': {'lat': 28.6619154, 'lon': -81.3885899},
                           'Apopka': {'lat': 28.6779683, 'lon': -81.5115214},
                           'Boca Raton': {'lat': 26.3586885, 'lon': -80.0830984},
                           'Boynton Beach': {'lat': 26.5256179, 'lon': -80.0666026},
                           'Bradenton': {'lat': 27.4989278, 'lon': -82.5748194},
                           'Brandon': {'lat': 27.928463999999998, 'lon': -82.2880507720744},
                           'Cape Coral': {'lat': 26.6059432, 'lon': -81.9806771},
                           'Clearwater': {'lat': 27.9658533, 'lon': -82.8001026},
                           'Clermont': {'lat': 28.5494447, 'lon': -81.7728543},
                           'Coconut Creek': {'lat': 26.2517482, 'lon': -80.1789351},
                           'Coral Gables': {'lat': 25.72149, 'lon': -80.2683838},
                           'Coral Springs': {'lat': 26.271192, 'lon': -80.2706044},
                           'Cutler Bay': {'lat': 25.5783, 'lon': -80.3377},
                           'Davie': {'lat': 26.0628665, 'lon': -80.2331038},
                           'Daytona Beach': {'lat': 29.2108147, 'lon': -81.0228331},
                           'Deerfield Beach': {'lat': 26.318342, 'lon': -80.0996306},
                           'Delray Beach': {'lat': 26.4614625, 'lon': -80.0728201},
                           'Deltona': {'lat': 28.9005446, 'lon': -81.2636738},
                           'Doral': {'lat': 25.8195424, 'lon': -80.3553302},
                           'Fort Lauderdale': {'lat': 26.1223084, 'lon': -80.1433786},
                           'Fort Myers': {'lat': 26.640628, 'lon': -81.8723084},
                           'Fort Pierce': {'lat': 27.4467056, 'lon': -80.3256056},
                           'Fort Walton Beach': {'lat': 30.4057552, 'lon': -86.618842},
                           'Ft. Walton Beach': {'lat': 30.4057552, 'lon': -86.618842},
                           'Gainesville': {'lat': 29.6519684, 'lon': -82.3249846},
                           'Hallandale Beach': {'lat': 25.9812025, 'lon': -80.148379},
                           'Hialeah': {'lat': 25.8575963, 'lon': -80.2781057},
                           'Homestead': {'lat': 25.4718946, 'lon': -80.4759905},
                           'Jacksonville': {'lat': 30.3321838, 'lon': -81.655651},
                           'Jupiter': {'lat': 26.9342246, 'lon': -80.0942087},
                           'Kissimmee': {'lat': 28.2918995, 'lon': -81.4075838},
                           'Lake Worth': {'lat': 26.615891, 'lon': -80.0691435},
                           'Lakeland': {'lat': 28.0394654, 'lon': -81.9498042},
                           'Largo': {'lat': 27.9094665, 'lon': -82.7873244},
                           'Lauderhill': {'lat': 26.1403635, 'lon': -80.2133808},
                           'Lehigh Acres': {'lat': 26.6091509, 'lon': -81.652407},
                           'Lutz': {'lat': 28.1511243, 'lon': -82.4614831},
                           'Margate': {'lat': 26.2445263, 'lon': -80.206436},
                           'Melbourne': {'lat': 28.106471, 'lon': -80.6371513},
                           'Miami': {'lat': 25.7741728, 'lon': -80.19362},
                           'Miami Beach': {'lat': 25.7929198, 'lon': -80.1353006},
                           'Miami Gardens': {'lat': 25.9420377, 'lon': -80.2456045},
                           'Miami Lakes': {'lat': 25.9087056, 'lon': -80.3086619},
                           'Miramar': {'lat': 25.9873137, 'lon': -80.2322706},
                           'Naples': {'lat': 26.1421976, 'lon': -81.7942944},
                           'New Port Richey': {'lat': 28.2441768, 'lon': -82.7192671},
                           'North Miami': {'lat': 25.8900949, 'lon': -80.1867138},
                           'North Miami Beach': {'lat': 25.9331488, 'lon': -80.1625463},
                           'Oakland Park': {'lat': 26.1723065, 'lon': -80.1319893},
                           'Ocala': {'lat': 29.1871986, 'lon': -82.1400923},
                           'Opa-locka': {'lat': 25.9023168, 'lon': -80.2503271},
                           'Orange Park': {'lat': 30.1654707, 'lon': -81.7016346},
                           'Orlando': {'lat': 28.5421109, 'lon': -81.3790304},
                           'Oviedo': {'lat': 28.6702526, 'lon': -81.2084941},
                           'Palm Bay': {'lat': 27.959186199999998, 'lon': -80.67174097572686},
                           'Palm Beach Gardens': {'lat': 26.8233946, 'lon': -80.1386547},
                           'Palm Harbor': {'lat': 28.0856815, 'lon': -82.75690699742961},
                           'Palmetto Bay': {'lat': 25.6217715, 'lon': -80.3247748},
                           'Panama City': {'lat': 30.1600827, 'lon': -85.6545729},
                           'Parkland': {'lat': 26.3100794, 'lon': -80.23727},
                           'Pembroke Pines': {'lat': 26.0031465, 'lon': -80.223937},
                           'Pensacola': {'lat': 30.421309, 'lon': -87.2169149},
                           'Pinellas Park': {'lat': 27.8428025, 'lon': -82.6995444},
                           'Plant City': {'lat': 28.01633, 'lon': -82.1234803},
                           'Plantation': {'lat': 26.1275862, 'lon': -80.2331036},
                           'Pompano Beach': {'lat': 26.2378597, 'lon': -80.1247667},
                           'Port Richey': {'lat': 28.2716755, 'lon': -82.7195451},
                           'Port St Lucie': {'lat': 27.2939333, 'lon': -80.3503283},
                           'Sanford': {'lat': 28.8117297, 'lon': -81.2680345},
                           'Sarasota': {'lat': 27.3364347, 'lon': -82.5306527},
                           'South Miami': {'lat': 25.7076017, 'lon': -80.2933846},
                           'Spring Hill': {'lat': 28.483576, 'lon': -82.5338633376176},
                           'St. Petersburg': {'lat': 27.7703796, 'lon': -82.6695085},
                           'Stuart': {'lat': 27.197983, 'lon': -80.2519175},
                           'Sunrise': {'lat': 26.1666888, 'lon': -80.2787573},
                           'Tallahassee': {'lat': 30.4380832, 'lon': -84.2809332},
                           'Tampa': {'lat': 27.9477595, 'lon': -82.458444},
                           'Valrico': {'lat': 27.9484265, 'lon': -82.23621545220522},
                           'Wellington': {'lat': 26.6586779, 'lon': -80.2414357},
                           'West Palm Beach': {'lat': 26.715364, 'lon': -80.0532942},
                           'Weston': {'lat': 26.1003392, 'lon': -80.399513},
                           'Winter Garden': {'lat': 28.5656649, 'lon': -81.5856742},
                           'Winter Haven': {'lat': 28.0222435, 'lon': -81.7328568},
                           'Winter Park': {'lat': 28.5977707, 'lon': -81.3510264},
                           'Zephyrhills': {'lat': 28.2336196, 'lon': -82.1811947}}},
    'Georgia': {'lat': 32.3293809, 'lon': -83.1137366,
                'cities': {'Albany': {'lat': 31.5782062, 'lon': -84.1556809},
                           'Alpharetta': {'lat': 34.0709576, 'lon': -84.2747329},
                           'Atlanta': {'lat': 33.7489924, 'lon': -84.3902644},
                           'Augusta': {'lat': 33.4709714, 'lon': -81.9748429},
                           'Columbus': {'lat': 32.4610708, 'lon': -84.9880449},
                           'Decatur': {'lat': 33.7737582, 'lon': -84.296069},
                           'Douglasville': {'lat': 33.7514966, 'lon': -84.7477136},
                           'Lithonia': {'lat': 33.7123305, 'lon': -84.1051939},
                           'Macon': {'lat': 32.8406946, 'lon': -83.6324022},
                           'Marietta': {'lat': 33.9528472, 'lon': -84.5496148},
                           'McDonough': {'lat': 33.4473361, 'lon': -84.1468616},
                           'Norcross': {'lat': 33.9412127, 'lon': -84.2135309},
                           'Riverdale': {'lat': 33.5726113, 'lon': -84.4132594},
                           'Savannah': {'lat': 32.0809263, 'lon': -81.0911768},
                           'Smyrna': {'lat': 33.883887, 'lon': -84.5147454},
                           'Stone Mountain': {'lat': 33.8062166, 'lon': -84.1457505},
                           'Thomasville': {'lat': 30.8365815, 'lon': -83.9787808}}},
    'Hawaii': {'lat': 19.58726775, 'lon': -155.42688965312746,
               'cities': {'Honolulu': {'lat': 21.304547, 'lon': -157.8556764}}},
    'Idaho': {'lat': 43.6447642, 'lon': -114.015407,
              'cities': {'Boise': {'lat': 43.6166163, 'lon': -116.200886},
                         'Idaho Falls': {'lat': 43.4935589, 'lon': -112.0401206},
                         'Pocatello': {'lat': 42.8688613, 'lon': -112.4401098},
                         'Twin Falls': {'lat': 42.5704456, 'lon': -114.4602554}}},
    'Illinois': {'lat': 40.0796606, 'lon': -89.4337288,
                 'cities': {'Arlington Heights': {'lat': 42.0811563, 'lon': -87.9802164},
                            'Aurora': {'lat': 41.7571701, 'lon': -88.3147539},
                            'Bartlett': {'lat': 41.9908485, 'lon': -88.1850028},
                            'Berwyn': {'lat': 41.8505874, 'lon': -87.7936685},
                            'Bloomington': {'lat': 40.4766372, 'lon': -88.9930308},
                            'Bolingbrook': {'lat': 41.7003302, 'lon': -88.0717708},
                            'Carol Stream': {'lat': 41.9125286, 'lon': -88.1347927},
                            'Champaign': {'lat': 40.1164205, 'lon': -88.2433829},
                            'Chicago': {'lat': 41.8755616, 'lon': -87.6244212},
                            'Cicero': {'lat': 41.8455398, 'lon': -87.7540199},
                            'Decatur': {'lat': 39.8454163, 'lon': -88.9524151},
                            'Des Plaines': {'lat': 42.0415823, 'lon': -87.8873916},
                            'Downers Grove': {'lat': 41.7936822, 'lon': -88.0102281},
                            'Elgin': {'lat': 42.03726, 'lon': -88.2810994},
                            'Elk Grove Village': {'lat': 42.0073828, 'lon': -87.9412194},
                            'Harrisburg': {'lat': 37.7385, 'lon': -88.5405213},
                            'Joliet': {'lat': 41.5263603, 'lon': -88.0840212},
                            'Lake Forest': {'lat': 42.2586342, 'lon': -87.840625},
                            'Lombard': {'lat': 41.8864687, 'lon': -88.0201536},
                            'Melrose Park': {'lat': 41.900299, 'lon': -87.8569745},
                            'Moline': {'lat': 41.5067003, 'lon': -90.5151342},
                            'Naperville': {'lat': 41.7728699, 'lon': -88.1479278},
                            'Oak Lawn': {'lat': 41.7108662, 'lon': -87.7581081},
                            'Palatine': {'lat': 42.1105779, 'lon': -88.0336888},
                            'Peoria': {'lat': 40.6938609, 'lon': -89.5891008},
                            'Plainfield': {'lat': 41.6086711, 'lon': -88.2054345},
                            'Quincy': {'lat': 39.9356016, 'lon': -91.4098727},
                            'Rock Island': {'lat': 41.4411786, 'lon': -90.5766144},
                            'Rockford': {'lat': 42.2713945, 'lon': -89.093966},
                            'Romeoville': {'lat': 41.6475306, 'lon': -88.0895061},
                            'Schaumburg': {'lat': 42.0333608, 'lon': -88.083406},
                            'Springfield': {'lat': 39.7990175, 'lon': -89.6439575},
                            'Streamwood': {'lat': 42.0255827, 'lon': -88.1784085},
                            'Waukegan': {'lat': 42.3636331, 'lon': -87.8447938}}},
    'Indiana': {'lat': 40.3270127, 'lon': -86.1746933,
                'cities': {'Bloomington': {'lat': 39.1670396, 'lon': -86.5342881},
                           'Elkhart': {'lat': 41.6819935, 'lon': -85.9766671},
                           'Evansville': {'lat': 37.9747645, 'lon': -87.5558483},
                           'Fort Wayne': {'lat': 41.0799898, 'lon': -85.1386015},
                           'Ft. Wayne': {'lat': 41.0799898, 'lon': -85.1386015},
                           'Greenwood': {'lat': 39.6136578, 'lon': -86.1066526},
                           'Indianapolis': {'lat': 39.7683331, 'lon': -86.1583502},
                           'Lafayette': {'lat': 40.4167022, 'lon': -86.8752869},
                           'South Bend': {'lat': 41.6833813, 'lon': -86.2500066},
                           'Terre Haute': {'lat': 39.4667025, 'lon': -87.4139119}}},
    'Iowa': {'lat': 41.9216734, 'lon': -93.3122705,
             'cities': {'Ames': {'lat': 42.0267703, 'lon': -93.6170554},
                        'Cedar Rapids': {'lat': 41.9758872, 'lon': -91.6704053},
                        'Davenport': {'lat': 41.5236436, 'lon': -90.5776368},
                        'Des Moines': {'lat': 41.5910323, 'lon': -93.6046655},
                        'Dubuque': {'lat': 42.5006217, 'lon': -90.6647967},
                        'Iowa City': {'lat': 41.66586935, 'lon': -91.57334352186675},
                        'Keokuk': {'lat': 41.3154792, 'lon': -92.1867128},
                        'Mason City': {'lat': 43.1535728, 'lon': -93.2010367},
                        'Ottumawa': {'lat': 41.013056, 'lon': -92.414722},
                        'Sioux City': {'lat': 42.4966815, 'lon': -96.4058782},
                        'Waterloo': {'lat': 42.4979693, 'lon': -92.3329637}}},
    'Kansas': {'lat': 38.27312, 'lon': -98.5821872,
               'cities': {'Hutchinson': {'lat': 38.0608444, 'lon': -97.9297743},
                          'Pittsburg': {'lat': 37.4108841, 'lon': -94.70496},
                          'Topeka': {'lat': 39.049011, 'lon': -95.677556},
                          'Wichita': {'lat': 37.6922361, 'lon': -97.3375448}}},
    'Kentucky': {'lat': 37.5726028, 'lon': -85.1551411,
                 'cities': {'Bowling Green': {'lat': 36.9903199, 'lon': -86.4436018},
                            'Covington': {'lat': 39.0836224, 'lon': -84.508371},
                            'Lexington': {'lat': 38.0464066, 'lon': -84.4970393},
                            'Louisville': {'lat': 38.2542376, 'lon': -85.759407},
                            'Paducah': {'lat': 37.0833893, 'lon': -88.6000478}}},
    'Louisiana': {'lat': 30.8703881, 'lon': -92.007126,
                  'cities': {'Alexandria': {'lat': 31.311248, 'lon': -92.4449087},
                             'Baton Rouge': {'lat': 30.4459596, 'lon': -91.18738},
                             'Lafayette': {'lat': 30.2240897, 'lon': -92.0198427},
                             'Lake Charles': {'lat': 30.2265949, 'lon': -93.2173759},
                             'Monroe': {'lat': 32.5093109, 'lon': -92.1193012},
                             'New Orleans': {'lat': 29.9499323, 'lon': -90.0701156},
                             'Shreveport': {'lat': 32.5221828, 'lon': -93.7651944}}},
    'Maine': {'lat': 45.709097, 'lon': -68.8590201,
              'cities': {'Auburn': {'lat': 44.0978509, 'lon': -70.2311655},
                         'Bangor': {'lat': 44.8011821, 'lon': -68.7778138},
                         'Portland': {'lat': 43.6610277, 'lon': -70.2548596},
                         'Presque Isle': {'lat': 46.681479, 'lon': -68.016357}}},
    'Maryland': {'lat': 39.5162234, 'lon': -76.9382069,
                 'cities': {'Baltimore': {'lat': 39.2908816, 'lon': -76.610759},
                            'Clinton': {'lat': 38.7598524, 'lon': -76.89300604368651},
                            'Hagerstown': {'lat': 39.6419219, 'lon': -77.7202641},
                            'Hyattsville': {'lat': 38.9529442, 'lon': -76.9408647},
                            'Rockville': {'lat': 39.0840054, 'lon': -77.1527573},
                            'Salisbury': {'lat': 38.366027, 'lon': -75.6009964},
                            'Silver Spring': {'lat': 39.008641100000006, 'lon': -77.02063116905664},
                            'Washington, DC': {'lat': 38.88905145, 'lon': -77.04084627009158}}},
    'Massachusetts': {'lat': 42.3788774, 'lon': -72.032366,
                      'cities': {'Boston': {'lat': 42.3602534, 'lon': -71.0582912},
                                 'Brockton': {'lat': 42.0834335, 'lon': -71.0183787},
                                 'Concord': {'lat': 42.4605189, 'lon': -71.3488963},
                                 'Holyoke': {'lat': 42.2071434, 'lon': -72.60765},
                                 'Lowell': {'lat': 42.6334247, 'lon': -71.3161718},
                                 'Lynn': {'lat': 42.466763, 'lon': -70.9494939},
                                 'Milton': {'lat': 42.2501425, 'lon': -71.065573},
                                 'New Bedford': {'lat': 41.6362152, 'lon': -70.934205},
                                 'Newburyport': {'lat': 42.8125913, 'lon': -70.8772751},
                                 'Salem': {'lat': 42.5195292, 'lon': -70.8967226},
                                 'Springfield': {'lat': 42.1018764, 'lon': -72.5886727},
                                 'Worcester': {'lat': 42.2625621, 'lon': -71.8018877}}},
    'Michigan': {'lat': 43.6211955, 'lon': -84.6824346,
                 'cities': {'Alpena': {'lat': 45.0176181, 'lon': -83.6670019},
                            'Battle Creek': {'lat': 42.3192548, 'lon': -85.1824269},
                            'Bay City': {'lat': 43.5944677, 'lon': -83.8888648},
                            'Cadillac': {'lat': 44.3353211, 'lon': -85.5741088},
                            'Dearborn': {'lat': 42.3222599, 'lon': -83.1763145},
                            'Detroit': {'lat': 42.3315509, 'lon': -83.0466403},
                            'Flint': {'lat': 43.0161693, 'lon': -83.6900211},
                            'Grand Rapids': {'lat': 42.9632405, 'lon': -85.6678639},
                            'Grosse Pointe': {'lat': 42.3861485, 'lon': -82.9118591},
                            'Kalamazoo': {'lat': 42.291707, 'lon': -85.5872286},
                            'Lansing': {'lat': 42.7337712, 'lon': -84.5553805},
                            'Marquette': {'lat': 46.4481521, 'lon': -87.6305899},
                            'Monroe': {'lat': 41.9153358, 'lon': -83.5135665},
                            'Saginaw': {'lat': 43.4200387, 'lon': -83.9490365},
                            'Traverse City': {'lat': 44.7606441, 'lon': -85.6165301},
                            'Warren': {'lat': 42.4932575, 'lon': -83.0062746}}},
    'Minnesota': {'lat': 45.9896587, 'lon': -94.6113288,
                  'cities': {'Austin': {'lat': 43.6680928, 'lon': -92.9744896},
                             'Duluth': {'lat': 46.7729322, 'lon': -92.1251218},
                             'Mankato': {'lat': 44.1634663, 'lon': -93.9993505},
                             'Minneapolis': {'lat': 44.9772995, 'lon': -93.2654692},
                             'Rochester': {'lat': 44.0234387, 'lon': -92.4630182},
                             'St Cloud': {'lat': 45.5616075, 'lon': -94.1642004},
                             'St Paul': {'lat': 44.9504037, 'lon': -93.1015026}}},
    'Mississippi': {'lat': 32.9715645, 'lon': -89.7348497,
                    'cities': {'Biloxi': {'lat': 30.374673, 'lon': -88.84594333482862},
                               'Columbus': {'lat': 33.4956744, 'lon': -88.4272627},
                               'Greenville': {'lat': 33.4000633, 'lon': -91.0551312},
                               'Greenwood': {'lat': 33.5162315, 'lon': -90.1795281},
                               'Gulfport': {'lat': 30.3674198, 'lon': -89.0928155},
                               'Hattiesburg': {'lat': 31.3271189, 'lon': -89.2903392},
                               'Jackson': {'lat': 32.2990384, 'lon': -90.1847691},
                               'Laurel': {'lat': 31.706023000000002, 'lon': -89.13706958197955},
                               'Meridian': {'lat': 32.3643098, 'lon': -88.703656},
                               'Tupelo': {'lat': 34.2576067, 'lon': -88.7033859},
                               'West Point': {'lat': 33.6076186, 'lon': -88.6503255}}},
    'Missouri': {'lat': 38.7604815, 'lon': -92.5617875,
                 'cities': {'Cape Girardeau': {'lat': 37.3034933, 'lon': -89.5230357},
                            'Clayton': {'lat': 38.6504352, 'lon': -90.3362473},
                            'Columbia': {'lat': 38.951883, 'lon': -92.3337366},
                            'Florissant': {'lat': 38.7919683, 'lon': -90.3227803},
                            'Hannibal': {'lat': 39.7082498, 'lon': -91.3587413},
                            'Independence': {'lat': 39.0924792, 'lon': -94.4137923},
                            'Jefferson City': {'lat': 38.577359, 'lon': -92.1724265},
                            'Joplin': {'lat': 37.08418, 'lon': -94.51323},
                            'Kansas City': {'lat': 39.100105, 'lon': -94.5781416},
                            'Kirksville': {'lat': 40.1948848, 'lon': -92.5833939},
                            'Springfield': {'lat': 37.2166779, 'lon': -93.2920373},
                            'St. Joseph': {'lat': 39.7686055, 'lon': -94.8466322},
                            'St. Louis': {'lat': 38.6264178, 'lon': -90.1998378},
                            'University City': {'lat': 38.6569083, 'lon': -90.3103443}}},
    'Montana': {'lat': 47.3752671, 'lon': -109.638757,
                'cities': {'Billings': {'lat': 45.7874957, 'lon': -108.49607},
                           'Bozeman': {'lat': 45.6794293, 'lon': -111.044047},
                           'Butte': {'lat': 46.0131505, 'lon': -112.536508},
                           'Glendive': {'lat': 47.10529, 'lon': -104.71246},
                           'Great Falls': {'lat': 47.5048851, 'lon': -111.29189},
                           'Helena': {'lat': 46.5927425, 'lon': -112.036277},
                           'Missoula': {'lat': 46.8701049, 'lon': -113.995267}}},
    'Nebraska': {'lat': 41.7370229, 'lon': -99.5873816,
                 'cities': {'Hastings': {'lat': 40.5861322, 'lon': -98.3898883},
                            'Kearney': {'lat': 40.4906216, 'lon': -98.9472344},
                            'Lincoln': {'lat': 40.8088861, 'lon': -96.7077751},
                            'North Platte': {'lat': 41.1238873, 'lon': -100.7654232},
                            'Omaha': {'lat': 41.2587459, 'lon': -95.9383758},
                            'Scottsbluff': {'lat': 41.862302, 'lon': -103.6627088}}},
    'Nevada': {'lat': 39.5158825, 'lon': -116.8537227,
               'cities': {'Henderson': {'lat': 36.0301134, 'lon': -114.9826194},
                          'Las Vegas': {'lat': 36.1672559, 'lon': -115.1485163},
                          'North Las Vegas': {'lat': 36.2005843, 'lon': -115.1215844},
                          'Reno': {'lat': 39.5261206, 'lon': -119.8126581}}},
    'New Hampshire': {'lat': 43.4849133, 'lon': -71.6553992,
                      'cities': {'Manchester': {'lat': 42.9956397, 'lon': -71.4547891}}},
    'New Jersey': {'lat': 40.0757384, 'lon': -74.4041622,
                   'cities': {'Camden': {'lat': 39.9448402, 'lon': -75.1198911},
                              'Elizabeth': {'lat': 40.6639916, 'lon': -74.2107006},
                              'Hamilton Township': {'lat': 40.2041625, 'lon': -74.67932438979872},
                              'Jersey City': {'lat': 40.7281575, 'lon': -74.0776417},
                              'Lawrence Township': {'lat': 40.2999815, 'lon': -74.71904023580957},
                              'Montclair': {'lat': 40.8164458, 'lon': -74.2210643},
                              'Newark': {'lat': 40.735657, 'lon': -74.1723667}}},
    'New Mexico': {'lat': 34.5708167, 'lon': -105.993007,
                   'cities': {'Albuquerque': {'lat': 35.0841034, 'lon': -106.6509851},
                              'Santa Fe': {'lat': 35.6876096, 'lon': -105.9384569}}},
    'New York': {'lat': 40.7127281, 'lon': -74.0060152,
                 'cities': {'Albany': {'lat': 42.6511674, 'lon': -73.754968},
                            'Binghamton': {'lat': 42.0987125, 'lon': -75.9125262},
                            'Bronx': {'lat': 40.8466508, 'lon': -73.8785937},
                            'Brooklyn': {'lat': 40.6501038, 'lon': -73.9495823},
                            'Buffalo': {'lat': 42.8867166, 'lon': -78.8783922},
                            'Elmira': {'lat': 42.0897965, 'lon': -76.8077338},
                            'Hudson': {'lat': 42.2528649, 'lon': -73.790959},
                            'New York': {'lat': 40.7127281, 'lon': -74.0060152},
                            'Plattsburgh': {'lat': 44.69282, 'lon': -73.45562},
                            'Queens': {'lat': 40.7498243, 'lon': -73.7976337},
                            'Rochester': {'lat': 43.157285, 'lon': -77.615214},
                            'Schenectady': {'lat': 42.8142432, 'lon': -73.9395687},
                            'Staten Island': {'lat': 40.5834557, 'lon': -74.1496048},
                            'Syracuse': {'lat': 43.0481221, 'lon': -76.1474244},
                            'Troy': {'lat': 40.7402557, 'lon': -74.0055355},
                            'Utica': {'lat': 43.1009031, 'lon': -75.2326641},
                            'Watertown': {'lat': 43.9747838, 'lon': -75.9107565},
                            'Yonkers': {'lat': 40.9312099, 'lon': -73.8987469}}},
    'North Carolina': {'lat': 35.6729639, 'lon': -79.0392919,
                       'cities': {'Asheville': {'lat': 35.6009498, 'lon': -82.5540161},
                                  'Cary': {'lat': 35.7882893, 'lon': -78.7812081},
                                  'Charlotte': {'lat': 35.2272086, 'lon': -80.8430827},
                                  'Durham': {'lat': 35.996653, 'lon': -78.9018053},
                                  'Fayetteville': {'lat': 35.0525759, 'lon': -78.878292},
                                  'Garner': {'lat': 35.7112642, 'lon': -78.6141709},
                                  'Gastonia': {'lat': 35.2622158, 'lon': -81.1838794},
                                  'Greensboro': {'lat': 36.0726355, 'lon': -79.7919754},
                                  'Greenville': {'lat': 35.613224, 'lon': -77.3724593},
                                  'High Point': {'lat': 35.9556924, 'lon': -80.0053176},
                                  'Kernersville': {'lat': 36.1198589, 'lon': -80.0736533},
                                  'Mooresville': {'lat': 35.5848596, 'lon': -80.8100724},
                                  'New Bern': {'lat': 35.1084931, 'lon': -77.0441143},
                                  'Raleigh': {'lat': 35.7803977, 'lon': -78.6390989},
                                  'Washington': {'lat': 35.8725573, 'lon': -76.6215245},
                                  'Wilmington': {'lat': 34.2257282, 'lon': -77.9447107},
                                  'Winston Salem': {'lat': 36.0998131, 'lon': -80.2440518},
                                  'Winston-Salem': {'lat': 36.0998131, 'lon': -80.2440518}}},
    'North Dakota': {'lat': 47.6201461, 'lon': -100.540737,
                     'cities': {'Bismark': {'lat': 46.808327, 'lon': -100.783739},
                                'Dickinson': {'lat': 46.8791756, 'lon': -102.7896242},
                                'Fargo': {'lat': 46.877229, 'lon': -96.789821},
                                'Minot': {'lat': 48.23251, 'lon': -101.296273},
                                'Valley City': {'lat': 46.923313, 'lon': -98.003155}}},
    'Ohio': {'lat': 40.2253569, 'lon': -82.6881395,
             'cities': {'Akron': {'lat': 41.083064, 'lon': -81.518485},
                        'Canton': {'lat': 40.7985464, 'lon': -81.3749508},
                        'Cincinnati': {'lat': 39.1014537, 'lon': -84.5124602},
                        'Cleveland': {'lat': 41.5051613, 'lon': -81.6934446},
                        'Columbus': {'lat': 39.9622601, 'lon': -83.0007065},
                        'Dayton': {'lat': 39.7589478, 'lon': -84.1916069},
                        'Dublin': {'lat': 40.0992294, 'lon': -83.1140771},
                        'Edgewood': {'lat': 41.876908, 'lon': -80.75079726470588},
                        'Kent': {'lat': 41.1536674, 'lon': -81.357886},
                        'Lima': {'lat': 40.7399785, 'lon': -84.105006},
                        'Parma': {'lat': 41.3822398, 'lon': -81.7355692},
                        'Steubenville': {'lat': 40.3697905, 'lon': -80.6339638},
                        'Toledo': {'lat': 41.6529143, 'lon': -83.5378173},
                        'Wellington': {'lat': 41.1689421, 'lon': -82.2179354},
                        'Youngstown': {'lat': 41.1035786, 'lon': -80.6520161},
                        'Zanesville': {'lat': 39.9403453, 'lon': -82.0131924}}},
    'Oklahoma': {'lat': 34.9550817, 'lon': -97.2684063,
                 'cities': {'Ada': {'lat': 34.7743383, 'lon': -96.6783651},
                            'Lawton': {'lat': 34.6086854, 'lon': -98.3903305},
                            'Oklahoma City': {'lat': 35.4729886, 'lon': -97.5170536},
                            'Tulsa': {'lat': 36.1556805, 'lon': -95.9929113}}},
    'Oregon': {'lat': 43.9792797, 'lon': -120.737257,
               'cities': {'Beaverton': {'lat': 45.4871723, 'lon': -122.80378},
                          'Bend': {'lat': 44.0581728, 'lon': -121.3153096},
                          'Eugene': {'lat': 44.0505054, 'lon': -123.0950506},
                          'Gresham': {'lat': 45.4997475, 'lon': -122.4309766},
                          'Happy Valley': {'lat': 45.428679, 'lon': -122.4971747},
                          'Hillsboro': {'lat': 45.5228939, 'lon': -122.989827},
                          'Klamath Falls': {'lat': 42.224867, 'lon': -121.7816704},
                          'Medford': {'lat': 42.3264181, 'lon': -122.8718605},
                          'Milwaukie': {'lat': 45.4453901, 'lon': -122.6392889},
                          'Oregon City': {'lat': 45.3573429, 'lon': -122.6067583},
                          'Portland': {'lat': 45.5202471, 'lon': -122.6741949}}},
    'Pennsylvania': {'lat': 40.9699889, 'lon': -77.7278831,
                     'cities': {'Allentown': {'lat': 40.6022059, 'lon': -75.4712794},
                                'Altoona': {'lat': 40.518681, 'lon': -78.394736},
                                'Bethlehem': {'lat': 40.6178915, 'lon': -75.3786521},
                                'Centralia': {'lat': 40.8042311, 'lon': -76.3408766},
                                'Erie': {'lat': 42.1294712, 'lon': -80.0852695},
                                'Harrisburg': {'lat': 40.2663107, 'lon': -76.8861122},
                                'Johnstown': {'lat': 40.3267407, 'lon': -78.9219698},
                                'Lancaster': {'lat': 40.03813, 'lon': -76.3056686},
                                'Lebanon': {'lat': 40.3429683, 'lon': -76.4233816},
                                'Philadelphia': {'lat': 39.9527237, 'lon': -75.1635262},
                                'Pittsburgh': {'lat': 40.4416941, 'lon': -79.9900861},
                                'Reading': {'lat': 40.335345, 'lon': -75.9279495},
                                'Scranton': {'lat': 41.4086874, 'lon': -75.6621294},
                                'Wilkes Barre': {'lat': 41.2464824, 'lon': -75.8817316},
                                'York': {'lat': 39.962398, 'lon': -76.727392}}},
    'Rhode Island': {'lat': 41.7962409, 'lon': -71.5992372,
                     'cities': {'Cranston': {'lat': 41.7809588, 'lon': -71.4371257},
                                'Pawtucket': {'lat': 41.878711, 'lon': -71.3825558},
                                'Providence': {'lat': 41.8239891, 'lon': -71.4128343}}},
    'South Carolina': {'lat': 33.6874388, 'lon': -80.4363743,
                       'cities': {'Anderson': {'lat': 34.5068601, 'lon': -82.6506264},
                                  'Charleston': {'lat': 32.7876012, 'lon': -79.9402728},
                                  'Columbia': {'lat': 34.0007493, 'lon': -81.0343313},
                                  'Easley': {'lat': 34.8269276, 'lon': -82.5817053},
                                  'Florence': {'lat': 34.1984435, 'lon': -79.7671658},
                                  'Greenville': {'lat': 34.851354, 'lon': -82.3984882},
                                  'Myrtle Beach': {'lat': 33.6956461, 'lon': -78.8900409},
                                  'Rock Hill': {'lat': 34.9248667, 'lon': -81.0250784},
                                  'Simpsonville': {'lat': 34.7370639, 'lon': -82.2542834},
                                  'Spartanburg': {'lat': 34.9498007, 'lon': -81.9320157},
                                  'Summerville': {'lat': 33.0206179, 'lon': -80.1747537}}},
    'South Dakota': {'lat': 44.6471761, 'lon': -100.348761,
                     'cities': {'Mitchell': {'lat': 43.70953, 'lon': -98.025379},
                                'Rapid City': {'lat': 44.0869329, 'lon': -103.2274481},
                                'Sioux Falls': {'lat': 43.549973, 'lon': -96.7003324}}},
    'Tennessee': {'lat': 35.7730076, 'lon': -86.2820081,
                  'cities': {'Bristol': {'lat': 36.5945034, 'lon': -82.1885212},
                             'Chattanooga': {'lat': 35.0457219, 'lon': -85.3094883},
                             'Clarksville': {'lat': 36.5277607, 'lon': -87.3588703},
                             'Franklin': {'lat': 35.925206, 'lon': -86.8689419},
                             'Jackson': {'lat': 35.6144446, 'lon': -88.8177418},
                             'Johnson City': {'lat': 36.3134398, 'lon': -82.3534728},
                             'Kingsport': {'lat': 36.550238, 'lon': -82.5594293},
                             'Knoxville': {'lat': 35.9603948, 'lon': -83.9210261},
                             'Memphis': {'lat': 35.1490215, 'lon': -90.0516285},
                             'Murfreesboro': {'lat': 35.8460396, 'lon': -86.3921096},
                             'Nashville': {'lat': 36.1622296, 'lon': -86.7743531}}},
    'Texas': {'lat': 31.8160381, 'lon': -99.5120986,
              'cities': {'Abilene': {'lat': 32.44645, 'lon': -99.7475905},
                         'Addison': {'lat': 32.9604305, 'lon': -96.83025951893629},
                         'Amarillo': {'lat': 35.2072185, 'lon': -101.8338246},
                         'Arlington': {'lat': 32.701938999999996, 'lon': -97.10562379033699},
                         'Austin': {'lat': 30.2711286, 'lon': -97.7436995},
                         'Baytown': {'lat': 29.7355047, 'lon': -94.9774274},
                         'Beaumont': {'lat': 30.0860459, 'lon': -94.1018461},
                         'Brownsville': {'lat': 25.9140256, 'lon': -97.4890856},
                         'Bryan': {'lat': 30.6743643, 'lon': -96.3699632},
                         'Carrollton': {'lat': 32.9537349, 'lon': -96.8902816},
                         'Cedar Hill': {'lat': 32.5888072, 'lon': -96.9553675},
                         'Channelview': {'lat': 29.7760599, 'lon': -95.1146533},
                         'Conroe': {'lat': 30.3118769, 'lon': -95.4560512},
                         'Corpus Christi': {'lat': 27.7477253, 'lon': -97.4014129},
                         'Dallas': {'lat': 32.7762719, 'lon': -96.7968559},
                         'Denton': {'lat': 33.1838787, 'lon': -97.1413417},
                         'Duncanville': {'lat': 32.6518004, 'lon': -96.9083366},
                         'El Paso': {'lat': 31.7754152, 'lon': -106.464634},
                         'Euless': {'lat': 32.8457865, 'lon': -97.0667142473263},
                         'Farmers Branch': {'lat': 32.9265137, 'lon': -96.8961151},
                         'Fort Worth': {'lat': 32.753177, 'lon': -97.3327459},
                         'Frisco': {'lat': 33.1506744, 'lon': -96.8236116},
                         'Garland': {'lat': 32.912624, 'lon': -96.6388833},
                         'Grand Prairie': {'lat': 32.657368000000005, 'lon': -97.02846624175038},
                         'Harlingen': {'lat': 26.1908241, 'lon': -97.6959794},
                         'Houston': {'lat': 29.7589382, 'lon': -95.3676974},
                         'Humble': {'lat': 29.9988312, 'lon': -95.2621553},
                         'Irving': {'lat': 32.8295183, 'lon': -96.9442177},
                         'Katy': {'lat': 29.7857853, 'lon': -95.8243956},
                         'Killeen': {'lat': 31.1171441, 'lon': -97.727796},
                         'Laredo': {'lat': 27.5236998, 'lon': -99.497352},
                         'Lewisville': {'lat': 33.046233, 'lon': -96.994174},
                         'Longview': {'lat': 32.5007031, 'lon': -94.74049},
                         'Lubbock': {'lat': 33.5635206, 'lon': -101.879336},
                         'Lufkin': {'lat': 31.3386242, 'lon': -94.7288558},
                         'Mansfield': {'lat': 32.5631924, 'lon': -97.1416768},
                         'Mcallen': {'lat': 26.2043691, 'lon': -98.230082},
                         'McKinney': {'lat': 33.1976496, 'lon': -96.6154471},
                         'Mesquite': {'lat': 32.7666103, 'lon': -96.599472},
                         'Midland': {'lat': 31.9973662, 'lon': -102.0779482},
                         'Midlothian': {'lat': 32.482361, 'lon': -96.9944489},
                         'Nacogdoches': {'lat': 31.5970503, 'lon': -94.5927451},
                         'Odessa': {'lat': 31.8457149, 'lon': -102.367687},
                         'Pearland': {'lat': 29.5639758, 'lon': -95.2864299},
                         'Pflugerville': {'lat': 30.4393696, 'lon': -97.6200043},
                         'Plano': {'lat': 33.0136764, 'lon': -96.6925096},
                         'Port Arthur': {'lat': 29.8988618, 'lon': -93.9288723},
                         'Richardson': {'lat': 32.9481789, 'lon': -96.7297206},
                         'Round Rock': {'lat': 30.508235, 'lon': -97.6788934},
                         'San Angelo': {'lat': 31.4648357, 'lon': -100.4398442},
                         'San Antonio': {'lat': 29.4246002, 'lon': -98.4951405},
                         'San Marcos': {'lat': 29.8826436, 'lon': -97.9405828},
                         'Sherman': {'lat': 36.2452294, 'lon': -101.8858689},
                         'Stafford': {'lat': 29.6160671, 'lon': -95.5577221},
                         'Sugar Land': {'lat': 29.6196787, 'lon': -95.6349463},
                         'Sweetwater': {'lat': 32.4709519, 'lon': -100.4059384},
                         'Temple': {'lat': 31.098207, 'lon': -97.3427847},
                         'Tomball': {'lat': 30.0971621, 'lon': -95.6160549},
                         'Tyler': {'lat': 32.3512601, 'lon': -95.3010624},
                         'Victoria': {'lat': 28.8026443, 'lon': -96.9766308},
                         'Waco': {'lat': 31.549333, 'lon': -97.1466695},
                         'Weslaco': {'lat': 26.1595156, 'lon': -97.9908429},
                         'Wichita Falls': {'lat': 33.9137085, 'lon': -98.4933873}}},
    'Utah': {'lat': 39.4225192, 'lon': -111.714358,
             'cities': {'Salt Lake City': {'lat': 40.7596198, 'lon': -111.8867975}}},
    'Vermont': {'lat': 44.5990718, 'lon': -72.5002608,
                'cities': {'Burlington': {'lat': 44.4761601, 'lon': -73.212906}}},
    'Virginia': {'lat': 37.1232245, 'lon': -78.4927721,
                 'cities': {'Alexandria': {'lat': 38.8051095, 'lon': -77.0470229},
                            'Ashburn': {'lat': 39.030019100000004, 'lon': -77.46964646557657},
                            'Bedford': {'lat': 37.3344561, 'lon': -79.5235083},
                            'Charlottesville': {'lat': 38.029306, 'lon': -78.4766781},
                            'Chesapeake': {'lat': 36.7183708, 'lon': -76.2466798},
                            'Fairfax': {'lat': 38.8462236, 'lon': -77.3063733},
                            'Farmville': {'lat': 37.3024713, 'lon': -78.3923813},
                            'Hampton': {'lat': 37.0300969, 'lon': -76.3452057},
                            'Harrisonburg': {'lat': 38.4493315, 'lon': -78.8688833},
                            'Lynchburg': {'lat': 37.4137536, 'lon': -79.1422464},
                            'Manassas': {'lat': 38.7509488, 'lon': -77.4752667},
                            'Mt Vernon': {'lat': 38.710179, 'lon': -77.08881985277044},
                            'Newport News': {'lat': 36.9775016, 'lon': -76.42977},
                            'Norfolk': {'lat': 36.8462923, 'lon': -76.2929252},
                            'Petersburg': {'lat': 37.227928, 'lon': -77.4019268},
                            'Portsmouth': {'lat': 36.8444196, 'lon': -76.3532998},
                            'Richmond': {'lat': 37.5385087, 'lon': -77.43428},
                            'Roanoke': {'lat': 37.270973, 'lon': -79.9414313},
                            'Suffolk': {'lat': 36.7282096, 'lon': -76.5835703},
                            'Virginia Beach': {'lat': 36.8529841, 'lon': -75.9774183},
                            'Winchester': {'lat': 39.1852184, 'lon': -78.1652404}}},
    'Washington': {'lat': 38.8949924, 'lon': -77.0365581,
                   'cities': {'Aberdeen': {'lat': 46.975371, 'lon': -123.815722},
                              'Battle Ground': {'lat': 45.7813532, 'lon': -122.5337433},
                              'Bellevue': {'lat': 47.6144219, 'lon': -122.1923372},
                              'Bellingham': {'lat': 48.7544012, 'lon': -122.4788361},
                              'Bonney Lake': {'lat': 47.1870191, 'lon': -122.1702293},
                              'Bothell': {'lat': 47.7598697, 'lon': -122.2068288},
                              'Bremerton': {'lat': 47.5653663, 'lon': -122.6246836},
                              'Burien': {'lat': 47.469918, 'lon': -122.3485274},
                              'Chehalis': {'lat': 46.6599653, 'lon': -122.9634322},
                              'Edmonds': {'lat': 47.8105738, 'lon': -122.3774952},
                              'Enumclaw': {'lat': 47.2047793, 'lon': -121.9916371},
                              'Everett': {'lat': 47.9673056, 'lon': -122.2013998},
                              'Federal Way': {'lat': 47.313494, 'lon': -122.3393103},
                              'Fife': {'lat': 47.2359524, 'lon': -122.3626381},
                              'Gig Harbor': {'lat': 47.3259697, 'lon': -122.5878659},
                              'Graham': {'lat': 47.0395996, 'lon': -122.2785729},
                              'Granite Falls': {'lat': 48.0817561, 'lon': -121.96947},
                              'Hanford': {'lat': 46.5793709, 'lon': -119.3808693},
                              'Issaquah': {'lat': 47.5348778, 'lon': -122.0432974},
                              'Kennewick': {'lat': 46.2087066, 'lon': -119.1199192},
                              'Kirkland': {'lat': 47.6859573, 'lon': -122.1920249},
                              'Lacey': {'lat': 47.0263876, 'lon': -122.8072257},
                              'Lake Stevens': {'lat': 48.0197794, 'lon': -122.0660914},
                              'Lynnwood': {'lat': 47.8278656, 'lon': -122.3053932},
                              'Maple Valley': {'lat': 47.3664231, 'lon': -122.0437127},
                              'Marysville': {'lat': 48.0517429, 'lon': -122.1768209},
                              'Mountlake Terrace': {'lat': 47.7909667, 'lon': -122.3066395},
                              'Mukilteo': {'lat': 47.9474034, 'lon': -122.3036992},
                              'Olympia': {'lat': 47.0451022, 'lon': -122.8950075},
                              'Pasco': {'lat': 46.244206750000004, 'lon': -119.10181999130866},
                              'Port Orchard': {'lat': 47.5315625, 'lon': -122.6384056},
                              'Puyallup': {'lat': 47.1849009, 'lon': -122.29214},
                              'Redmond': {'lat': 47.6694141, 'lon': -122.1238767},
                              'Renton': {'lat': 47.4799078, 'lon': -122.2034496},
                              'Richland': {'lat': 46.2804298, 'lon': -119.2752055},
                              'Sammamish': {'lat': 47.6088445, 'lon': -122.0423067},
                              'Seattle': {'lat': 47.6038321, 'lon': -122.3300624},
                              'Snohomish': {'lat': 47.9180275, 'lon': -122.0899646},
                              'Spanaway': {'lat': 47.0979462, 'lon': -122.4243422},
                              'Spokane': {'lat': 47.6571934, 'lon': -117.4235106},
                              'Stanwood': {'lat': 48.2452535, 'lon': -122.34953363993208},
                              'Sumner': {'lat': 47.2061882, 'lon': -122.2312383},
                              'Tacoma': {'lat': 47.2495798, 'lon': -122.4398746},
                              'Tulalip Bay': {'lat': 48.0656302, 'lon': -122.2868786},
                              'University Place': {'lat': 47.2368034, 'lon': -122.5520678},
                              'Vancouver': {'lat': 45.6306954, 'lon': -122.6744557},
                              'Woodinville': {'lat': 47.7545827, 'lon': -122.1588902},
                              'Yakima': {'lat': 46.601557, 'lon': -120.5108421},
                              'Yelm': {'lat': 46.9413877, 'lon': -122.60639}}},
    'West Virginia': {'lat': 38.4758406, 'lon': -80.8408415,
                      'cities': {'Beckley': {'lat': 37.7781702, 'lon': -81.1881557},
                                 'Birch River': {'lat': 38.4987149, 'lon': -80.7550982},
                                 'Bluefield': {'lat': 37.2698395, 'lon': -81.2223195},
                                 'Charleston': {'lat': 38.3505995, 'lon': -81.6332812},
                                 'Clarksburg': {'lat': 39.2806451, 'lon': -80.3445341},
                                 'Huntington': {'lat': 38.4192496, 'lon': -82.445154},
                                 'Oak Hill': {'lat': 37.9723339, 'lon': -81.1487136},
                                 'Parkersburg': {'lat': 39.2699565, 'lon': -81.5506916},
                                 'Weston': {'lat': 39.0384274, 'lon': -80.467313},
                                 'Wheeling': {'lat': 40.0639616, 'lon': -80.7209149}}},
    'Wisconsin': {'lat': 44.4308975, 'lon': -89.6884637,
                  'cities': {'Appleton': {'lat': 44.2611337, 'lon': -88.4067604},
                             'Eau Claire': {'lat': 44.811349, 'lon': -91.4984941},
                             'Green Bay': {'lat': 44.5126379, 'lon': -88.0125794},
                             'La Crosse': {'lat': 43.8014053, 'lon': -91.2395429},
                             'Madison': {'lat': 43.074761, 'lon': -89.3837613},
                             'Milwaukee': {'lat': 43.0349931, 'lon': -87.922497},
                             'Rhinelander': {'lat': 45.636623, 'lon': -89.412075},
                             'Superior': {'lat': 46.623324, 'lon': -92.117435},
                             'Wausau': {'lat': 44.9596017, 'lon': -89.6298239}}},
    'Wyoming': {'lat': 43.1700264, 'lon': -107.568534,
                'cities': {'Casper': {'lat': 42.8501191, 'lon': -106.3251384},
                           'Cheyenne': {'lat': 41.139981, 'lon': -104.820246},
                           'Riverton': {'lat': 43.0247245, 'lon': -108.380727}}}
}


# IS CASE SENSITIVE
def get_lat_lon(in_state: str = 'Texas', in_city: str = 'Mcallen'):
    if in_state is None or in_state not in places_dict:
        raise Exception('Set a valid state name.')

    # search by state
    if in_city is None:
        info = places_dict[in_state]
        return info['lat'], info['lon']

    # search by city
    else:
        if in_city in places_dict[in_state]['cities']:
            info = places_dict[in_state]['cities'][in_city]
            return info['lat'], info['lon']
        raise Exception(in_city + " not in " + in_state)


def available_states():
    return list(places_dict.keys())


def available_cities(in_state):
    return list(places_dict[in_state]['cities'].keys())
