"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workspace = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_aps_1 = require("aws-cdk-lib/aws-aps");
const workspace_base_1 = require("./validation/workspace-base");
const workspace_base_2 = require("./workspace-base");
const IS_WORKSPACE = Symbol.for('@robhan-cdk-lib/aws_aps.Workspace');
class Workspace extends workspace_base_2.WorkspaceBase {
    static isWorkspace(x) {
        return IS_WORKSPACE in x;
    }
    static fromWorkspaceAttributes(scope, id, attrs) {
        class Import extends workspace_base_2.WorkspaceBase {
            constructor(attributes) {
                super(scope, id);
                this.alertManagerDefinition = attributes.alertManagerDefinition;
                this.alias = attributes.alias;
                this.kmsKey = attributes.kmsKey;
                this.loggingConfiguration = attributes.loggingConfiguration;
                this.queryLoggingConfiguration = attributes.queryLoggingConfiguration;
                this.workspaceConfiguration = attributes.workspaceConfiguration;
                this.workspaceId = this.getWorkspaceId(attributes.workspaceArn);
                this.workspaceArn = attributes.workspaceArn;
            }
        }
        return new Import(attrs);
    }
    /**
     * Validates all workspace properties.
     *
     * @param props - The workspace properties to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * This method aggregates validation results from all individual property validators.
     * It throws an error if props is not an object.
     */
    static validateProps(props) {
        const errors = [];
        if (!props || typeof props !== 'object') {
            throw new Error('Workspace constructor properties must be an object');
        }
        const workspaceProps = props;
        if (workspaceProps.alertManagerDefinition !== undefined) {
            errors.push(...(0, workspace_base_1.validateAlertManagerDefinition)(workspaceProps.alertManagerDefinition).map((e) => `alertManagerDefinition: ${e}`));
        }
        if (workspaceProps.alias !== undefined) {
            errors.push(...(0, workspace_base_1.validateAlias)(workspaceProps.alias).map((e) => `alias: ${e}`));
        }
        if (workspaceProps.loggingConfiguration !== undefined) {
            errors.push(...(0, workspace_base_1.validateLoggingConfiguration)(workspaceProps.loggingConfiguration).map((e) => `loggingConfiguration: ${e}`));
        }
        if (workspaceProps.queryLoggingConfiguration !== undefined) {
            errors.push(...(0, workspace_base_1.validateQueryLoggingConfiguration)(workspaceProps.queryLoggingConfiguration).map((e) => `queryLoggingConfiguration: ${e}`));
        }
        if (workspaceProps.workspaceConfiguration !== undefined) {
            errors.push(...(0, workspace_base_1.validateWorkspaceConfiguration)(workspaceProps.workspaceConfiguration).map((e) => `workspaceConfiguration: ${e}`));
        }
        return errors;
    }
    constructor(scope, id, props) {
        super(scope, id);
        Object.defineProperty(this, IS_WORKSPACE, { value: true });
        const errors = Workspace.validateProps(props);
        if (errors.length > 0) {
            throw new Error(`Invalid props:\n${errors.join('\n')}`);
        }
        this.alertManagerDefinition = props.alertManagerDefinition;
        this.alias = props.alias;
        this.kmsKey = props.kmsKey;
        this.loggingConfiguration = props.loggingConfiguration;
        this.queryLoggingConfiguration = props.queryLoggingConfiguration;
        this.workspaceConfiguration = props.workspaceConfiguration;
        let cfnWorkspaceProps = {
            alertManagerDefinition: props.alertManagerDefinition,
            alias: props.alias,
            kmsKeyArn: props.kmsKey?.keyArn,
            loggingConfiguration: props.loggingConfiguration && props.loggingConfiguration.logGroup ? {
                logGroupArn: props.loggingConfiguration.logGroup.logGroupArn,
            } : undefined,
            queryLoggingConfiguration: props.queryLoggingConfiguration ? {
                destinations: props.queryLoggingConfiguration.destinations.map((d) => ({
                    cloudWatchLogs: {
                        logGroupArn: d.cloudWatchLogs.logGroup.logGroupArn,
                    },
                    filters: d.filters,
                })),
            } : undefined,
            workspaceConfiguration: props.workspaceConfiguration,
        };
        this.workspace = new aws_aps_1.CfnWorkspace(this, 'Resource', cfnWorkspaceProps);
        this.node.defaultChild = this.workspace;
        this.workspaceId = this.workspace.attrWorkspaceId;
        this.workspaceArn = this.workspace.attrArn;
        this.prometheusEndpoint = this.workspace.attrPrometheusEndpoint;
    }
}
exports.Workspace = Workspace;
_a = JSII_RTTI_SYMBOL_1;
Workspace[_a] = { fqn: "@robhan-cdk-lib/aws_aps.Workspace", version: "0.0.108" };
//# sourceMappingURL=data:application/json;base64,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