"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateData = validateData;
exports.validateName = validateName;
const utils_1 = require("@robhan-cdk-lib/utils");
/**
 * Validates the data property.
 *
 * @param data - The rule groups namespace data to validate
 * @returns An array of error messages if validation fails, or an empty array if valid
 *
 * Validation rules:
 * - Must be a string
 */
function validateData(data) {
    const errors = [];
    if (typeof data !== 'string') {
        errors.push('must be a string');
        return errors; // No need to check further if not a string
    }
    return errors;
}
/**
 * Validates the name property.
 *
 * @param name - The rule groups namespace name to validate
 * @returns An array of error messages if validation fails, or an empty array if valid
 *
 * Validation rules:
 * - Must be a string
 * - Must be between 1 and 64 characters long
 */
function validateName(name) {
    const errors = [];
    if (typeof name !== 'string') {
        errors.push('must be a string');
        return errors; // No need to check further if not a string
    }
    errors.push(...(0, utils_1.validateStringLength)({
        value: name,
        min: 1,
        max: 64,
    }));
    return errors;
}
//# sourceMappingURL=data:application/json;base64,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