import { Construct } from 'constructs';
import { IRuleGroupsNamespace, RuleGroupsNamespaceBase } from './rule-groups-namespace-base';
import { IWorkspace } from './workspace-base';
/**
 * Properties for creating a rule groups namespace in an Amazon Managed Service for Prometheus
 * workspace.
 */
export interface RuleGroupsNamespaceProps {
    /**
     * The rules file used in the namespace.
     */
    readonly data: string;
    /**
     * The name of the rule groups namespace.
     *
     * Between 1 and 64 characters.
     */
    readonly name: string;
    /**
     * The workspace to add the rule groups namespace.
     */
    readonly workspace: IWorkspace;
}
/**
 * Properties for importing a rule groups namespace in an Amazon Managed Service for Prometheus
 * workspace from attributes.
 */
export interface RuleGroupsNamespaceAttributes {
    /**
     * The rules file used in the namespace.
     */
    readonly data: string;
    /**
     * The name of the rule groups namespace.
     *
     * Between 1 and 64 characters.
     */
    readonly name: string;
    /**
     * The workspace to add the rule groups namespace.
     */
    readonly workspace: IWorkspace;
    /**
     * The ARN of the rule groups namespace.
     */
    readonly ruleGroupsNamespaceArn: string;
}
/**
 * The definition of a rule groups namespace in an Amazon Managed Service for Prometheus workspace.
 * A rule groups namespace is associated with exactly one rules file. A workspace can have multiple
 * rule groups namespaces.
 */
export declare class RuleGroupsNamespace extends RuleGroupsNamespaceBase {
    static isRuleGroupsNamespace(x: any): x is RuleGroupsNamespace;
    static fromRuleGroupsNamespaceAttributes(scope: Construct, id: string, attrs: RuleGroupsNamespaceAttributes): IRuleGroupsNamespace;
    /**
     * Validates all rule groups namespace properties.
     *
     * @param props - The rule group namespace properties to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * This method aggregates validation results from all individual property validators.
     * It throws an error if props is not an object.
     */
    private static validateProps;
    /**
     * The rules file used in the namespace.
     */
    readonly data: string;
    /**
     * The name of the rule groups namespace.
     */
    readonly name: string;
    /**
     * The workspace to add the rule groups namespace.
     */
    readonly workspace: IWorkspace;
    /**
     * The workspace to add the rule groups namespace.
     */
    readonly ruleGroupsNamespaceArn: string;
    /**
     * The underlying CloudFormation resource.
     */
    private readonly ruleGroupsNamespace;
    constructor(scope: Construct, id: string, props: RuleGroupsNamespaceProps);
}
