import numpy as np
import talib._ta_lib as ta


class BBI:

    @staticmethod
    def generate(np_closing_price_array, period1, period2, period3, period4):

        _max_period = max(period1, period2, period3, period4)
        if len(np_closing_price_array) < _max_period:
            return []

        _result = []
        _ma1_array = ta.MA(np_closing_price_array, period1)
        _ma2_array = ta.MA(np_closing_price_array, period2)
        _ma3_array = ta.MA(np_closing_price_array, period3)
        _ma4_array = ta.MA(np_closing_price_array, period4)

        for i, v in enumerate(np_closing_price_array):
            _ma1 = _ma1_array[i]
            _ma2 = _ma2_array[i]
            _ma3 = _ma3_array[i]
            _ma4 = _ma4_array[i]
            if np.isnan(_ma1) or np.isnan(_ma2) or np.isnan(_ma3) or np.isnan(_ma4):
                _result.append(np.NAN)
            else:
                _result.append((_ma1 + _ma2 + _ma3 + _ma4) / 4)

        return _result
