"""
run.py is an entry to lintest automation framework.
please copy this module to your project.
the structure of your project should be like this:
your_project_folder
|----  settings/          # settings will be auto-generated by lintest if doesn't exists
|----  common/            # the common libraries
|----  tests/             # all the testcases must be under "tests" package
|----  run.py             # the entry of lintest

@author: Lin Wang
"""

import os
import sys

import traceback

os.environ["LIN_TEST_PROJECT_PATH"] = os.path.dirname(os.path.abspath(__file__))
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.extend([os.path.dirname(os.path.abspath(__file__))])

try:
    os.system('python3 -m pip install -r requirements.txt')
    os.system("pip install --upgrade lintest")
    from lintest import main
except ImportError:
    traceback.print_exc()
if len(sys.argv) > 1:
    main.run_with(sys.argv)
elif len(sys.argv) == 1:
    # 如果不传人任何参数，则 默认执行tests中所有的 testcases
    main.run_with("tests")
