# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tbump', 'tbump.test', 'tbump.test.data']

package_data = \
{'': ['*']}

install_requires = \
['attrs>=19.3.0,<20.0.0',
 'cli-ui>=0.10.3,<0.11.0',
 'docopt>=0.6.2,<0.7.0',
 'path>=13.0,<14.0',
 'schema>=0.7.1,<0.8.0',
 'tomlkit>=0.5.8,<0.6.0']

entry_points = \
{'console_scripts': ['tbump = tbump.main:main']}

setup_kwargs = {
    'name': 'tbump',
    'version': '6.1.1',
    'description': 'Bump software releases',
    'long_description': '.. image::  https://tanker.io/images/github-logo.png\n   :target: #readme\n\n|\n\n.. image:: https://img.shields.io/pypi/v/tbump.svg\n  :target: https://pypi.org/project/tbump/\n\n.. image:: https://img.shields.io/github/license/TankerHQ/tbump.svg\n  :target: https://github.com/TankerHQ/tbump/blob/master/LICENSE\n\n.. image:: https://github.com/TankerHQ/tbump/workflows/tests/badge.svg\n   :target: https://github.com/TankerHQ/tbump/actions\n\n.. image:: https://github.com/TankerHQ/tbump/workflows/linters/badge.svg\n   :target: https://github.com/TankerHQ/tbump/actions\n\n.. image:: https://img.shields.io/codecov/c/github/TankerHQ/tbump.svg?label=Coverage\n   :target: https://codecov.io/gh/TankerHQ/tbump\n\n.. image:: https://img.shields.io/badge/deps%20scanning-pyup.io-green\n   :target: https://github.com/TankerHQ/tbump/workflows/safety/\n\n.. image:: https://img.shields.io/badge/code%20style-black-black.svg\n   :target: https://github.com/psf/black\n\n.. image:: https://img.shields.io/badge/mypy-checked-blue.svg\n   :target: https://mypy-lang.org\n\n\ntbump: bump software releases\n=============================\n\nInstallation\n------------\n\n\nThe recommended way to install ``tbump`` is to use `pipx <https://pipxproject.github.io/pipx/>`_\n\n* Make sure to have Python **3.5** or later installed.\n* Install ``pipx``\n* Run ``pipx install tbump``.\n\n``tbump`` is also available on ``pypi`` and can be installed with ``pip`` if you know what you are doing.\n\nScreenshot\n-----------\n\nHere\'s what a typical usage of ``tbump`` looks like:\n\n.. code-block:: console\n\n    $ tbump 5.0.5\n    :: Bumping from 5.0.4 to 5.0.5\n    => Would patch these files\n    - setup.py:14 version="5.0.4",\n    + setup.py:14 version="5.0.5",\n    - tbump.toml:2 current = "5.0.4"\n    + tbump.toml:2 current = "5.0.5"\n    => Would run these hooks before commit\n    * (1/2) $ ./test.sh\n    * (2/2) $ grep -q 5.0.5 Changelog.rst\n    => Would run these git commands\n     * git add --update\n     * git commit --message Bump to 5.0.5\n     * git tag --annotate --message v5.0.5 v5.0.5\n     * git push origin master\n     * git push origin v5.0.5\n    => Would run these hooks after push\n    * (1/1) $ ./publish.sh\n    :: Looking good? (y/N)\n    y\n    => Patching files\n    ...\n    => Running hooks before commit\n    ...\n    => Making bump commit and push matching tags\n    ...\n    => Running hooks after push\n    ...\n    Done ✓\n\n\n\nUsage\n------\n\nFirst, run ``tbump init``. This will create a ``tbump.toml`` file looking like this:\n\n.. code-block:: ini\n\n    [version]\n    current = "1.2.41"\n    regex = \'\'\'\n      (?P<major>\\d+)\n      \\.\n      (?P<minor>\\d+)\n      \\.\n      (?P<patch>\\d+)\n    \'\'\'\n\n    [git]\n    message_template = "Bump to {new_version}"\n    tag_template = "v{new_version}"\n\n    [[file]]\n    src = "setup.py"\n\n\n.. note::\n\n * The file uses `toml syntax <https://github.com/toml-lang/toml>`_.\n * Strings should be templated using curly brackets, to be used with Python\'s built-in ``.format()`` method.\n * Paths may contain unix-style `globs <https://docs.python.org/3/library/glob.html>`_, e.g. ``src = "a/**/script.?s"`` matches both ``a/b/script.js`` and ``a/b/c/script.ts``.\n * The version regular expression will be used in `verbose mode <https://docs.python.org/3/library/re.html#re.VERBOSE>`_ and can contain named groups (see below).\n\nThen run:\n\n.. code-block:: console\n\n    $ tbump 1.2.42\n\n``tbump`` will:\n\n* Replace the string ``1.2.41`` by ``1.2.42`` in every file listed in the\n  configuration\n\n* Make a commit based on the ``message_template``.\n\n* Make an **annotated** tag based on the ``tag_template``\n\n* Push the current branch and the tag.\n\nNote that by default, ``tbump`` will display all the changes and stop to ask if they are correct before performing any action, allowing you to abort and re-try the bump if something is not right.\nYou can use ``--non-interactive`` to disable this behavior.\n\nIf you only want to bump the files without performing any git actions or running the hook commands, use the ``--only-patch`` option.\n\nAdvanced configuration\n----------------------\n\nRestricting the lines that are replaced\n+++++++++++++++++++++++++++++++++++++++\n\n\nSometimes you want to make sure only the line matching a given pattern is replaced. For instance, with the following ``package.json``:\n\n.. code-block:: js\n\n    /* in package.json */\n    {\n       "name": "foo",\n       "version": "0.42",\n       "dependencies": {\n         "some-dep": "0.42",\n         "other-dep": "1.3",\n       }\n    }\n\nyou\'ll want to make sure that when you bump from ``0.42`` to ``0.43`` that the line containing ``some-dep`` does not change.\n\nIn this case, you can set a ``search`` option in the ``file`` section:\n\n.. code-block:: ini\n\n    # In tbump.toml\n\n    [[file]]\n    src = "package.json"\n    search = \'"version": "{current_version}"\'\n\nNote that the search string is actually a full regular expression, except for the ``{current_version}`` marker which is substituted as plain text.\n\n\nUsing a custom version template\n+++++++++++++++++++++++++++++++\n\nIf you are using a version schema like ``1.2.3-alpha-4``, you may want to expose a variable that only contains the "public" part of the version string. (``1.2.3`` in this case).\n\nTo do so, add a ``version_template`` option in the ``file`` section. The names used in the format string should match the group names in the regular expression.\n\n\n.. code-block:: js\n\n      /* in version.js */\n\n      export FULL_VERSION = \'1.2.3-alpha-4\';\n      export PUBLIC_VERSION = \'1.2.3\';\n\n.. code-block:: ini\n\n\n      [[file]]\n      src = "version.js"\n      version_template = "{major}.{minor}.{patch}"\n      search = "export PUBLIC_VERSION = \'{current_version}\'"\n\n      [[file]]\n      src = "version.js"\n      search = "export FULL_VERSION = \'{current_version}\'"\n\n\nRunning commands before commit\n++++++++++++++++++++++++++++++\n\nYou can specify a list of hooks to be run after the file have changed, but before the commit is made and pushed.\n\nThis is useful if some of the files under version control are generated through an external program.\n\nHere\'s an example:\n\n\n.. code-block:: ini\n\n    [[before_commit]]\n    name = "Check Changelog"\n    cmd = "grep -q {new_version} Changelog.rst"\n\n\nThe name is mandatory. The command will be executed via the shell, after the  ``{new_version}``  placeholder is replaced with the new version.\n\nAny hook that fails will interrupt the bump. You may want to run ``git reset --hard`` before trying again to undo the changes made in the files.\n\nRunning commands after push\n+++++++++++++++++++++++++++\n\nYou can specify a list of hooks to be run right after the tag has been pushed, using an `[[after_push]]` section.\n\nThis is useful if you need the command to run on a clean repository, without un-committed changes, for instance to publish ``rust`` packages:\n\n.. code-block:: ini\n\n    [[after_push]]\n    name = "Publish to crates.io"\n    cmd = "cargo publish"\n',
    'author': 'Dimitri Merejkowsky',
    'author_email': 'd.merej@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
