# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2020-07-09 22:30
from __future__ import unicode_literals

from django.db import migrations, models


def combine_name(apps, schema_editor):
    # We can't import the Person model directly as it may be a newer
    # version than this migration expects. We use the historical version.
    Resource = apps.get_model('coopstarter_data', 'Resource')
    for resource in Resource.objects.all():
        resource.name_en = resource.name
        resource.description_en = resource.description
        resource.save()

class Migration(migrations.Migration):

    dependencies = [
        ('coopstarter_data', '0014_auto_20200705_1320'),
    ]

    operations = [
        migrations.AddField(
            model_name='resource',
            name='description_en',
            field=models.TextField(blank=True, null=True, verbose_name='Description'),
        ),
        migrations.AddField(
            model_name='resource',
            name='description_fr',
            field=models.TextField(blank=True, null=True, verbose_name='Description'),
        ),
        migrations.AddField(
            model_name='resource',
            name='description_it',
            field=models.TextField(blank=True, null=True, verbose_name='Description'),
        ),
        migrations.AddField(
            model_name='resource',
            name='name_en',
            field=models.CharField(max_length=256, null=True, verbose_name='Title'),
        ),
        migrations.AddField(
            model_name='resource',
            name='name_fr',
            field=models.CharField(max_length=256, null=True, verbose_name='Title'),
        ),
        migrations.AddField(
            model_name='resource',
            name='name_it',
            field=models.CharField(max_length=256, null=True, verbose_name='Title'),
        ),
        migrations.RunPython(combine_name),
    ]
