# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/metadata/openMetadataConnection.json
#   timestamp: 2022-04-26T17:26:37+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from .....security.client import (
    auth0SSOClientConfig,
    azureSSOClientConfig,
    customOidcSSOClientConfig,
    googleSSOClientConfig,
    oktaSSOClientConfig,
)
from .. import connectionBasicType


class AuthProvider(Enum):
    no_auth = 'no-auth'
    azure = 'azure'
    google = 'google'
    okta = 'okta'
    auth0 = 'auth0'
    custom_oidc = 'custom-oidc'


class OpenmetadataType(Enum):
    OpenMetadata = 'OpenMetadata'


class OpenMetadataConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[OpenmetadataType] = Field('OpenMetadata', description='Service Type')
    hostPort: str = Field(
        ...,
        description='OpenMetadata Server Config. Must include API end point ex: http://localhost:8585/api',
    )
    authProvider: Optional[AuthProvider] = Field(
        'no-auth',
        description='OpenMetadata Server Authentication Provider. Make sure configure same auth providers as the one configured on OpenMetadaata server.',
    )
    securityConfig: Optional[
        Union[
            googleSSOClientConfig.GoogleSSOClientConfig,
            oktaSSOClientConfig.OktaSSOClientConfig,
            auth0SSOClientConfig.Auth0SSOClientConfig,
            azureSSOClientConfig.AzureSSOClientConfig,
            customOidcSSOClientConfig.CustomOIDCSSOClientConfig,
        ]
    ] = Field(None, description='OpenMetadata Client security configuration.')
    apiVersion: Optional[str] = Field(
        'v1', description='OpenMetadata server API version to use.'
    )
    includeTopics: Optional[bool] = Field(
        True, description='Include Topics for Indexing'
    )
    includeTables: Optional[bool] = Field(
        True, description='Include Tables for Indexing'
    )
    includeDashboards: Optional[bool] = Field(
        True, description='Include Dashboards for Indexing'
    )
    includePipelines: Optional[bool] = Field(
        True, description='Include Pipelines for Indexing'
    )
    includeUsers: Optional[bool] = Field(True, description='Include Users for Indexing')
    includeTeams: Optional[bool] = Field(True, description='Include Teams for Indexing')
    includeGlossaryTerms: Optional[bool] = Field(
        True, description='Include Glossary Terms for Indexing'
    )
    limitRecords: Optional[int] = Field(
        '1000', description='Limit the number of records for Indexing.'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
