# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/snowflakeConnection.json
#   timestamp: 2022-04-26T17:26:37+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class SnowflakeType(Enum):
    Snowflake = 'Snowflake'


class SnowflakeScheme(Enum):
    snowflake = 'snowflake'


class SnowflakeConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SnowflakeType] = Field(
        'Snowflake', description='Service Type', title='Service Type'
    )
    scheme: Optional[SnowflakeScheme] = Field(
        'snowflake',
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='username to connect  to the Snowflake. This user should have privileges to read all the metadata in Snowflake.',
        title='Username',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Snowflake.', title='Password'
    )
    hostPort: Optional[str] = Field(
        None, description='Host and port of the data source.', title='Host and Port'
    )
    account: str = Field(..., description='Snowflake Account.', title='Account')
    role: Optional[str] = Field(None, description='Snowflake Role.', title='Role')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
        title='Database',
    )
    warehouse: Optional[str] = Field(
        None, description='Snowflake warehouse.', title='Warehouse'
    )
    privateKey: Optional[str] = Field(
        None,
        description='Connection to Snowflake instance via Private Key',
        title='Private Key',
    )
    snowflakePrivatekeyPassphrase: Optional[SecretStr] = Field(
        None,
        description='Snowflake Passphrase Key used with Private Key',
        title='Snowflake Passphrase Key',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
