# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/hiveConnection.json
#   timestamp: 2022-04-26T17:26:37+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class HiveType(Enum):
    Hive = 'Hive'


class HiveScheme(Enum):
    hive = 'hive'


class HiveConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[HiveType] = Field(
        'Hive', description='Service Type', title='Service Type'
    )
    scheme: Optional[HiveScheme] = Field(
        'hive',
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Athena. This user should have privileges to read all the metadata in Hive.',
        title='Username',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Hive.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the Hive.', title='Host and Port'
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
        title='Database',
    )
    authOptions: Optional[str] = Field(
        None,
        description='Authentication options to pass to Hive connector. These options are based on SQLAlchemy.',
        title='URL Authentication Options',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
