# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['kslurm',
 'kslurm.args',
 'kslurm.bin',
 'kslurm.cli',
 'kslurm.data',
 'kslurm.installer',
 'kslurm.models',
 'kslurm.slurm',
 'kslurm.style',
 'kslurm.test',
 'kslurm.test.args',
 'kslurm.test.args.models',
 'kslurm.test.installer',
 'neuroglia_helpers',
 'neuroglia_helpers.etc']

package_data = \
{'': ['*'],
 'neuroglia_helpers': ['.github/workflows/*',
                       '.github_scripts/*',
                       'bin/*',
                       'cfg/*',
                       'cfg_apps/*',
                       'job-templates/*']}

install_requires = \
['InquirerPy>=0.3.3,<0.4.0',
 'appdirs>=1.4.4,<2.0.0',
 'attrs>=21.2.0,<22.0.0',
 'colorama>=0.4.4,<0.5.0',
 'docstring-parser>=0.14.1,<0.15.0',
 'rich>=12.2.0,<13.0.0',
 'semver>=2.13.0,<3.0.0',
 'shellingham>=1.4.0,<2.0.0',
 'tabulate>=0.8.9,<0.9.0',
 'typing-extensions>=3.10',
 'virtualenv>=20.0.24,<21']

entry_points = \
{'console_scripts': ['kbatch = kslurm.cli.kbatch:kbatch',
                     'kjupyter = kslurm.cli.kjupyter:kjupyter',
                     'kpy = kslurm.cli.kpy:kpy',
                     'krun = kslurm.cli.krun:krun',
                     'kslurm = kslurm.cli.main:main']}

setup_kwargs = {
    'name': 'kslurm',
    'version': '0.4.0',
    'description': 'Helper scripts and wrappers for running commands on SLURM compute clusters.',
    'long_description': "Utility functions to make working with SLURM easier.\n\n# Installation\nThe recommend way to install kslurm is via [`pipx`](https://pypa.github.io/pipx), a tool for installing python applications.\nThis will make kslurm globally available without infecting your global python environment.\nInstallation instructions for pipx can be found on their [website](https://pypa.github.io/pipx).\nOnce installed, simply run\n```bash\npipx install kslurm\n```\n\nNote that kslurm requires Python 3.9 or higher.\nIf pipx was installed using a lower version (e.g. 3.8), you will need to manually specify the python executable to use.\nActivate the appropriate python version (e.g. `module load python/3.10`) so that when you run `python --version`, the correct version appears.\nThen run\n\n```bash\npipx install kslurm --python $(which python)\n```\n\nFor full kslurm features, including integration with `pip`, you need to source the init script, preferably in your `~.bash_profile` (the init script contains commands that may not be available on non-login nodes). You can do this by running:\n\n```bash\nkpy bash >> $HOME/.bash_profile\n```\n\nFinally, you need to complete some basic configuration. First, set your SLURM account. Run\n\n```bash\nkslurm config account -i\n```\n\nThis will begin an interactive session letting you choose from the accounts available to you. Each account will be listed with it's LevelFS. The higher the LevelFS, the more underused the account is, so prefer accounts with higher values.\n\nNext, set your pipdir. This will be used to store python wheels and virtual envs. It should be in a permanent storage or project directory. For instance, on ComputeCanada servers, it should go in `$HOME/projects/<account_name>/<user_name>/.kslurm`. Use the following command:\n\n```bash\nkslurm config pipdir <dir>\n```\n\n## Upgrading and uninstalling\n\nThe app can be updated by running\n```bash\npipx upgrade kslurm\n```\n\nand removed using\n```bash\npipx uninstall kslurm\n```\n\n## Neuroglia-helpers Integration\n\nSee the [dedicated page](docs/neuroglia-helpers.md).\n\n## Legacy Installer\nkslurm includes an installation script that, previously, was the recommended install method.\nWhile it should technically still work, it is no longer supported and may be removed in the future.\nIts instructions are included, for reference, below.\n\nUsers who previously installed kslurm via this script should switch to a pipx install for long term support. Simply uninstall `kslurm` using the instructions below, then install via pipx as described above\n\nInstallation is via the following command:\n```\ncurl -sSL https://raw.githubusercontent.com/pvandyken/kslurm/master/install_kslurm.py | python -\n```\n\nIf you wish to uninstall, run the same command with `--uninstall` added to the end.\n\nThe package can be updated by running `kslurm update`.\n\n# Features\nCurrently offers four commands:\n* kbatch: for batch submission jobs (no immediate output)\n* krun: for interactive submission\n* kjupyter: for Jupyter sessions\n* kpy: for python environment management\n\nAll three use a regex-based argument parsing, meaning that instead of writing a SLURM file or supplying confusing `--arguments`, you can request resources with an intuitive syntax:\n\n```\nkrun 4 3:00 15G gpu\n```\nThis command will request an interactive session with __4__ cores, for __3hr__, using __15GB__ of memory, and a __gpu__.\n\nAnything not specfically requested will fall back to a default. For instance, by default the commands will request 3hr jobs using 1 core with 4GB of memory. You can also run a predefined job template using -j _template_. Run either command with -J to get a list of all templates. Any template values can be overriden simply by providing the appropriate argument.\n\nThe full list of possible requests, their syntaxes, and their defaults can be found at the bottom of the README.\n\n## krun\n\nkrun is used for interactive sessions on the cluster. If you run krun all by itself, it will fire up an interactive session on the cluster:\n\n```\nkrun\n```\nYou'll notice the server name in your terminal prompt will be changed to the cluster assigned to you. To end the session, simply use the `exit` command.\n\nYou can also submit a specific program to run:\n\n```\nkrun 1:00 1G python my_program.py\n```\nThis will request a 1hr session with one core and 1 GB of memory. The output of the job will be displayed on the console. Note that your terminal will be tied to the job, so if you quit, or get disconnected, your job will end. (tmux can be used to help mitigate this, see this [tutorial from Yale](https://docs.ycrc.yale.edu/clusters-at-yale/guides/tmux/) for an excellent overview).\n\nNote that you should never request more than the recommended amount of time for interactive jobs as specified by your cluster administrator. For ComputeCanada servers, you should never request more than 3 hr. If you do, you'll be placed in the general pool for resource assignment, and the job could take hours to start. Jobs of 3hr or less typically start in less than a minute.\n\n## kbatch\n\nJobs that don't require monitoring of the output or immediate submission, or will run for more than three hours, should be submitted using `kbatch`. This command schedules the job, then returns control of the terminal. Output from the job will be placed in a file in your current working directory entitled `slurm-[jobid].out`.\n\nImproving on `sbatch`, `kbatch` does not require a script file. You can directly submit a command:\n\n```\nkbatch 2-00:00 snakemake --profile slurm\n```\nThis will schedule a 2 day job running snakemake.\n\nOf course, complicated jobs can still be submitted using a script. Note that kbatch explictely specifies the resources it knows about in the command line. Command line args override `#SBATCH --directives` in the submit script, so at this time, you cannot use such directives to request resources unless they are not currently supported by kslurm. This may change in a future release.\n\n## kjupyter\n\nThis command requests an interactive job running a jupyter server. As with krun, you should not request a job more than the recommended maximum time for your cluster (3hr for ComputeCanada). If you need more time than that, just request a new job when the old one expires.\n\nYou should not provide any extra command to kjupyter. Just supply whatever resources you wish to request.\n```\nkjupyter 32G 2\n```\nThis will start a jupyter session with 32 GB of memory and 2 cores.\n\nNote that the command will fail if there is no `jupyter-lab` executable on the `PATH`. Use `pip install jupyterlab` if it's not installed. Typically, you should do this within a Python environment using a tool of your choice (e.g. virtualenv).\n\n# Unsupported SLURM args\n\nCurrently, the only way to supply arguments to SLURM beyond the items listed below is to list it as an `#SBATCH --directive` in a submission script. This only works with `kbatch`, not `krun` or `kjupyter`. A future release may support a method to supply these arguments directly on the command line. If you frequently use an option not listed below, make an issue and we can discuss adding support!\n\n# Slurm Syntax\n\nThe full syntax is outlined below. You can always run a command with `-h` to get help.\n\n| Resource  |           Syntax           |                                                                   Default |                                                    Description |\n| :-------- | :------------------------: | ------------------------------------------------------------------------: | -------------------------------------------------------------: |\n| Time      | [d-]dd:dd -> [days-]hh:mm  |                                                                       3hr |                                   The amount of time requested |\n| CPUS      |     d -> just a number     |                                                                         1 |                                   The number of CPUs requested |\n| Memory    |            d(G/M)[B] -> e.g. 4G, 500MB |                                                            4GB | The amount of memory requested |\n| Account   | --account <_account name_> |                                                                           |                      The account under which to submit the job. A default account can be configured using `kslurm config account <account_name>` |\n| GPU       |            gpu             |                                                                     False |                         Provide flag to request 1 GPU instance |\n| Directory |  <_any valid directory_>   |                                                                        ./ | Change the current working directory before submitting the job |\n| x11       |           --x11            |                                                                     False |                   Requests x11 forwarding for GUI applications |\n\n# kpy\n\nkpy bundles a set of commands to help manage pip virtual environments on Slurm compute clusters, specifically addressing a few issues unique to such servers:\n\n## Ephemeral venvs\nIn most use cases, python venvs are installed on compute clusters, ideally on local scratch storage.\nThis makes venvs inherently ephemeral.\nBecause installing a venv can take an appreciable amount of time, kpy packs tools to archive entire venvs for storage in a permanent local repository (ideally located in project-specific or permanent storage). Once saved, venvs can be quickly reloaded into a new compute environment.\n\nNote that copying venvs from one location to another is not a trivial task. The current setup has been tested on ComputeCanada servers without any issues so far, but problems may arise on another environment.\n\n## No internet\nCompute clusters often don't have an internet connection, limiting our install repertoire to locally available wheels.\nWith kpy, venvs can be created on a login node (using the available internet connection), then saved and loaded onto a compute node.\nKpy also includes some optional bash tools (see `kpy bash`), including a wrapper around pip that prevents it from accessing the internet on compute nodes, and connecting it with a local private wheelhouse.\n\n## Commands\n### `create`\n\n```bash\n# usage\nkpy create [<version|3.x>] [<name>]\n```\n\nCreate a new environment.\nName is optional; if not provided, a placeholder name will be created.\nVersion must be of the form `3.x` where x is any number (e.g `3.8`, `3.10`).\nIf provided, the corresponding python version will be used in the virtual env.\nNote that an appropriate python executable must be somewhere on your path (e.g. for `3.8` -> `python3.8`).\nIf not provided, the python version used to install kslurm will be used.\n\nIf run on a login node, the env will be created in a `$TMPDIR`.\nIf run on a compute node, it will be created in `$SLURM_TMPDIR`.\n\n### `save`\n\n```bash\n# usage\nkpy save [-f] <name>\n```\n\nSave the venv to your permanent cache.\nThis requires setting `pipdir` in the kslurm config (see below).\nBy default, `save` will not oversave an existing cache, but `-f` can be included to override this behaviour.\nIf a new name is provided, it will be used to update the current venv name and prompt.\n\n### `load`\n\n\n```bash\n# usage\nkpy load [<name>] [--as <newname>]\n```\n\nLoad a saved venv from the cache.\nThis command only works on a compute node (i.e. `$SLURM_TMPDIR` must be defined).\nIf a venv called `<name>` already exists, the command will fail, as each name can only be used once.\n`--as <newname>` works around this by changing the name of the loaded venv (the name of the saved venv will remain the same)\nCalling `load` without any `<name>` will print a list of current cached venvs.\n\n### `activate`\n\n```bash\n# usage\nkpy activate [<name>]\n```\n\nActivate venv initialized using `create` or `load`.\nName will be the same as the name appearing in the venv prompt (i.e. the name provided on initial loading or creation, through `--as`, or the last saved name).\nThis command only works on a compute node.\nVenvs created on a login node cannot be directly activated using kpy.\n\n### `list`\n\n```bash\n# usage\nkpy list\n```\n\nList currently initialized venvs (i.e. venvs you can `activate`).\nThis command only works on a compute node.\n\n\n### `bash`\n\n```bash\n# usage\nkpy bash\n```\n\nEchos a line of bash script that can be added to your `.bashrc` file:\n\n```bash\nkpy bash >> $HOME/.bashrc\n```\n\nThis adds a few features to your command line environment:\n\n- **pip wrapper**: Adds a wrapper around pip that detects if you are on a login node when running `install`, `wheel`, or `download`. If not on a login node, the `--no-index` flag will be appended to the command, preventing the use of an internet connection.\n- **wheelhouse management**: If `pipdir` is configured in the kslurm config, a wheelhouse will be created in your pip repository. Any wheels downloaded using `pip wheel` will be placed in that wheelhouse, and all wheels in the wheelhouse will be discoverable by `pip install`, both on login and compute nodes.\n\n## Configuration\n\nkslurm currently supports a few basic configuration values, and more will come with time. All configuration can be set using the command\n\n```bash\nkslurm config <key> <value>\n```\n\nYou can print the value of a configuration using\n\n```bash\nkslurm config <key>\n```\n\n### Current values\n\n* `account`: Default account to use for kslurm commands (e.g. `kbatch`, `krun`, etc)\n* `pipdir`: Directory to store cached venvs and wheels. Should be a project or permanent storage dir.\n",
    'author': 'Peter Van Dyken',
    'author_email': 'pvandyk2@uwo.ca',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pvandyken/kslurm',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
