# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/ffcv.loader.ipynb.

# %% ../../nbs/ffcv.loader.ipynb 1
# Contains code from:
# fastai - Apache License 2.0 - Copyright (c) 2023 fast.ai

# %% ../../nbs/ffcv.loader.ipynb 4
from __future__ import annotations

from typing import Mapping, Sequence
from pathlib import Path

import numpy as np

from ffcv.fields.base import Field
from ffcv.loader.loader import Loader as _Loader
from ffcv.loader.loader import OrderOption, ORDER_TYPE, DEFAULT_OS_CACHE, ORDER_MAP
from ffcv.pipeline.operation import Operation
from ffcv.transforms.ops import ToDevice as _ToDevice

from fastcore.basics import GetAttr, detuplify, Inf
from fastcore.dispatch import retain_types, explode_types
from fastcore.meta import funcs_kwargs
from fastcore.transform import Pipeline

from fastai.data.core import show_batch, show_results, DataLoaders

from ..imports import *

# %% auto 0
__all__ = ['Loader', 'OrderOption']

# %% ../../nbs/ffcv.loader.ipynb 5
_all_ = ['OrderOption']

# %% ../../nbs/ffcv.loader.ipynb 7
@funcs_kwargs
class BaseDL(GetAttr):
    "Provides callbacks for DataLoaders which inherit from `BaseLoader`"
    _methods = 'before_iter after_batch after_iter'.split()
    def __init__(self, **kwargs):
        pass

    def before_iter(self, x=None, *args, **kwargs):
        "Called before `BaseLoader` starts to read/iterate over the dataset."
        return x

    def after_batch(self, x=None, *args, **kwargs):
        "After collating mini-batch of items, the mini-batch is passed through this function."
        return x

    def after_iter(self, x=None, *args, **kwargs):
        "Called after `BaseLoader` has fully read/iterated over the dataset."
        return x

# %% ../../nbs/ffcv.loader.ipynb 8
class Loader(BaseDL, _Loader):
    "FFCV `Loader` with fastai Transformed DataLoader `TfmdDL` batch transforms"
    def __init__(self,
        fname:str|Path, # Path to the location of the dataset (FFCV beton format)
        batch_size:int, # Batch size
        num_workers:int=-1, # Number of CPU cores to use in parallel (default: All available up to 16)
        os_cache:bool=DEFAULT_OS_CACHE, # Leverage the OS for caching. Beneficial when there is enough memory to cache the dataset
        order:ORDER_TYPE=OrderOption.SEQUENTIAL, # Dataset traversal order, one of: `SEQEUNTIAL`, `RANDOM`, `QUASI_RANDOM`
        distributed:bool=False, # Emulates the behavior of PyTorch's DistributedSampler for distributed training
        seed:int|None=None, # Random seed for batch ordering
        indices:Sequence[int]|None=None, # Subset dataset by returning only these indices
        pipelines:Mapping[str, Sequence[Operation|nn.Module]]={}, # Dictionary defining for each field the sequence of Decoders and transforms to apply
        custom_fields:Mapping[str, Field]={}, # Dictonary informing `Loader` of the types associated to fields that are using a custom type
        drop_last:bool|None=None, # Drop non-full batch in each epoch. Defaults to True if order is `SEQEUNTIAL`
        batches_ahead:int=3, # Number of batches prepared in advance; balances latency and memory
        recompile:bool=False, # Recompile at every epoch. Required if FFCV augmentations change during training
        device:str|int|torch.device|None=None, # Device to place batch. Defaults to fastai's `default_device`
        n_inp:int|None=None, # Number of inputs to the model. Defaults to pipelines length minus 1
        split_idx:int|None=None, # Apply batch transform(s) to training (0) or validation (1) set. Defaults to valid if order is `SEQEUNTIAL`
        do_setup:bool=True, # Run `setup()` for batch transform(s)
        **kwargs
    ):
        if 'batch_tfms' in kwargs:
            if 'after_batch' not in kwargs:
                kwargs['after_batch'] = kwargs.pop('batch_tfms')
            else:
                raise ValueError('Cannot pass both `after_batch` and `batch_tfms` to `FFCVDataLoader`')

        kwargs['after_batch'] = Pipeline(kwargs.get('after_batch', None))
        if do_setup:
            kwargs['after_batch'].setup(self)

        if drop_last is None:
            drop_last != order==OrderOption.SEQUENTIAL

        _Loader.__init__(self,
            fname=str(Path(fname)),
            batch_size=batch_size,
            num_workers=num_workers,
            os_cache=os_cache,
            order=order,
            distributed=distributed,
            seed=seed,
            indices=indices,
            pipelines=pipelines,
            custom_fields=custom_fields,
            drop_last=drop_last,
            batches_ahead=batches_ahead,
            recompile=recompile
        )
        BaseDL.__init__(self, **kwargs)

        if device is None:
            self.device = default_device()
        else:
            self.device = device

        if split_idx is None:
            self.split_idx = int(order==OrderOption.SEQUENTIAL)
        else:
            self.split_idx = split_idx

        if n_inp is None:
            self._n_inp = len(pipelines) - 1
        else:
            self._n_inp = n_inp

        for name in ['item_tfms', 'after_item', 'before_batch']:
            if name in kwargs:
                if name != 'before_batch':
                    msg = f"fastxtend's `Loader` will not call any {name} methods. " \
                          f"{name} is for use with a fastai DataLoader.\n" \
                          f"Instead of passing fastai Item Transforms to {name}," \
                          f"initialize the fastxtend `Loader` pipeline with FFCV transforms."
                else:
                    msg = f"fastxtend's `Loader` will not call any {name} methods. " \
                          f"{name} are for use with a fastai DataLoader."
                warn(msg)


    def one_batch(self):
        "Return one processed batch of input(s) and target(s)"
        for b in self._one_batch():
            # need to return the yield from _one_batch so `Loader` can reset to iterate the entire epoch
            pass
        return b

    def show_batch(self,
        b=None, # Batch to show
        max_n:int=9, # Maximum number of items to show
        ctxs=None, # List of `ctx` objects to show data. Could be matplotlib axis, DataFrame etc
        show:bool=True, # Whether to display data
        unique:bool=False, # Whether to show only one
        **kwargs
    ):
        "Show `max_n` input(s) and target(s) from the batch."
        if unique:
            old_get_idxs = self.get_idxs
            self.get_idxs = lambda: Inf.zeros
        if b is None:
            b = self.one_batch()
        if not show:
            return self._pre_show_batch(b, max_n=max_n)
        # Uses Type Dispatch to call the correct `show_batch` for b
        show_batch(*self._pre_show_batch(b, max_n=max_n), ctxs=ctxs, max_n=max_n, **kwargs)
        if unique:
            self.get_idxs = old_get_idxs

    def show_results(self,
        b, # Batch to show results for
        out, # Predicted output from model for the batch
        max_n:int=9, # Maximum number of items to show
        ctxs=None, # List of `ctx` objects to show data. Could be matplotlib axis, DataFrame etc
        show:bool=True, # Whether to display data
        **kwargs
    ):
        "Show `max_n` results with input(s), target(s) and prediction(s)."
        x,y,its = self.show_batch(b, max_n=max_n, show=False)
        b_out = type(b)(b[:self.n_inp] + (tuple(out) if is_listy(out) else (out,)))
        x1,_,outs = self.show_batch(b_out, max_n=max_n, show=False)
        if its is None:
            res = (x, x1, None, None)
        else:
            res = (x, y, its, outs.itemgot(slice(self.n_inp,None)))
        if not show:
            return res
        # Uses Type Dispatch to call the correct `show_results` for b
        show_results(*res, ctxs=ctxs, max_n=max_n, **kwargs)

    @property
    def n_inp(self) -> int:
        "Number of elements in a batch for model input"
        return self._n_inp

    @property
    def device(self):
        return self._device

    @device.setter
    def device(self, device):
        device, *_ = torch._C._nn._parse_to(device=device)
        self._device = device
        # Device setter for FFCV Pipeline
        for p in self.pipeline_specs.values():
            for t in p.transforms:
                if isinstance(t, _ToDevice):
                    t.device = device
        # Device setter for fastai batch_tfms
        if hasattr(self.after_batch, 'fs'):
            for tfm in self.after_batch.fs:
                if hasattr(tfm, 'to') and callable(tfm.to): 
                    tfm.to(device)
                else:
                    for a in L(getattr(tfm, 'parameters', None)):
                        setattr(tfm, a, getattr(tfm, a).to(device))

    def to(self, device:int|str|torch.device):
        "Sets `self.device=device`."
        self.device = device
        return self

    def before_iter(self):
        super().before_iter()
        f = getattr(self, 'after_batch')
        if isinstance(f,Pipeline):
            f.split_idx=self.split_idx

    def decode(self, b):
        "Decode batch `b`"
        return to_cpu(self.after_batch.decode(self._retain_dl(b)))

    def decode_batch(self, b, max_n:int=9):
        "Decode up to `max_n` input(s) from batch `b`"
        return self._decode_batch(self.decode(b), max_n)

    def __iter__(self):
        self.before_iter()
        for b in super().__iter__():
            yield self.after_batch(b)
        self.after_iter()
        if hasattr(self, 'it'):
            del(self.it)

    def _one_pass(self, b=None):
        if b is None:
            b = self.one_batch()
        self._types = explode_types(b)

    def _retain_dl(self, b):
        if not getattr(self, '_types', None):
            self._one_pass(b)
        return retain_types(b, typs=self._types)

    def _decode_batch(self, b, max_n=9):
        return L(batch_to_samples(b, max_n=max_n))

    def _pre_show_batch(self, b, max_n=9):
        "Decode `b` to be ready for `show_batch`"
        b = self.decode(b)
        if hasattr(b, 'show'):
            return b,None,None
        its = self._decode_batch(b, max_n)
        if not is_listy(b):
            b,its = [b],L((o,) for o in its)
        return detuplify(b[:self.n_inp]),detuplify(b[self.n_inp:]),its

    def _one_batch(self):
        orig_traversal_order = self.traversal_order
        orig_indices = self.indices
        orig_drop_last = self.drop_last

        # Set Loader to only return one batch per epoch
        if self._args['order'] == OrderOption.SEQUENTIAL:
            self.indices = np.arange(0, self.batch_size)
        else:
            self.indices = np.random.random_integers(0, self.reader.num_samples, self.batch_size)
        self.traversal_order = ORDER_MAP[OrderOption.SEQUENTIAL](self)
        self.drop_last = False

        # yield one batch
        yield next(self.__iter__())

        # Reset Loader state to its original status
        self.next_epoch -= 1
        self.indices = orig_indices
        self.drop_last = orig_drop_last
        self.traversal_order = orig_traversal_order
