/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.derivation;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedAcyclicGraph;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.derivation.DerivationSparql;
import uk.ac.cam.cares.jps.base.discovery.AgentCaller;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class DerivationClient {
    public static final String AGENT_INPUT_KEY = "agent_input";
    public static final String AGENT_OUTPUT_KEY = "agent_output";
    public static final String DERIVATION_KEY = "derivation";
    StoreClientInterface kbClient;
    private static final Logger LOGGER = LogManager.getLogger(DerivationClient.class);

    public DerivationClient(StoreClientInterface kbClient) {
        this.kbClient = kbClient;
    }

    public String createDerivation(List<String> entities, String agentIRI, String agentURL, List<String> inputsIRI) {
        String createdDerivation = DerivationSparql.createDerivation(this.kbClient, entities, agentIRI, agentURL, inputsIRI);
        DerivationSparql.addTimeInstance(this.kbClient, createdDerivation);
        LOGGER.info("Instantiated derivation with time series <" + createdDerivation + ">");
        LOGGER.debug("<" + entities + "> belongsTo <" + createdDerivation + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedUsing <" + agentIRI + "> located at " + agentURL);
        return createdDerivation;
    }

    public String createDerivationWithTimeSeries(List<String> entities, String agentIRI, String agentURL, List<String> inputsIRI) {
        String createdDerivation = DerivationSparql.createDerivationWithTimeSeries(this.kbClient, entities, agentIRI, agentURL, inputsIRI);
        DerivationSparql.addTimeInstance(this.kbClient, createdDerivation);
        LOGGER.info("Instantiated derivation with time series <" + createdDerivation + ">");
        LOGGER.debug("<" + entities + "> belongsTo <" + createdDerivation + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedFrom <" + inputsIRI + ">");
        LOGGER.debug("<" + createdDerivation + "> isDerivedUsing <" + agentIRI + "> located at " + agentURL);
        return createdDerivation;
    }

    public void addTimeInstance(String entity) {
        DerivationSparql.addTimeInstance(this.kbClient, entity);
        LOGGER.info("Added timestamp to <" + entity + ">");
    }

    public void removeTimeInstance(String entity) {
        DerivationSparql.removeTimeInstance(this.kbClient, entity);
        LOGGER.info("Removed timestamp for <" + entity + ">");
    }

    public void updateTimestamp(String entity) {
        if (DerivationSparql.hasBelongsTo(this.kbClient, entity)) {
            String derivation = this.getDerivationOf(entity);
            LOGGER.info("<" + entity + "> has a derivation instance attached, timestamp of the derivation will get updated");
            DerivationSparql.updateTimeStamp(this.kbClient, derivation);
            LOGGER.info("Updated timestamp of <" + derivation + ">");
        } else {
            DerivationSparql.updateTimeStamp(this.kbClient, entity);
            LOGGER.info("Updated timestamp of <" + entity + ">");
        }
    }

    public void updateDerivation(String derivedIRI) {
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph(DefaultEdge.class);
        try {
            this.updateDerivation(derivedIRI, (DirectedAcyclicGraph<String, DefaultEdge>)graph);
        }
        catch (Exception e) {
            LOGGER.fatal(e.getMessage());
            throw new JPSRuntimeException(e);
        }
    }

    public boolean validateDerivation(String derived) {
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph(DefaultEdge.class);
        try {
            this.validateDerivation(derived, (DirectedAcyclicGraph<String, DefaultEdge>)graph);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
            throw new JPSRuntimeException(e);
        }
    }

    public void dropAllDerivations() {
        DerivationSparql.dropAllDerivations(this.kbClient);
    }

    private void updateDerivation(String instance, DirectedAcyclicGraph<String, DefaultEdge> graph) {
        List<String> inputsAndDerived = DerivationSparql.getInputsAndDerived(this.kbClient, instance);
        if (!graph.containsVertex((Object)instance)) {
            graph.addVertex((Object)instance);
        }
        for (String input : inputsAndDerived) {
            if (!graph.containsVertex((Object)input)) {
                graph.addVertex((Object)input);
            }
            graph.addEdge((Object)instance, (Object)input);
            this.updateDerivation(input, graph);
        }
        List<String> inputs = DerivationSparql.getInputs(this.kbClient, instance);
        if (inputs.size() > 0 && this.isOutOfDate(instance, inputs)) {
            LOGGER.info("Updating <" + instance + ">");
            LOGGER.debug("<" + instance + "> is out-of-date when compared to <" + inputs + ">");
            String agentURL = DerivationSparql.getAgentUrl(this.kbClient, instance);
            JSONObject requestParams = new JSONObject();
            JSONArray iris = new JSONArray(inputs);
            requestParams.put(AGENT_INPUT_KEY, (Object)iris);
            requestParams.put(DERIVATION_KEY, (Object)instance);
            LOGGER.debug("Updating <" + instance + "> using agent at <" + agentURL + "> with http request " + requestParams);
            String response = AgentCaller.executeGetWithURLAndJSON(agentURL, requestParams.toString());
            LOGGER.debug("Obtained http response from agent: " + response);
            if (!DerivationSparql.isDerivedWithTimeSeries(this.kbClient, instance)) {
                List<String> newEntities = new JSONObject(response).getJSONArray(AGENT_OUTPUT_KEY).toList().stream().map(iri -> (String)iri).collect(Collectors.toList());
                List<String> entities = DerivationSparql.getDerivedEntities(this.kbClient, instance);
                List<List<String>> derivedAndType = DerivationSparql.getIsDerivedFromEntities(this.kbClient, entities);
                DerivationSparql.deleteInstances(this.kbClient, entities);
                LOGGER.debug("Deleted old instances: " + Arrays.asList(entities));
                DerivationSparql.addNewEntitiesToDerived(this.kbClient, instance, newEntities);
                LOGGER.debug("Added new instances <" + newEntities + "> to the derivation <" + instance + ">");
                if (derivedAndType.get(0).size() > 0) {
                    LOGGER.debug("This derivation contains at least one entity which is an input to another derivation");
                    LOGGER.debug("Relinking new instance(s) to the derivation by matching their rdf:type");
                    List<String> classOfNewEntities = DerivationSparql.getInstanceClass(this.kbClient, newEntities);
                    List<String> oldDerivedList = derivedAndType.get(0);
                    List<String> oldTypeList = derivedAndType.get(1);
                    for (int i = 0; i < oldDerivedList.size(); ++i) {
                        LOGGER.debug("Searching within <" + newEntities + "> with rdf:type <" + oldTypeList.get(i) + ">");
                        Integer matchingIndex = null;
                        for (int j = 0; j < classOfNewEntities.size(); ++j) {
                            if (!classOfNewEntities.get(j).contentEquals(oldTypeList.get(i))) continue;
                            if (matchingIndex != null) {
                                throw new JPSRuntimeException("Duplicate rdf:type found within output, the DerivationClient does not support this");
                            }
                            matchingIndex = j;
                        }
                        if (matchingIndex == null) {
                            String reconnectError = "Unable to find an instance with the same rdf:type to reconnect to " + oldDerivedList.get(i);
                            throw new JPSRuntimeException(reconnectError);
                        }
                        DerivationSparql.reconnectInputToDerived(this.kbClient, newEntities.get(matchingIndex), oldDerivedList.get(i));
                    }
                }
            }
            DerivationSparql.updateTimeStamp(this.kbClient, instance);
            LOGGER.info("Updated timestamp of <" + instance + ">");
        }
    }

    private void validateDerivation(String instance, DirectedAcyclicGraph<String, DefaultEdge> graph) {
        List<String> inputsAndDerived = DerivationSparql.getInputsAndDerived(this.kbClient, instance);
        if (!graph.containsVertex((Object)instance)) {
            graph.addVertex((Object)instance);
        }
        for (String input : inputsAndDerived) {
            if (!graph.containsVertex((Object)input)) {
                graph.addVertex((Object)input);
            }
            graph.addEdge((Object)instance, (Object)input);
            this.validateDerivation(input, graph);
        }
        List<String> inputs = DerivationSparql.getInputs(this.kbClient, instance);
        if (inputs.size() > 0) {
            DerivationSparql.getTimestamp(this.kbClient, instance);
            for (String input : inputs) {
                DerivationSparql.getTimestamp(this.kbClient, input);
            }
        }
    }

    private boolean isOutOfDate(String instance, List<String> inputs) {
        boolean outOfDate = false;
        long instanceTimestamp = DerivationSparql.getTimestamp(this.kbClient, instance);
        for (String input : inputs) {
            long inputTimestamp = DerivationSparql.getTimestamp(this.kbClient, input);
            if (inputTimestamp <= instanceTimestamp) continue;
            outOfDate = true;
            return outOfDate;
        }
        return outOfDate;
    }

    public String getDerivationOf(String entity) {
        return DerivationSparql.getDerivedIRI(this.kbClient, entity);
    }
}

