/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class Iso {
    public static Mappable mappableBlankNodes = (n1, n2) -> n1.isBlank() && n2.isBlank();
    public static Mappable mappableBlankNodesVariables = (n1, n2) -> {
        if (n1.isBlank() && n2.isBlank()) {
            return true;
        }
        return n1.isVariable() && n2.isVariable();
    };

    public static boolean isomorphicTriples(List<Triple> triples1, List<Triple> triples2, NodeIsomorphismMap isoMap) {
        if (triples1.size() != triples2.size()) {
            return false;
        }
        for (int i = 0; i < triples1.size(); ++i) {
            Triple t2;
            Triple t1 = triples1.get(i);
            if (Iso.tripleIso(t1, t2 = triples2.get(i), isoMap)) continue;
            return false;
        }
        return true;
    }

    public static boolean isomorphicQuads(List<Quad> quads1, List<Quad> quads2, NodeIsomorphismMap isoMap) {
        if (quads1.size() != quads2.size()) {
            return false;
        }
        for (int i = 0; i < quads1.size(); ++i) {
            Quad q2;
            Quad q1 = quads1.get(i);
            if (Iso.quadIso(q1, q2 = quads2.get(i), isoMap)) continue;
            return false;
        }
        return true;
    }

    public static boolean isomorphicNodes(List<Node> nodes1, List<Node> nodes2, NodeIsomorphismMap isoMap) {
        if (nodes1.size() != nodes2.size()) {
            return false;
        }
        for (int i = 0; i < nodes1.size(); ++i) {
            Node n2;
            Node n1 = nodes1.get(i);
            if (Iso.nodeIso(n1, n2 = nodes2.get(i), isoMap)) continue;
            return false;
        }
        return true;
    }

    public static boolean triplePathIso(TriplePath tp1, TriplePath tp2, NodeIsomorphismMap isoMap) {
        if (tp1.isTriple() ^ tp2.isTriple()) {
            return false;
        }
        if (tp1.isTriple()) {
            return Iso.tripleIso(tp1.asTriple(), tp2.asTriple(), isoMap);
        }
        return Iso.nodeIso(tp1.getSubject(), tp2.getSubject(), isoMap) && Iso.nodeIso(tp1.getObject(), tp2.getObject(), isoMap) && tp1.getPath().equalTo(tp2.getPath(), isoMap);
    }

    public static boolean tripleIso(Triple t1, Triple t2, NodeIsomorphismMap labelMap) {
        Node s1 = t1.getSubject();
        Node p1 = t1.getPredicate();
        Node o1 = t1.getObject();
        Node s2 = t2.getSubject();
        Node p2 = t2.getPredicate();
        Node o2 = t2.getObject();
        if (!Iso.nodeIso(s1, s2, labelMap)) {
            return false;
        }
        if (!Iso.nodeIso(p1, p2, labelMap)) {
            return false;
        }
        return Iso.nodeIso(o1, o2, labelMap);
    }

    public static boolean quadIso(Quad t1, Quad t2, NodeIsomorphismMap labelMap) {
        Node g1 = t1.getGraph();
        Node s1 = t1.getSubject();
        Node p1 = t1.getPredicate();
        Node o1 = t1.getObject();
        Node g2 = t2.getGraph();
        Node s2 = t2.getSubject();
        Node p2 = t2.getPredicate();
        Node o2 = t2.getObject();
        if (!Iso.nodeIso(g1, g2, labelMap)) {
            return false;
        }
        if (!Iso.nodeIso(s1, s2, labelMap)) {
            return false;
        }
        if (!Iso.nodeIso(p1, p2, labelMap)) {
            return false;
        }
        return Iso.nodeIso(o1, o2, labelMap);
    }

    public static boolean nodeIso(Node n1, Node n2, NodeIsomorphismMap isoMap) {
        if (isoMap != null) {
            if (n1.isBlank() && n2.isBlank()) {
                return isoMap.makeIsomorphic(n1, n2);
            }
            if (Var.isBlankNodeVar(n1) && Var.isBlankNodeVar(n2)) {
                return isoMap.makeIsomorphic(n1, n2);
            }
        }
        return n1.equals((Object)n2);
    }

    public static interface Mappable {
        public boolean mappable(Node var1, Node var2);
    }
}

