/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFBase;
import org.apache.jena.riot.system.StreamRDFCountingBase;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.riot.writer.WriterStreamRDFPlain;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;

public class StreamRDFLib {
    public static StreamRDF sinkNull() {
        return new StreamRDFBase();
    }

    public static StreamRDF writer(OutputStream out) {
        return new WriterStreamRDFPlain(IO.wrapUTF8((OutputStream)out));
    }

    public static StreamRDF writer(AWriter out) {
        return new WriterStreamRDFPlain(out);
    }

    public static StreamRDF writer(Writer out) {
        return new WriterStreamRDFPlain(IO.wrap((Writer)out));
    }

    public static StreamRDF writer(OutputStream out, CharSpace charSpace) {
        switch (charSpace) {
            case ASCII: {
                return new WriterStreamRDFPlain(IO.wrapASCII((OutputStream)out), charSpace);
            }
        }
        return StreamRDFLib.writer(out);
    }

    public static StreamRDF writer(AWriter out, CharSpace charSpace) {
        return new WriterStreamRDFPlain(out, charSpace);
    }

    public static StreamRDF writer(Writer out, CharSpace charSpace) {
        return new WriterStreamRDFPlain(IO.wrap((Writer)out), charSpace);
    }

    public static StreamRDF graph(Graph graph) {
        return new ParserOutputGraph(graph);
    }

    public static StreamRDF dataset(DatasetGraph dataset) {
        return new ParserOutputDataset(dataset);
    }

    public static StreamRDF sinkTriples(Sink<Triple> sink) {
        return new ParserOutputSinkTriples(sink);
    }

    public static StreamRDF sinkQuads(Sink<Quad> sink) {
        return new ParserOutputSinkQuads(sink);
    }

    public static StreamRDF extendTriplesToQuads(StreamRDF base) {
        return StreamRDFLib.extendTriplesToQuads(Quad.tripleInQuad, base);
    }

    public static StreamRDF extendTriplesToQuads(Node graphNode, StreamRDF base) {
        return new ParserOutputSinkTriplesToQuads(graphNode, base);
    }

    public static StreamRDFCounting count() {
        return new StreamRDFCountingBase(StreamRDFLib.sinkNull());
    }

    public static StreamRDFCounting count(StreamRDF other) {
        return new StreamRDFCountingBase(other);
    }

    private static class ParserOutputDataset
    extends StreamRDFBase {
        protected final DatasetGraph dsg;
        protected final PrefixMapping prefixMapping;

        public ParserOutputDataset(DatasetGraph dsg) {
            this.dsg = dsg;
            this.prefixMapping = dsg.getDefaultGraph().getPrefixMapping();
        }

        @Override
        public void triple(Triple triple) {
            this.dsg.add(Quad.defaultGraphNodeGenerated, triple.getSubject(), triple.getPredicate(), triple.getObject());
        }

        @Override
        public void quad(Quad quad) {
            if (quad.isTriple()) {
                this.dsg.add(Quad.defaultGraphNodeGenerated, quad.getSubject(), quad.getPredicate(), quad.getObject());
            } else {
                this.dsg.add(quad);
            }
        }

        @Override
        public void base(String base) {
        }

        @Override
        public void prefix(String prefix, String uri) {
            try {
                this.prefixMapping.setNsPrefix(prefix, uri);
            }
            catch (JenaException jenaException) {
                // empty catch block
            }
        }
    }

    private static class ParserOutputGraph
    extends StreamRDFBase {
        protected final Graph graph;
        protected boolean warningIssued = false;

        public ParserOutputGraph(Graph graph) {
            this.graph = graph;
        }

        @Override
        public void triple(Triple triple) {
            this.graph.add(triple);
        }

        @Override
        public void quad(Quad quad) {
            if (quad.isTriple() || quad.isDefaultGraph()) {
                this.graph.add(quad.asTriple());
            } else {
                if (!this.warningIssued) {
                    ErrorHandlerFactory.getDefaultErrorHandler().warning("Only triples or default graph data expected : named graph data ignored", -1L, -1L);
                }
                this.warningIssued = true;
            }
        }

        @Override
        public void base(String base) {
        }

        @Override
        public void prefix(String prefix, String uri) {
            try {
                this.graph.getPrefixMapping().setNsPrefix(prefix, uri);
            }
            catch (JenaException jenaException) {
                // empty catch block
            }
        }
    }

    private static class ParserOutputSinkQuads
    extends StreamRDFBase {
        private final Sink<Quad> sink;

        public ParserOutputSinkQuads(Sink<Quad> sink) {
            this.sink = sink;
        }

        @Override
        public void quad(Quad quad) {
            this.sink.send((Object)quad);
        }

        @Override
        public void finish() {
            this.sink.flush();
        }
    }

    private static class ParserOutputSinkTriples
    extends StreamRDFBase {
        private final Sink<Triple> sink;

        public ParserOutputSinkTriples(Sink<Triple> sink) {
            this.sink = sink;
        }

        @Override
        public void triple(Triple triple) {
            this.sink.send((Object)triple);
        }

        @Override
        public void finish() {
            this.sink.flush();
        }
    }

    private static class ParserOutputSinkTriplesToQuads
    extends StreamRDFWrapper {
        private final Node gn;

        ParserOutputSinkTriplesToQuads(Node gn, StreamRDF base) {
            super(base);
            this.gn = gn;
        }

        @Override
        public void triple(Triple triple) {
            this.other.quad(new Quad(this.gn, triple));
        }
    }
}

