/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.codec.digest.MurmurHash3;
import org.apache.jena.atlas.lib.BitsLong;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.lang.BlankNodeAllocator;

public class BlankNodeAllocatorHash
implements BlankNodeAllocator {
    private static int CacheSize = 1000;
    private byte[] seedBytes = null;
    private byte[] counterBytes = new byte[10];
    private Cache<String, Node> cache = null;
    private long counter = 0L;

    public BlankNodeAllocatorHash() {
        this.reset();
        this.cache = CacheFactory.createCache((int)CacheSize);
    }

    protected UUID freshSeed() {
        return UUID.randomUUID();
    }

    @Override
    public void reset() {
        UUID seed = this.freshSeed();
        long mostSigBits = seed.getMostSignificantBits();
        long leastSigBits = seed.getLeastSignificantBits();
        BitsLong.pack((long)mostSigBits, (long)0L, (int)12, (int)16);
        BitsLong.pack((long)leastSigBits, (long)0L, (int)62, (int)64);
        this.seedBytes = new byte[16];
        Bytes.setLong((long)seed.getMostSignificantBits(), (byte[])this.seedBytes, (int)0);
        Bytes.setLong((long)seed.getLeastSignificantBits(), (byte[])this.seedBytes, (int)8);
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public Node alloc(String label) {
        Callable<Node> getter = () -> this.alloc(Bytes.string2bytes((String)label));
        Node n = (Node)this.cache.getOrFill((Object)label, getter);
        return n;
    }

    @Override
    public Node create() {
        ++this.counter;
        this.counterBytes[0] = 0;
        this.counterBytes[1] = 0;
        Bytes.setLong((long)this.counter, (byte[])this.counterBytes, (int)2);
        return this.alloc(this.counterBytes);
    }

    private Node alloc(byte[] labelBytes) {
        byte[] input = new byte[this.seedBytes.length + labelBytes.length];
        System.arraycopy(this.seedBytes, 0, input, 0, this.seedBytes.length);
        System.arraycopy(labelBytes, 0, input, this.seedBytes.length, labelBytes.length);
        long[] x = MurmurHash3.hash128x64((byte[])input);
        char[] chars = new char[32];
        this.longAsHexLC(x[0], chars, 0);
        this.longAsHexLC(x[1], chars, 16);
        String hexString = new String(chars);
        return NodeFactory.createBlankNode((String)hexString);
    }

    private void longAsHexLC(long value, char[] chars, int start) {
        for (int idx = 0; idx < 8; ++idx) {
            int i = idx * 8;
            int bValue = (int)(value >> i & 0xFFL);
            int hi = (bValue & 0xF0) >> 4;
            int lo = bValue & 0xF;
            char chHi = Chars.hexDigitsLC[hi];
            char chLo = Chars.hexDigitsLC[lo];
            chars[start + 2 * idx] = chHi;
            chars[start + 2 * idx + 1] = chLo;
        }
    }
}

