/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation.ordering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.explanation.ordering.EntailedAxiomTree;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;

public class AlphaExplanationOrderer
implements ExplanationOrderer {
    protected final OWLObjectRenderer renderer;

    public AlphaExplanationOrderer(OWLObjectRenderer renderer) {
        this.renderer = OWLAPIPreconditions.checkNotNull(renderer, "renderer cannot be null");
    }

    @Override
    public ExplanationTree getOrderedExplanation(OWLAxiom entailment, Set<OWLAxiom> axioms) {
        EntailedAxiomTree root = new EntailedAxiomTree(entailment);
        ArrayList<OWLAxiom> sortedAxioms = new ArrayList<OWLAxiom>(axioms);
        Collections.sort(sortedAxioms, Comparator.comparing(this.renderer::render));
        sortedAxioms.forEach(ax -> root.addChild(new ExplanationTree((OWLAxiom)ax)));
        return root;
    }
}

