/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.journal.NoSuchIndexException;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.mdi.MetadataIndex;
import com.bigdata.service.AbstractIndexCache;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.CacheOnceMetadataIndex;
import com.bigdata.service.CachingMetadataIndex;
import com.bigdata.service.IMetadataService;
import com.bigdata.service.MetadataService;
import com.bigdata.service.NoCacheMetadataIndexView;
import com.bigdata.service.NoSuchService;
import com.bigdata.util.InnerCause;
import java.util.concurrent.ExecutionException;

public class MetadataIndexCache
extends AbstractIndexCache<IMetadataIndex> {
    protected static final transient String ERR_NO_METADATA_SERVICE = "Metadata service";
    private final AbstractScaleOutFederation<?> fed;

    public MetadataIndexCache(AbstractScaleOutFederation<?> fed, int capacity, long timeout) {
        super(capacity, timeout);
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
    }

    @Override
    protected IMetadataIndex newView(String name, long timestamp) {
        MetadataIndex.MetadataIndexMetadata mdmd = this.getMetadataIndexMetadata(name, timestamp);
        if (mdmd == null) {
            return null;
        }
        switch (this.fed.metadataIndexCachePolicy) {
            case NoCache: {
                return new NoCacheMetadataIndexView(this.fed, name, timestamp, mdmd);
            }
            case CacheAll: {
                if (timestamp == 0L || timestamp == -1L) {
                    return new CachingMetadataIndex(this.fed, name, timestamp, mdmd);
                }
                return new CacheOnceMetadataIndex(this.fed, name, timestamp, mdmd);
            }
        }
        throw new AssertionError((Object)("Unknown option: " + (Object)((Object)this.fed.metadataIndexCachePolicy)));
    }

    protected MetadataIndex.MetadataIndexMetadata getMetadataIndexMetadata(String name, long timestamp) {
        MetadataIndex.MetadataIndexMetadata mdmd;
        IMetadataService mds = this.fed.getMetadataService();
        if (mds == null) {
            throw new NoSuchService(ERR_NO_METADATA_SERVICE);
        }
        try {
            mdmd = (MetadataIndex.MetadataIndexMetadata)mds.getIndexMetadata(MetadataService.getMetadataIndexName(name), timestamp);
            assert (mdmd != null);
        }
        catch (NoSuchIndexException ex) {
            return null;
        }
        catch (ExecutionException ex) {
            if (InnerCause.isInnerCause((Throwable)ex, NoSuchIndexException.class)) {
                return null;
            }
            throw new RuntimeException(ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (mdmd == null) {
            return null;
        }
        return mdmd;
    }
}

