/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactoryBase;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceCall;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceCallImpl;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceOptions;
import com.bigdata.rdf.sparql.ast.service.SPARQLVersion;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RemoteServiceFactoryImpl
extends AbstractServiceFactoryBase {
    private final RemoteServiceOptions serviceOptions;

    public RemoteServiceFactoryImpl(SPARQLVersion sparqlVersion) {
        this.serviceOptions = new RemoteServiceOptions();
        this.serviceOptions.setSPARQLVersion(sparqlVersion);
    }

    public RemoteServiceFactoryImpl(RemoteServiceOptions serviceOptions) {
        if (serviceOptions == null) {
            throw new IllegalArgumentException();
        }
        this.serviceOptions = serviceOptions;
    }

    public RemoteServiceCall create(ServiceCallCreateParams params) {
        return new RemoteServiceCallImpl(params);
    }

    @Override
    public RemoteServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    @Override
    public Set<IVariable<?>> getRequiredBound(ServiceNode serviceNode) {
        HashSet requiredBound = new HashSet();
        IVariableOrConstant<IV> serviceRef = serviceNode.getServiceRef().getValueExpression();
        if (serviceRef != null && serviceRef instanceof IVariable) {
            requiredBound.add((IVariable)serviceRef);
        }
        return requiredBound;
    }

    @Override
    public Set<IVariable<?>> getDesiredBound(ServiceNode serviceNode) {
        HashSet desiredBound = new HashSet();
        Iterator<IVariable<?>> varIt = BOpUtility.getSpannedVariables(serviceNode.getGraphPattern());
        while (varIt.hasNext()) {
            desiredBound.add(varIt.next());
        }
        return desiredBound;
    }
}

