/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.ModifiableBOpBase;
import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupMemberNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IGroupNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class GroupNodeBase<E extends IGroupMemberNode>
extends GroupMemberNodeBase<E>
implements IGroupNode<E> {
    private static final long serialVersionUID = 1L;

    public GroupNodeBase(GroupNodeBase<E> op) {
        super(op);
    }

    public GroupNodeBase(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    protected GroupNodeBase() {
    }

    @Override
    public Iterator<E> iterator() {
        return this.argIterator();
    }

    public List<E> getChildren() {
        return this.args();
    }

    @Override
    public ModifiableBOpBase setArg(int index, BOp newArg) {
        super.setArg(index, newArg);
        ((IGroupMemberNode)newArg).setParent(this);
        return this;
    }

    @Override
    public void addArg(BOp newArg) {
        super.addArg(newArg);
        ((IGroupMemberNode)newArg).setParent(this);
    }

    @Override
    public void addArg(int index, BOp newArg) {
        super.addArg(index, newArg);
        ((IGroupMemberNode)newArg).setParent(this);
    }

    @Override
    public boolean removeArg(BOp child) {
        if (super.removeArg(child)) {
            ((IGroupMemberNode)child).setParent(null);
            return true;
        }
        return false;
    }

    @Override
    public IGroupNode<E> addChild(E child) {
        this.addArg((BOp)child);
        return this;
    }

    @Override
    public IGroupNode<E> removeChild(E child) {
        this.removeArg((BOp)child);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.arity() == 0;
    }

    @Override
    public int size() {
        return this.arity();
    }

    public final List<FilterNode> getAttachedJoinFilters() {
        List filters = (List)this.getProperty("filters");
        if (filters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(filters);
    }

    public final void setAttachedJoinFilters(List<FilterNode> filters) {
        this.setProperty("filters", filters);
    }

    @Override
    public GroupNodeBase<E> clone() {
        GroupNodeBase tmp = (GroupNodeBase)super.clone();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            IGroupMemberNode aChild = (IGroupMemberNode)tmp.get(i);
            aChild = (IGroupMemberNode)((Object)((ASTBase)((Object)aChild)).clone());
            tmp.setArg(i, (ASTBase)((Object)aChild));
        }
        return tmp;
    }

    @Override
    public String toString(int indent) {
        List<FilterNode> filters;
        IVariable<?>[] joinVars;
        String s = GroupNodeBase.indent(indent);
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(s).append(this.getClass().getSimpleName());
        if (this instanceof IJoinNode) {
            IJoinNode joinNode = (IJoinNode)((Object)this);
            if (joinNode.isOptional()) {
                sb.append(" [optional]");
            }
            if (joinNode.isMinus()) {
                sb.append(" [minus]");
            }
        }
        if (this instanceof JoinGroupNode) {
            JoinGroupNode joinGroup = (JoinGroupNode)this;
            if (joinGroup.getContext() != null) {
                sb.append(" [context=" + joinGroup.getContext() + "]");
            }
            if (joinGroup.getProperty("optimizer") != null) {
                sb.append(" [optimizer=" + (Object)((Object)joinGroup.getQueryOptimizer()) + "]");
            }
        }
        if (this instanceof GraphPatternGroup) {
            Object[] projectInVars;
            GraphPatternGroup t = (GraphPatternGroup)this;
            Object[] joinVars2 = t.getJoinVars();
            if (joinVars2 != null) {
                sb.append(" [joinVars=" + Arrays.toString(joinVars2) + "]");
            }
            if ((projectInVars = t.getProjectInVars()) != null) {
                sb.append(" [projectInVars=" + Arrays.toString(projectInVars) + "]");
            }
        }
        sb.append(" {");
        for (IQueryNode n : this) {
            if (n instanceof AssignmentNode) {
                sb.append("\n");
            }
            sb.append(n.toString(indent + 1));
            if (((IGroupMemberNode)n).getParent() == this) continue;
            sb.append(" : ERROR : parent not [this]");
            throw new RuntimeException("Parent not this: child=" + n + ", this=" + this.toShortString() + ", but parent=" + ((IGroupMemberNode)n).getParent());
        }
        sb.append("\n").append(s).append("}");
        if (this instanceof GraphPatternGroup && (joinVars = ((GraphPatternGroup)this).getJoinVars()) != null && joinVars.length > 0) {
            sb.append(" JOIN ON (");
            boolean first = true;
            for (IVariable<?> var : joinVars) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(var);
                first = false;
            }
            sb.append(")");
        }
        if (!(filters = this.getAttachedJoinFilters()).isEmpty()) {
            for (FilterNode filter : filters) {
                sb.append(filter.toString(indent + 1));
            }
        }
        if (this.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY) != null) {
            sb.append(" AST2BOpBase.estimatedCardinality=");
            sb.append(this.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY).toString());
        }
        if (this.getQueryHints() != null && !this.getQueryHints().isEmpty()) {
            sb.append("\n");
            sb.append(GroupNodeBase.indent(indent));
            sb.append("queryHints");
            sb.append("=");
            sb.append(this.getQueryHints().toString());
        }
        return sb.toString();
    }

    @Override
    public int replaceWith(BOp oldChild, BOp newChild) {
        int i = super.replaceWith(oldChild, newChild);
        if (i > 0) {
            if (((IGroupMemberNode)oldChild).getParent() == this) {
                ((IGroupMemberNode)oldChild).setParent(null);
            }
            ((IGroupMemberNode)newChild).setParent(this);
        }
        return i;
    }

    static interface Annotations
    extends GroupMemberNodeBase.Annotations,
    IJoinNode.Annotations {
    }
}

