/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.inf.ClosureStats;
import com.bigdata.rdf.properties.PropertiesFormat;
import com.bigdata.rdf.properties.PropertiesParser;
import com.bigdata.rdf.properties.PropertiesParserFactory;
import com.bigdata.rdf.properties.PropertiesParserRegistry;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.RESTServlet;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.DataLoader;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.util.NV;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.rio.RDFFormat;

public class DataLoaderServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(DataLoaderServlet.class);
    private RESTServlet m_restServlet;

    public void init() throws ServletException {
        super.init();
        this.m_restServlet = new RESTServlet();
        this.m_restServlet.init(this.getServletConfig());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getRequestURI().endsWith("/dataloader")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"");
            }
            this.doBulkLoad(req, resp);
            return;
        }
        this.m_restServlet.doPost(req, resp);
    }

    private void doBulkLoad(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PropertiesParserFactory parserFactory;
        PropertiesFormat format;
        if (!DataLoaderServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        BigdataRDFContext context = this.getBigdataRDFContext();
        IIndexManager indexManager = context.getIndexManager();
        PrintStream os = new PrintStream((OutputStream)resp.getOutputStream());
        String contentType = req.getContentType();
        if (log.isInfoEnabled()) {
            log.info((Object)("Request body: " + contentType));
        }
        if ((format = PropertiesFormat.forMIMEType((String)contentType)) == null) {
            DataLoaderServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as Properties: " + contentType, new NV[0]);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Format=" + format));
        }
        if ((parserFactory = (PropertiesParserFactory)PropertiesParserRegistry.getInstance().get((Object)format)) == null) {
            DataLoaderServlet.buildAndCommitResponse(resp, 500, "text/plain", "Parser factory not found: Content-Type=" + contentType + ", format=" + format, new NV[0]);
            return;
        }
        PropertiesParser parser = parserFactory.getParser();
        Properties props = parser.parse((InputStream)req.getInputStream());
        RDFFormat rdfFormat = RDFFormat.valueOf((String)props.getProperty("format", "rdf/xml"));
        String baseURI = props.getProperty("baseURI");
        String defaultGraph = props.getProperty("defaultGraph");
        String propertyFile = props.getProperty("propertyFile");
        if (propertyFile == null) {
            throw new RuntimeException("propertyFile is required for the DataLoader");
        }
        boolean quiet = this.getBooleanProperty(props, "quiet", true);
        int verbose = this.getIntProperty(props, "verbose", 0);
        boolean closure = this.getBooleanProperty(props, "closure", false);
        boolean durableQueues = this.getBooleanProperty(props, "durableQueues", true);
        String namespace = props.getProperty("namespace", "kb");
        String fileOrDirs = props.getProperty("fileOrDirs");
        if (fileOrDirs == null) {
            throw new RuntimeException("fileOrDirs is required for the DataLoader");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("DataLoader called ( rdfFormat = " + rdfFormat + " ; baseURI = " + baseURI + " ; defaultGraph = " + defaultGraph + " ; quiet = " + quiet + " ; verbose = " + verbose + " ; " + "durableQueues = " + durableQueues + " ; namespace = " + namespace + "propertyFile = " + propertyFile + " ; fileOrDirs = " + fileOrDirs + " )"));
        }
        Properties properties = DataLoader.processProperties(propertyFile, quiet, verbose, durableQueues);
        AbstractTripleStore kb = (AbstractTripleStore)indexManager.getResourceLocator().locate(namespace, 0L);
        if (kb == null) {
            kb = new LocalTripleStore(indexManager, namespace, 0L, properties);
            kb.create();
            if (log.isInfoEnabled()) {
                log.info((Object)("Created namespace:  " + namespace));
            }
        }
        DataLoader dataLoader = new DataLoader(properties, kb, os);
        DataLoader.MyLoadStats totals = dataLoader.newLoadStats();
        String[] fileToLoad = fileOrDirs.split(",");
        for (int i = 0; i < fileToLoad.length; ++i) {
            File nextFile = new File(fileToLoad[i]);
            if (!nextFile.exists()) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)(nextFile.getName() + " does not exist.  Skipping."));
                continue;
            }
            if (nextFile.isHidden()) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)(nextFile.getName() + " is hidden.  Skipping."));
                continue;
            }
            dataLoader.loadFiles(totals, 0, nextFile, baseURI, rdfFormat, defaultGraph, DataLoader.getFilenameFilter(), true);
        }
        dataLoader.endSource();
        if (!quiet) {
            os.println("Load: " + totals);
        }
        if (dataLoader.getClosureEnum() == DataLoader.ClosureEnum.None && closure) {
            if (verbose > 0) {
                dataLoader.logCounters(dataLoader.getDatabase());
            }
            if (!quiet) {
                os.println("Computing closure.");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Computing closure.");
            }
            ClosureStats stats = dataLoader.doClosure();
            if (!quiet) {
                os.println("Closure: " + stats.toString());
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Closure: " + stats.toString()));
            }
        }
        kb.commit();
        totals.commit();
        if (verbose > 1) {
            dataLoader.logCounters(dataLoader.getDatabase());
        }
        os.flush();
    }

    private boolean getBooleanProperty(Properties props, String property, boolean defaultValue) {
        String propVal = props.getProperty(property);
        if (propVal != null) {
            boolean retVal = Boolean.parseBoolean(propVal);
            return retVal;
        }
        return defaultValue;
    }

    private int getIntProperty(Properties props, String property, int defaultValue) {
        String propVal = props.getProperty(property);
        if (propVal != null) {
            int retVal = Integer.parseInt(propVal);
            return retVal;
        }
        return defaultValue;
    }
}

