/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.BOpUtility;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.sparql.ASTDeferredIVResolutionInitializer;
import com.bigdata.rdf.sail.sparql.BaseDeclProcessor;
import com.bigdata.rdf.sail.sparql.BigdataASTContext;
import com.bigdata.rdf.sail.sparql.BigdataExprBuilder;
import com.bigdata.rdf.sail.sparql.BigdataParsedQuery;
import com.bigdata.rdf.sail.sparql.BigdataParsedUpdate;
import com.bigdata.rdf.sail.sparql.BlankNodeVarProcessor;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sail.sparql.StringEscapesProcessor;
import com.bigdata.rdf.sail.sparql.UpdateExprBuilder;
import com.bigdata.rdf.sail.sparql.VerifyAggregates;
import com.bigdata.rdf.sail.sparql.ast.ASTOperationContainer;
import com.bigdata.rdf.sail.sparql.ast.ASTPrefixDecl;
import com.bigdata.rdf.sail.sparql.ast.ASTQueryContainer;
import com.bigdata.rdf.sail.sparql.ast.ASTUpdate;
import com.bigdata.rdf.sail.sparql.ast.ASTUpdateContainer;
import com.bigdata.rdf.sail.sparql.ast.ASTUpdateSequence;
import com.bigdata.rdf.sail.sparql.ast.Node;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.SyntaxTreeBuilder;
import com.bigdata.rdf.sail.sparql.ast.SyntaxTreeBuilderVisitor;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.Update;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import com.bigdata.rdf.sparql.ast.hints.QueryHintScope;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.ParsedOperation;
import org.openrdf.query.parser.ParsedUpdate;
import org.openrdf.query.parser.QueryParser;
import org.openrdf.query.parser.QueryParserUtil;

public class Bigdata2ASTSPARQLParser
implements QueryParser {
    private static final Logger log = Logger.getLogger(Bigdata2ASTSPARQLParser.class);
    private static final URI queryScope = new URIImpl("http://www.bigdata.com/queryHints#" + (Object)((Object)QueryHintScope.Query));
    private static final URI queryIdHint = new URIImpl("http://www.bigdata.com/queryHints#queryId");

    public ParsedOperation parseOperation(String operation, String baseURI) throws MalformedQueryException {
        String strippedOperation = QueryParserUtil.removeSPARQLQueryProlog((String)operation).toUpperCase();
        BigdataParsedQuery parsedOperation = strippedOperation.startsWith("SELECT") || strippedOperation.startsWith("CONSTRUCT") || strippedOperation.startsWith("DESCRIBE") || strippedOperation.startsWith("ASK") ? this.parseQuery(operation, baseURI) : this.parseUpdate(operation, baseURI);
        return parsedOperation;
    }

    public BigdataParsedQuery parseQuery(String queryStr, String baseURI) throws MalformedQueryException {
        return new BigdataParsedQuery(this.parseQuery2(queryStr, baseURI));
    }

    public ParsedUpdate parseUpdate(String updateStr, String baseURI) throws MalformedQueryException {
        return new BigdataParsedUpdate(this.parseUpdate2(updateStr, baseURI));
    }

    public ASTContainer parseUpdate2(String updateStr, String baseURI) throws MalformedQueryException {
        long startTime = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info((Object)updateStr);
        }
        try {
            ASTUpdateSequence updateSequence = SyntaxTreeBuilder.parseUpdateSequence((String)updateStr);
            UpdateRoot updateRoot = new UpdateRoot();
            ASTContainer astContainer = new ASTContainer(updateRoot);
            astContainer.setQueryString(updateStr);
            astContainer.setParseTree(updateSequence);
            UpdateExprBuilder updateExprBuilder = new UpdateExprBuilder(new BigdataASTContext(new LinkedHashMap<Value, BigdataValue>()));
            List updateOperations = updateSequence.getUpdateContainers();
            List sharedPrefixDeclarations = null;
            for (int i = 0; i < updateOperations.size(); ++i) {
                ASTUpdateContainer uc = (ASTUpdateContainer)updateOperations.get(i);
                if (uc.jjtGetNumChildren() == 0 && i > 0 && i < updateOperations.size() - 1) {
                    throw new MalformedQueryException("empty update in sequence not allowed");
                }
                StringEscapesProcessor.process((ASTOperationContainer)uc);
                BaseDeclProcessor.process((ASTOperationContainer)uc, baseURI);
                List prefixDeclList = uc.getPrefixDeclList();
                if (prefixDeclList == null || prefixDeclList.isEmpty()) {
                    if (sharedPrefixDeclarations != null) {
                        for (ASTPrefixDecl prefixDecl : sharedPrefixDeclarations) {
                            uc.jjtAppendChild((Node)prefixDecl);
                        }
                    }
                } else {
                    sharedPrefixDeclarations = prefixDeclList;
                }
                PrefixDeclProcessor.process((ASTOperationContainer)uc);
                BlankNodeVarProcessor.process((ASTOperationContainer)uc);
                new ASTDeferredIVResolutionInitializer().process((ASTOperationContainer)uc);
                ASTUpdate updateNode = uc.getUpdate();
                if (updateNode == null) continue;
                Update updateOp = (Update)updateNode.jjtAccept((SyntaxTreeBuilderVisitor)updateExprBuilder, null);
                updateOp.setDatasetClauses(updateNode.getDatasetClauseList());
                updateRoot.addChild(updateOp);
            }
            astContainer.setQueryParseTime(System.nanoTime() - startTime);
            return astContainer;
        }
        catch (ParseException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
        catch (TokenMgrError e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
    }

    public ASTContainer parseQuery2(String queryStr, String baseURI) throws MalformedQueryException {
        long startTime = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info((Object)queryStr);
        }
        try {
            ASTQueryContainer qc = SyntaxTreeBuilder.parseQuery((String)queryStr);
            StringEscapesProcessor.process((ASTOperationContainer)qc);
            BaseDeclProcessor.process((ASTOperationContainer)qc, baseURI);
            Map<String, String> prefixes = PrefixDeclProcessor.process((ASTOperationContainer)qc);
            BlankNodeVarProcessor.process((ASTOperationContainer)qc);
            ASTDeferredIVResolutionInitializer resolver = new ASTDeferredIVResolutionInitializer();
            resolver.process((ASTOperationContainer)qc);
            QueryRoot queryRoot = this.buildQueryModel(qc, resolver.getValues());
            ASTContainer ast = new ASTContainer(queryRoot);
            ast.setQueryString(queryStr);
            ast.setParseTree(qc);
            this.doQueryIdHint(ast, queryRoot);
            queryRoot.setPrefixDecls(prefixes);
            VerifyAggregates.verifyAggregate(queryRoot);
            ast.setQueryParseTime(System.nanoTime() - startTime);
            return ast;
        }
        catch (IllegalArgumentException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
        catch (TokenMgrError e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
    }

    private QueryRoot buildQueryModel(ASTQueryContainer qc, Map<Value, BigdataValue> values) throws MalformedQueryException {
        BigdataExprBuilder exprBuilder = new BigdataExprBuilder(new BigdataASTContext(values));
        try {
            return (QueryRoot)qc.jjtAccept((SyntaxTreeBuilderVisitor)exprBuilder, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
    }

    private void doQueryIdHint(ASTContainer ast, QueryRoot queryRoot) throws MalformedQueryException {
        Iterator<StatementPatternNode> itr = BOpUtility.visitAll(queryRoot, StatementPatternNode.class);
        while (itr.hasNext()) {
            StatementPatternNode sp = itr.next();
            if (!queryIdHint.equals((Object)sp.p().getValue())) continue;
            if (!queryScope.equals((Object)sp.s().getValue())) {
                throw new MalformedQueryException("queryId must be in scope " + (Object)((Object)QueryHintScope.Query));
            }
            String queryIdStr = sp.o().getValue().stringValue();
            try {
                UUID.fromString(queryIdStr);
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedQueryException("Not a valid UUID: " + queryIdStr);
            }
            ast.setQueryHint("queryId", queryIdStr);
            return;
        }
    }
}

