/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.axioms.Axioms;
import com.bigdata.rdf.rules.InferenceEngine;
import com.bigdata.rdf.rules.MappedProgram;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.rule.Rule;
import java.util.Collections;
import java.util.List;

public abstract class BaseClosure {
    protected final AbstractTripleStore db;
    protected final boolean rdfsOnly;
    protected final boolean forwardChainRdfTypeRdfsResource;
    protected final boolean forwardChainOwlSameAsClosure;
    protected final boolean forwardChainOwlSameAsProperties;
    protected final boolean forwardChainOwlEquivalentProperty;
    protected final boolean forwardChainOwlEquivalentClass;
    protected final boolean forwardChainOwlTransitiveProperty;
    protected final boolean forwardChainOwlInverseOf;
    protected final boolean forwardChainOwlHasValue;
    protected final boolean forwardChainOwlSymmetricProperty;
    protected final boolean enableOwlFunctionalAndInverseFunctionalProperty;
    final Axioms axioms;
    protected final Vocabulary vocab;

    protected BaseClosure(AbstractTripleStore db) {
        if (db == null) {
            throw new IllegalArgumentException();
        }
        this.db = db;
        InferenceEngine inf = db.getInferenceEngine();
        this.axioms = db.getAxioms();
        this.vocab = db.getVocabulary();
        this.rdfsOnly = this.axioms.isRdfSchema() && !this.axioms.isOwlSameAs();
        this.forwardChainRdfTypeRdfsResource = inf.forwardChainRdfTypeRdfsResource;
        this.forwardChainOwlSameAsClosure = inf.forwardChainOwlSameAsClosure;
        this.forwardChainOwlSameAsProperties = inf.forwardChainOwlSameAsProperties;
        this.forwardChainOwlEquivalentProperty = inf.forwardChainOwlEquivalentProperty;
        this.forwardChainOwlEquivalentClass = inf.forwardChainOwlEquivalentClass;
        this.forwardChainOwlTransitiveProperty = inf.forwardChainOwlTransitiveProperty;
        this.forwardChainOwlInverseOf = inf.forwardChainOwlInverseOf;
        this.forwardChainOwlHasValue = inf.forwardChainOwlHasValue;
        this.forwardChainOwlSymmetricProperty = inf.forwardChainOwlSymmetricProperty;
        this.enableOwlFunctionalAndInverseFunctionalProperty = inf.enableOwlFunctionalAndInverseFunctionalProperty;
    }

    public abstract MappedProgram getProgram(String var1, String var2);

    protected List<Rule> getCustomRules(String database) {
        return Collections.EMPTY_LIST;
    }
}

