/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.jsr166.LinkedBlockingQueue;
import com.bigdata.rdf.changesets.ChangeAction;
import com.bigdata.rdf.changesets.ChangeRecord;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataBNodeImpl;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.IStatementBuffer;
import com.bigdata.rdf.rio.UnificationException;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.util.concurrent.LatchedExecutor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class StatementBuffer<S extends Statement>
implements IStatementBuffer<S>,
ICounterSetAccess {
    private static final Logger log = Logger.getLogger(StatementBuffer.class);
    protected final BigdataValue[] values;
    protected final BigdataStatement[] stmts;
    protected int numValues;
    protected int numStmts;
    private long numTotalStmts;
    protected int numURIs;
    protected int numLiterals;
    protected int numBNodes;
    protected int numSIDs;
    private final Map<Value, BigdataValue> distinctTermMap;
    private Map<String, BigdataBNode> bnodes;
    private Set<BigdataStatement> deferredStmts;
    private Map<BigdataBNodeImpl, ReifiedStmt> reifiedStmts;
    private boolean statementIdentifiers;
    private final AbstractTripleStore statementStore;
    protected final AbstractTripleStore database;
    private final int arity;
    protected final BigdataValueFactory valueFactory;
    private final BigdataURI RDF_SUBJECT;
    private final BigdataURI RDF_PREDICATE;
    private final BigdataURI RDF_OBJECT;
    private final BigdataURI RDF_STATEMENT;
    private final BigdataURI RDF_TYPE;
    private final int bufferCapacity;
    private final int queueCapacity;
    private int batchAddCount;
    private int batchTakeCount;
    private int batchMergeCount;
    private int batchWriteCount;
    private final LinkedBlockingQueue<Batch<S>> queue;
    private final Executor executor;
    private volatile FutureTask<Void> ft;
    private boolean readOnly = false;
    private IChangeLog changeLog;
    protected IWrittenSPOArray didWriteCallback = null;

    @Override
    public final AbstractTripleStore getStatementStore() {
        return this.statementStore;
    }

    @Override
    public final AbstractTripleStore getDatabase() {
        return this.database;
    }

    public int getCapacity() {
        return this.bufferCapacity;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    @Override
    public boolean isEmpty() {
        return this.numStmts == 0;
    }

    @Override
    public int size() {
        return this.numStmts;
    }

    public String toString() {
        return "numURIs=" + this.numURIs + ", numLiterals=" + this.numLiterals + ", numBNodes=" + this.numBNodes + ", numStmts=" + this.numStmts + ", numValues=" + this.numValues + ", numSids=" + this.numSIDs + ", values.length=" + (this.values != null ? String.valueOf(this.values.length) : "null") + ", stmts.length=" + (this.stmts != null ? String.valueOf(this.stmts.length) : "null") + ", bnodes.size()=" + (this.bnodes != null ? String.valueOf(this.bnodes.size()) : "null") + ", distinctTermMap.size()=" + (this.distinctTermMap != null ? String.valueOf(this.distinctTermMap.size()) : "null") + ", reifiedStmts.size()=" + (this.reifiedStmts != null ? String.valueOf(this.reifiedStmts.size()) : "null") + ", deferredStmts.size()=" + (this.deferredStmts != null ? String.valueOf(this.deferredStmts.size()) : "null") + (this.queue == null ? "" : ", queue.size=" + this.queue.size());
    }

    @Override
    public CounterSet getCounters() {
        CounterSet counters = new CounterSet();
        counters.addCounter("readOnly", new OneShotInstrument<Boolean>(this.readOnly));
        counters.addCounter("bnodesSize", new Instrument<Integer>(){

            @Override
            public void sample() {
                Map t = StatementBuffer.this.bnodes;
                if (t != null) {
                    this.setValue(t.size());
                }
            }
        });
        counters.addCounter("distinctTermMapSize", new Instrument<Integer>(){

            @Override
            public void sample() {
                Map t = StatementBuffer.this.distinctTermMap;
                if (t != null) {
                    this.setValue(t.size());
                }
            }
        });
        counters.addCounter("bufferCapacity", new OneShotInstrument<Integer>(this.bufferCapacity));
        counters.addCounter("batchAddCount", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(StatementBuffer.this.batchAddCount);
            }
        });
        counters.addCounter("batchWriteCount", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(StatementBuffer.this.batchWriteCount);
            }
        });
        if (this.queue != null) {
            counters.addCounter("queueCapacity", new OneShotInstrument<Integer>(this.queueCapacity));
            counters.addCounter("queueSize", new Instrument<Integer>(){

                @Override
                public void sample() {
                    LinkedBlockingQueue t = StatementBuffer.this.queue;
                    if (t != null) {
                        this.setValue(t.size());
                    }
                }
            });
            counters.addCounter("batchTakeCount", new Instrument<Integer>(){

                @Override
                public void sample() {
                    this.setValue(StatementBuffer.this.batchTakeCount);
                }
            });
            counters.addCounter("batchMergeCount", new Instrument<Integer>(){

                @Override
                public void sample() {
                    this.setValue(StatementBuffer.this.batchMergeCount);
                }
            });
        }
        return counters;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public void setChangeLog(IChangeLog changeLog) {
        this.changeLog = changeLog;
    }

    public StatementBuffer(AbstractTripleStore database, int capacity) {
        this(database, capacity, 10);
    }

    public StatementBuffer(AbstractTripleStore database, int capacity, int queueCapacity) {
        this(null, database, capacity, queueCapacity);
    }

    public StatementBuffer(TempTripleStore statementStore, AbstractTripleStore database, int capacity, int queueCapacity) {
        if (database == null) {
            throw new IllegalArgumentException();
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (queueCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.statementStore = statementStore;
        this.database = database;
        this.arity = database.getSPOKeyArity();
        this.valueFactory = database.getValueFactory();
        this.bufferCapacity = capacity;
        this.queueCapacity = queueCapacity;
        this.values = new BigdataValue[capacity * this.arity + 5];
        this.stmts = new BigdataStatement[capacity];
        this.distinctTermMap = new HashMap<Value, BigdataValue>(capacity * this.arity);
        this.statementIdentifiers = database.getStatementIdentifiers();
        if (log.isInfoEnabled()) {
            log.info((Object)("capacity=" + capacity + ", sids=" + this.statementIdentifiers + ", statementStore=" + statementStore + ", database=" + database + ", arity=" + this.arity));
        }
        this.RDF_SUBJECT = this.valueFactory.asValue(RDF.SUBJECT);
        this.RDF_PREDICATE = this.valueFactory.asValue(RDF.PREDICATE);
        this.RDF_OBJECT = this.valueFactory.asValue(RDF.OBJECT);
        this.RDF_STATEMENT = this.valueFactory.asValue(RDF.STATEMENT);
        this.RDF_TYPE = this.valueFactory.asValue(RDF.TYPE);
        this.getDistinctTerm(this.RDF_SUBJECT, true);
        this.getDistinctTerm(this.RDF_PREDICATE, true);
        this.getDistinctTerm(this.RDF_OBJECT, true);
        this.getDistinctTerm(this.RDF_STATEMENT, true);
        this.getDistinctTerm(this.RDF_TYPE, true);
        if (!this.statementIdentifiers && queueCapacity != 0) {
            this.queue = new LinkedBlockingQueue(10);
            this.executor = new LatchedExecutor(database.getExecutorService(), 1);
        } else {
            this.queue = null;
            this.executor = null;
            this.ft = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ft != null) {
            this.reset();
        }
    }

    private void putOnQueue(Batch<S> batch) throws InterruptedException {
        FutureTask<Void> f;
        while ((f = this.ft) != null && !f.isDone()) {
            if (!this.queue.offer(batch, 100L, TimeUnit.MILLISECONDS)) continue;
            return;
        }
        if (f == null) {
            throw new RuntimeException("Writer is done, but reader still working?");
        }
        if (f.isDone()) {
            throw new RuntimeException("Writer is done, but reader still working?");
        }
    }

    @Override
    public long flush() {
        this.incrementalWrite();
        if (this.queue != null) {
            try {
                this.queue.put(Batch.POISON_PILL);
                FutureTask<Void> ft = this.ft;
                if (ft != null) {
                    ft.get();
                }
            }
            catch (InterruptedException e) {
                this.ft.cancel(true);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        this.reset();
        return 0L;
    }

    @Override
    public void reset() {
        this._clear();
        this.bnodes = null;
        this.deferredStmts = null;
        this.reifiedStmts = null;
        if (this.queue != null) {
            FutureTask<Void> ft = this.ft;
            if (ft != null) {
                ft.cancel(true);
                this.ft = null;
            }
            this.queue.clear();
        }
    }

    @Override
    public void setBNodeMap(Map<String, BigdataBNode> bnodes) {
        if (bnodes == null) {
            throw new IllegalArgumentException();
        }
        if (this.bnodes != null) {
            throw new IllegalStateException();
        }
        this.bnodes = bnodes;
    }

    protected void _clear() {
        int i;
        for (i = 0; i < this.numValues; ++i) {
            this.values[i] = null;
        }
        for (i = 0; i < this.numStmts; ++i) {
            this.stmts[i] = null;
        }
        this.numValues = 0;
        this.numStmts = 0;
        this.numBNodes = 0;
        this.numLiterals = 0;
        this.numURIs = 0;
        this.numSIDs = 0;
        if (this.distinctTermMap != null) {
            this.distinctTermMap.clear();
            this.getDistinctTerm(this.RDF_SUBJECT, true);
            this.getDistinctTerm(this.RDF_PREDICATE, true);
            this.getDistinctTerm(this.RDF_OBJECT, true);
            this.getDistinctTerm(this.RDF_STATEMENT, true);
            this.getDistinctTerm(this.RDF_TYPE, true);
        }
    }

    protected void incrementalWrite() {
        if (this.bnodes != null) {
            for (BigdataBNode bnode : this.bnodes.values()) {
                if (bnode.isStatementIdentifier() || bnode.getIV() != null) continue;
                this.values[this.numValues++] = bnode;
                ++this.numBNodes;
            }
        }
        if (this.queue == null) {
            new Batch(this, false).writeNow();
            ++this.batchWriteCount;
            this._clear();
        } else {
            if (this.ft == null) {
                this.ft = new FutureTask<Void>(new DrainQueueCallable());
                this.executor.execute(this.ft);
            }
            try {
                this.queue.put(new Batch(this, true));
                ++this.batchAddCount;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void add(Resource s, URI p, Value o) {
        this.add(s, p, o, null, StatementEnum.Explicit);
    }

    @Override
    public void add(Resource s, URI p, Value o, Resource c) {
        this.add(s, p, o, c, StatementEnum.Explicit);
    }

    @Override
    public void add(Resource s, URI p, Value o, Resource c, StatementEnum type) {
        if (this.nearCapacity()) {
            this.incrementalWrite();
        }
        this.handleStatement(s, p, o, c, type);
    }

    @Override
    public void add(Statement e) {
        this.add(e.getSubject(), e.getPredicate(), e.getObject(), e.getContext(), e instanceof BigdataStatement ? ((BigdataStatement)e).getStatementType() : null);
    }

    public boolean nearCapacity() {
        if (this.numStmts + 1 > this.bufferCapacity) {
            return true;
        }
        return this.numValues + this.arity > this.values.length;
    }

    private BigdataValue getDistinctTerm(BigdataValue term, boolean addIfAbsent) {
        if (term == null) {
            return null;
        }
        if (term instanceof BNode) {
            BigdataBNode bnode = (BigdataBNode)term;
            BigdataStatement stmt = bnode.getStatement();
            if (stmt != null) {
                bnode.setStatement(this.valueFactory.createStatement((BigdataResource)this.getDistinctTerm(stmt.getSubject(), true), (BigdataURI)this.getDistinctTerm(stmt.getPredicate(), true), this.getDistinctTerm(stmt.getObject(), true)));
                return bnode;
            }
            String id = bnode.getID();
            if (this.bnodes == null) {
                this.bnodes = new HashMap<String, BigdataBNode>(this.bufferCapacity);
                this.bnodes.put(id, bnode);
            } else {
                BigdataBNode existingBNode = this.bnodes.get(id);
                if (existingBNode != null) {
                    return existingBNode;
                }
                this.bnodes.put(id, bnode);
            }
        } else {
            BigdataValue existingTerm = this.distinctTermMap.get(term);
            if (existingTerm != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("duplicate: " + term));
                }
                if (this.equals(existingTerm, this.RDF_SUBJECT, this.RDF_PREDICATE, this.RDF_OBJECT, this.RDF_TYPE, this.RDF_STATEMENT) && addIfAbsent) {
                    this.addTerm(term);
                }
                return existingTerm;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("new term: " + term));
            }
            if (this.distinctTermMap.put(term, term) != null) {
                throw new AssertionError();
            }
        }
        if (addIfAbsent) {
            this.addTerm(term);
        }
        return term;
    }

    private void addTerm(BigdataValue term) {
        if (term == null) {
            return;
        }
        if (term instanceof URI) {
            ++this.numURIs;
            this.values[this.numValues++] = term;
        } else if (!(term instanceof BNode)) {
            ++this.numLiterals;
            this.values[this.numValues++] = term;
        }
    }

    protected void handleStatement(Resource _s, URI _p, Value _o, Resource _c, StatementEnum type) {
        Object object = _c = this.database.isQuads() ? _c : null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("handle stmt: " + _s + ", " + _p + ", " + _o + ", " + _c));
        }
        BigdataResource s = (BigdataResource)this.getDistinctTerm(this.valueFactory.asValue(_s), true);
        BigdataURI p = (BigdataURI)this.getDistinctTerm(this.valueFactory.asValue(_p), true);
        BigdataValue o = this.getDistinctTerm(this.valueFactory.asValue(_o), true);
        BigdataResource c = (BigdataResource)this.getDistinctTerm(this.valueFactory.asValue(_c), true);
        BigdataStatement stmt = this.valueFactory.createStatement(s, p, o, c, type);
        if (this.statementIdentifiers && s instanceof BNode) {
            if (this.equals(p, this.RDF_SUBJECT, this.RDF_PREDICATE, this.RDF_OBJECT)) {
                ReifiedStmt reifiedStmt;
                BigdataBNodeImpl sid = (BigdataBNodeImpl)s;
                if (sid.getStatement() != null) {
                    this.checkSid(sid, p, o);
                    log.warn((Object)("seeing a duplicate value for " + sid + ": " + p + "=" + o));
                    return;
                }
                if (this.reifiedStmts == null) {
                    this.reifiedStmts = new HashMap<BigdataBNodeImpl, ReifiedStmt>();
                }
                if (this.reifiedStmts.containsKey(sid)) {
                    reifiedStmt = this.reifiedStmts.get(sid);
                } else {
                    reifiedStmt = new ReifiedStmt();
                    this.reifiedStmts.put(sid, reifiedStmt);
                }
                reifiedStmt.set(p, o);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("reified piece: " + stmt));
                }
                if (reifiedStmt.isFullyBound(this.arity)) {
                    sid.setStatement(reifiedStmt.toStatement(this.valueFactory));
                    this.reifiedStmts.remove(sid);
                }
                return;
            }
            if (this.equals(o, this.RDF_STATEMENT) && this.equals(p, this.RDF_TYPE)) {
                return;
            }
        }
        this.stmts[this.numStmts++] = stmt;
        ++this.numTotalStmts;
        FutureTask<Void> f = this.ft;
        if (f != null && f.isDone()) {
            try {
                f.get();
                throw new RuntimeException("Writer is done?");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void checkSid(BigdataBNode sid, URI p, Value o) {
        BigdataStatement stmt = sid.getStatement();
        if (p == this.RDF_SUBJECT && stmt.getSubject() != o || p == this.RDF_PREDICATE && stmt.getPredicate() != o || p == this.RDF_OBJECT && stmt.getObject() != o) {
            throw new UnificationException("sid cannot refer to multiple statements");
        }
    }

    private boolean equals(BigdataValue v1, BigdataValue ... v2) {
        if (v2.length == 1) {
            return this._equals(v1, v2[0]);
        }
        for (BigdataValue v : v2) {
            if (!this._equals(v1, v)) continue;
            return true;
        }
        return false;
    }

    private boolean _equals(BigdataValue v1, BigdataValue v2) {
        return v1 == v2;
    }

    private static class ReifiedStmt
    implements Statement {
        private static final long serialVersionUID = -7706421769807306702L;
        private BigdataResource s;
        private BigdataURI p;
        private BigdataValue o;
        private BigdataResource c;

        public boolean isFullyBound(int arity) {
            return this.s != null && this.p != null && this.o != null && (arity <= 3 || this.c != null);
        }

        public BigdataResource getContext() {
            return this.c;
        }

        public BigdataValue getObject() {
            return this.o;
        }

        public BigdataURI getPredicate() {
            return this.p;
        }

        public BigdataResource getSubject() {
            return this.s;
        }

        public void set(URI p, BigdataValue o) {
            if (p.toString().equals(RDF.SUBJECT.toString())) {
                this.setSubject((BigdataResource)o);
            } else if (p.toString().equals(RDF.PREDICATE.toString())) {
                this.setPredicate((BigdataURI)o);
            } else if (p.toString().equals(RDF.OBJECT.toString())) {
                this.setObject(o);
            } else {
                throw new IllegalArgumentException();
            }
        }

        public void setSubject(BigdataResource s) {
            this.s = s;
        }

        public void setPredicate(BigdataURI p) {
            this.p = p;
        }

        public void setObject(BigdataValue o) {
            this.o = o;
        }

        public String toString() {
            return "<" + this.s + ", " + this.p + ", " + this.o + ", " + this.c + ">";
        }

        public BigdataStatement toStatement(BigdataValueFactory vf) {
            return vf.createStatement(this.s, this.p, this.o, this.c);
        }
    }

    private static class Batch<S extends Statement> {
        private static final Batch<?> POISON_PILL = new Batch();
        private final AbstractTripleStore database;
        private final AbstractTripleStore statementStore;
        private final boolean readOnly;
        private final IChangeLog changeLog;
        private final IWrittenSPOArray didWriteCallback;
        private final int numValues;
        private final BigdataValue[] values;
        private final int numStmts;
        private final BigdataStatement[] stmts;

        private Batch() {
            this.database = null;
            this.statementStore = null;
            this.readOnly = true;
            this.changeLog = null;
            this.didWriteCallback = null;
            this.numValues = 0;
            this.values = null;
            this.numStmts = 0;
            this.stmts = null;
        }

        private Batch(AbstractTripleStore database, AbstractTripleStore statementStore, boolean readOnly, IChangeLog changeLog, IWrittenSPOArray didWriteCallback, int numValues, BigdataValue[] values, int numStmts, BigdataStatement[] stmts) {
            this.database = database;
            this.statementStore = statementStore;
            this.readOnly = readOnly;
            this.changeLog = changeLog;
            this.didWriteCallback = didWriteCallback;
            this.numValues = numValues;
            this.values = values;
            this.numStmts = numStmts;
            this.stmts = stmts;
        }

        Batch(StatementBuffer<S> sb, boolean clone) {
            if (sb == null) {
                throw new IllegalArgumentException();
            }
            this.database = sb.database;
            this.statementStore = ((StatementBuffer)sb).statementStore;
            this.readOnly = ((StatementBuffer)sb).readOnly;
            this.changeLog = ((StatementBuffer)sb).changeLog;
            this.didWriteCallback = sb.didWriteCallback;
            if (!clone) {
                this.numValues = sb.numValues;
                this.values = sb.values;
                this.numStmts = sb.numStmts;
                this.stmts = sb.stmts;
            } else {
                this.numValues = sb.numValues;
                this.values = new BigdataValue[sb.numValues];
                System.arraycopy(sb.values, 0, this.values, 0, sb.numValues);
                this.numStmts = sb.numStmts;
                this.stmts = new BigdataStatement[sb.numStmts];
                System.arraycopy(sb.stmts, 0, this.stmts, 0, sb.numStmts);
                sb._clear();
            }
        }

        private long writeNow() {
            long nwritten;
            long begin = System.currentTimeMillis();
            if (log.isInfoEnabled()) {
                log.info((Object)("numValues=" + this.numValues + ", numStmts=" + this.numStmts));
            }
            if (this.numValues > 0) {
                int i;
                if (log.isDebugEnabled()) {
                    for (i = 0; i < this.numValues; ++i) {
                        log.debug((Object)("adding term: " + this.values[i] + " (iv=" + this.values[i].getIV() + ")" + (this.values[i] instanceof BNode ? "sid=" + ((BigdataBNode)this.values[i]).isStatementIdentifier() : "")));
                    }
                }
                Batch.addTerms(this.database, this.values, this.numValues, this.readOnly);
                if (log.isDebugEnabled()) {
                    for (i = 0; i < this.numValues; ++i) {
                        log.debug((Object)(" added term: " + this.values[i] + " (iv=" + this.values[i].getIV() + ")" + (this.values[i] instanceof BNode ? "sid=" + ((BigdataBNode)this.values[i]).isStatementIdentifier() : "")));
                    }
                }
            }
            if (this.numStmts > 0) {
                int i;
                if (log.isDebugEnabled()) {
                    for (i = 0; i < this.numStmts; ++i) {
                        log.debug((Object)("adding stmt: " + this.stmts[i]));
                    }
                }
                nwritten = Batch.addStatements(this.database, this.statementStore, this.stmts, this.numStmts, this.changeLog, this.didWriteCallback);
                if (log.isDebugEnabled()) {
                    for (i = 0; i < this.numStmts; ++i) {
                        log.debug((Object)(" added stmt: " + this.stmts[i]));
                    }
                }
            } else {
                nwritten = 0L;
            }
            if (log.isInfoEnabled()) {
                long elapsed = System.currentTimeMillis() - begin;
                log.info((Object)("numValues=" + this.numValues + ", numStmts=" + this.numStmts + ", elapsed=" + elapsed + "ms"));
            }
            return nwritten;
        }

        private static void addTerms(AbstractTripleStore database, BigdataValue[] terms, int numTerms, boolean readOnly) {
            if (log.isInfoEnabled()) {
                log.info((Object)("writing " + numTerms));
                for (int i = 0; i < numTerms; ++i) {
                    log.info((Object)("term: " + terms[i] + ", iv: " + terms[i].getIV()));
                }
            }
            long l = database.getLexiconRelation().addTerms(terms, numTerms, readOnly);
            if (log.isInfoEnabled()) {
                log.info((Object)("# reported from addTerms: " + l));
            }
        }

        private static final <S> long addStatements(AbstractTripleStore database, AbstractTripleStore statementStore, BigdataStatement[] stmts, int numStmts, IChangeLog changeLog, IWrittenSPOArray didWriteCallback) {
            SPO[] tmp = new SPO[numStmts];
            for (int i = 0; i < tmp.length; ++i) {
                BigdataStatement stmt = stmts[i];
                SPO spo = new SPO(stmt);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding: " + stmt.toString() + " (" + spo + ")"));
                }
                if (!spo.isFullyBound()) {
                    throw new AssertionError((Object)("Not fully bound? : " + spo));
                }
                tmp[i] = spo;
            }
            long nwritten = Batch.writeSPOs(database, statementStore, (SPO[])tmp.clone(), numStmts, didWriteCallback);
            block6: for (int i = 0; i < numStmts; ++i) {
                if (!tmp[i].isModified()) continue;
                stmts[i].setModified(tmp[i].getModified());
                if (changeLog == null) continue;
                switch (stmts[i].getModified()) {
                    case INSERTED: {
                        changeLog.changeEvent(new ChangeRecord(stmts[i], ChangeAction.INSERTED));
                        continue block6;
                    }
                    case UPDATED: {
                        changeLog.changeEvent(new ChangeRecord(stmts[i], ChangeAction.UPDATED));
                        continue block6;
                    }
                    case REMOVED: {
                        throw new AssertionError();
                    }
                }
            }
            return nwritten;
        }

        private static <S> long writeSPOs(AbstractTripleStore database, AbstractTripleStore statementStore, SPO[] stmts, int numStmts, IWrittenSPOArray callback) {
            AbstractTripleStore sink;
            ChunkedArrayIterator<ISPO> itr = new ChunkedArrayIterator<ISPO>(numStmts, stmts, null);
            AbstractTripleStore abstractTripleStore = sink = statementStore != null ? statementStore : database;
            if (log.isInfoEnabled()) {
                log.info((Object)("writing " + numStmts + " on " + (statementStore != null ? "statementStore" : "database")));
                for (int i = 0; i < numStmts; ++i) {
                    log.info((Object)("spo: " + stmts[i]));
                }
            }
            long nwritten = database.addStatements(sink, false, itr, null);
            if (callback != null) {
                callback.didWriteSPOs(stmts, numStmts);
            }
            return nwritten;
        }
    }

    private static class MergeUtility<S extends Statement> {
        private int numValues;
        private BigdataValue[] values;
        private Map<BigdataValue, BigdataValue> distinctTermMap;

        MergeUtility() {
        }

        public Batch<S> merge(List<Batch<S>> avail) {
            if (avail == null) {
                throw new IllegalArgumentException();
            }
            if (avail.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (avail.size() < 2) {
                throw new IllegalArgumentException();
            }
            if (this.distinctTermMap != null) {
                throw new IllegalStateException();
            }
            int maxValues = 0;
            int maxStmts = 0;
            for (Batch<S> sb : avail) {
                maxValues += ((Batch)sb).numValues;
                maxStmts += ((Batch)sb).numStmts;
            }
            this.values = new BigdataValue[maxValues];
            this.distinctTermMap = new HashMap<BigdataValue, BigdataValue>(maxValues);
            BigdataStatement[] stmts = new BigdataStatement[maxStmts];
            int n = 0;
            for (Batch<S> sb : avail) {
                int i = 0;
                while (i < ((Batch)sb).numStmts) {
                    BigdataStatement stmt = ((Batch)sb).stmts[i];
                    BigdataResource s = (BigdataResource)this.getDistinctTerm(stmt.getSubject());
                    BigdataURI p = (BigdataURI)this.getDistinctTerm(stmt.getPredicate());
                    BigdataValue o = this.getDistinctTerm(stmt.getObject());
                    BigdataResource c = stmt.getContext() == null ? null : (BigdataResource)this.getDistinctTerm(stmt.getContext());
                    stmts[n] = s.getValueFactory().createStatement(s, p, o, c, stmt.getStatementType());
                    ++i;
                    ++n;
                }
            }
            int numStmts = n;
            Batch<S> sb = avail.get(0);
            return new Batch(((Batch)sb).database, ((Batch)sb).statementStore, ((Batch)sb).readOnly, ((Batch)sb).changeLog, ((Batch)sb).didWriteCallback, this.numValues, this.values, numStmts, stmts);
        }

        private BigdataValue getDistinctTerm(BigdataValue term) {
            if (term == null) {
                throw new IllegalArgumentException();
            }
            BigdataValue existingTerm = this.distinctTermMap.get(term);
            if (existingTerm != null) {
                return existingTerm;
            }
            if (this.distinctTermMap.put(term, term) != null) {
                throw new AssertionError();
            }
            this.values[this.numValues++] = term;
            return term;
        }
    }

    private class DrainQueueCallable
    implements Callable<Void> {
        private boolean exhausted = false;

        private DrainQueueCallable() {
        }

        @Override
        public Void call() throws Exception {
            while (!this.exhausted) {
                Batch batch = (Batch)StatementBuffer.this.queue.take();
                if (batch == Batch.POISON_PILL) {
                    this.exhausted = true;
                    continue;
                }
                StatementBuffer.this.batchTakeCount++;
                if (StatementBuffer.this.queue.isEmpty()) {
                    batch.writeNow();
                    StatementBuffer.this.batchWriteCount++;
                    continue;
                }
                this.drainQueueAndMergeBatches(batch);
            }
            return null;
        }

        private void drainQueueAndMergeBatches(Batch<S> batch) {
            if (batch == null) {
                throw new IllegalArgumentException();
            }
            if (batch == Batch.POISON_PILL) {
                throw new IllegalArgumentException();
            }
            LinkedList avail = new LinkedList();
            avail.add(batch);
            while (!this.exhausted && !StatementBuffer.this.queue.isEmpty()) {
                Batch anotherBatch = (Batch)StatementBuffer.this.queue.poll();
                if (anotherBatch == null) {
                    this.exhausted = true;
                    continue;
                }
                if (anotherBatch == Batch.POISON_PILL) {
                    this.exhausted = true;
                    continue;
                }
                avail.add(anotherBatch);
                StatementBuffer.this.batchTakeCount++;
            }
            if (avail.size() == 1) {
                ((Batch)avail.get(0)).writeNow();
                StatementBuffer.this.batchWriteCount++;
            } else {
                new MergeUtility().merge(avail).writeNow();
                StatementBuffer.this.batchMergeCount += avail.size();
                StatementBuffer.this.batchWriteCount++;
            }
        }
    }

    public static interface IWrittenSPOArray {
        public void didWriteSPOs(SPO[] var1, int var2);
    }
}

