/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.load;

import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class VerifyStatementBuffer
extends StatementBuffer {
    private static final Logger log = Logger.getLogger(VerifyStatementBuffer.class);
    final AtomicLong nterms;
    final AtomicLong ntermsNotFound;
    final AtomicLong ntriples;
    final AtomicLong ntriplesNotFound;

    public VerifyStatementBuffer(AbstractTripleStore database, int capacity, AtomicLong nterms, AtomicLong ntermsNotFound, AtomicLong ntriples, AtomicLong ntriplesNotFound) {
        super(database, capacity);
        this.nterms = nterms;
        this.ntermsNotFound = ntermsNotFound;
        this.ntriples = ntriples;
        this.ntriplesNotFound = ntriplesNotFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void incrementalWrite() {
        if (log.isInfoEnabled()) {
            log.info((Object)("numValues=" + this.numValues + ", numStmts=" + this.numStmts));
        }
        if (this.numValues > 0) {
            this.database.getLexiconRelation().addTerms(this.values, this.numValues, true);
        }
        for (int i = 0; i < this.numValues; ++i) {
            BigdataValue v = this.values[i];
            this.nterms.incrementAndGet();
            if (v.getIV() != null) continue;
            log.warn((Object)("Unknown term: " + v));
            this.ntermsNotFound.incrementAndGet();
        }
        if (this.numStmts > 0) {
            SPO[] a = new SPO[this.numStmts];
            BigdataStatement[] b = new BigdataStatement[this.numStmts];
            int n = 0;
            for (int i = 0; i < this.numStmts; ++i) {
                BigdataStatement stmt = this.stmts[i];
                this.ntriples.incrementAndGet();
                if (!stmt.isFullyBound()) {
                    log.warn((Object)("Unknown statement (one or more unknown terms) " + stmt));
                    this.ntriplesNotFound.incrementAndGet();
                    continue;
                }
                a[n] = new SPO(stmt);
                b[n] = stmt;
                ++n;
            }
            try (IChunkedOrderedIterator<ISPO> itr = this.database.bulkCompleteStatements(a, n);){
                while (itr.hasNext()) {
                    itr.next();
                }
            }
            for (int i = 0; i < n; ++i) {
                SPO spo = a[i];
                if (!spo.hasStatementType()) {
                    this.ntriplesNotFound.incrementAndGet();
                    log.warn((Object)("Statement not in database: " + b[i] + " (" + spo + ")"));
                    continue;
                }
                if (spo.getStatementType() == StatementEnum.Explicit) continue;
                this.ntriplesNotFound.incrementAndGet();
                log.warn((Object)("Statement not explicit database: " + b[i] + " is marked as " + (Object)((Object)spo.getStatementType())));
            }
        }
        this._clear();
    }
}

