/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.extensions;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.service.GeoSpatialConfig;
import com.bigdata.service.geospatial.GeoSpatial;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class GeoSpatialLiteralExtension<V extends BigdataValue>
implements IExtension<V> {
    private static final int BASE_SIZE = 8;
    private static final String COMPONENT_SEPARATOR = "#";
    private static final transient Logger log = Logger.getLogger(GeoSpatialLiteralExtension.class);
    private final URI datatypeURI = GeoSpatial.DATATYPE;
    private final BigdataURI datatype;
    private SchemaDescription sd;
    final IKeyBuilder kb;

    public GeoSpatialLiteralExtension(IDatatypeURIResolver resolver) {
        this(resolver, GeoSpatialLiteralExtension.defaultSchemaDescription());
    }

    public GeoSpatialLiteralExtension(IDatatypeURIResolver resolver, SchemaDescription sd) {
        this.datatype = resolver.resolve(this.datatypeURI);
        this.sd = sd;
        this.kb = KeyBuilder.newInstance();
    }

    @Override
    public Set<BigdataURI> getDatatypes() {
        LinkedHashSet<BigdataURI> datatypes = new LinkedHashSet<BigdataURI>();
        datatypes.add(this.datatype);
        return datatypes;
    }

    @Override
    public LiteralExtensionIV createIV(Value value) {
        if (!(value instanceof Literal)) {
            throw new IllegalArgumentException("Value not a literal");
        }
        return this.createIV(value.stringValue().split(COMPONENT_SEPARATOR));
    }

    public LiteralExtensionIV createIV(Object[] components) {
        long[] componentsAsLongArr = this.componentsAsLongArr(components, this.sd);
        byte[] zOrderByteArray = this.toZOrderByteArray(componentsAsLongArr, this.sd);
        byte[] zOrderByteArrayTwoCompl = this.padLeadingZero(zOrderByteArray);
        BigInteger bi = new BigInteger(zOrderByteArrayTwoCompl);
        XSDIntegerIV<BigdataLiteral> delegate = new XSDIntegerIV<BigdataLiteral>(bi);
        return new LiteralExtensionIV(delegate, this.datatype.getIV());
    }

    public byte[] toZOrderByteArray(Object[] components) {
        long[] componentsAsLongArr = this.componentsAsLongArr(components, this.sd);
        byte[] zOrderByteArray = this.toZOrderByteArray(componentsAsLongArr, this.sd);
        return this.padLeadingZero(zOrderByteArray);
    }

    public LiteralExtensionIV createIVFromZOrderByteArray(byte[] zOrderByteArray) {
        byte[] zOrderByteArrayTwoCompl = this.padLeadingZero(zOrderByteArray);
        BigInteger bi = new BigInteger(zOrderByteArrayTwoCompl);
        XSDIntegerIV<BigdataLiteral> delegate = new XSDIntegerIV<BigdataLiteral>(bi);
        return new LiteralExtensionIV(delegate, this.datatype.getIV());
    }

    public final long[] componentsAsLongArr(Object[] components, SchemaDescription sd) {
        long[] ret = new long[sd.getNumDimensions()];
        int numDimensions = sd.getNumDimensions();
        if (numDimensions != components.length) {
            throw new IllegalArgumentException("Literal value has wrong format. Expected " + numDimensions + " components for datatype.");
        }
        for (int i = 0; i < components.length; ++i) {
            Object component = components[i];
            SchemaFieldDescription sfd = sd.getSchemaFieldDescription(i);
            BigDecimal precisionAdjustment = BigDecimal.valueOf(sfd.getPrecision());
            BigDecimal componentAsBigInteger = component instanceof BigDecimal ? (BigDecimal)component : new BigDecimal(component.toString());
            BigDecimal x = precisionAdjustment.multiply(componentAsBigInteger);
            ret[i] = x.longValue();
        }
        return ret;
    }

    public byte[] toZOrderByteArray(long[] componentsAsLongArr, SchemaDescription sd) {
        this.kb.reset();
        for (int i = 0; i < componentsAsLongArr.length; ++i) {
            long componentAsLong = componentsAsLongArr[i];
            Long minValue = sd.getSchemaFieldDescription(i).getMinValue();
            long componentAsLongRangeShifted = minValue == null ? componentAsLong : this.encodeRangeShift(componentAsLong, minValue);
            this.kb.append(componentAsLongRangeShifted);
        }
        return this.kb.toZOrder(sd.getNumDimensions());
    }

    protected Long encodeRangeShift(Long val, Long minValue) {
        if (minValue == null) {
            return val;
        }
        if (val < minValue) {
            throw new RuntimeException("Illegal range shift -- datatype violation.");
        }
        return Long.MIN_VALUE + (val - minValue);
    }

    public byte[] padLeadingZero(byte[] arr) {
        byte[] ret = new byte[arr.length + 1];
        for (int i = 0; i < arr.length; ++i) {
            ret[i + 1] = arr[i];
        }
        return ret;
    }

    @Override
    public V asValue(LiteralExtensionIV iv, BigdataValueFactory vf) {
        long[] componentsAsLongArr = this.asLongArray(iv);
        String litStr = this.longArrAsComponentString(0, componentsAsLongArr.length - 1, componentsAsLongArr);
        return (V)vf.createLiteral(litStr, this.datatype);
    }

    public long[] asLongArray(LiteralExtensionIV iv) {
        if (!this.datatype.getIV().equals(iv.getExtensionIV())) {
            throw new IllegalArgumentException("unrecognized datatype");
        }
        BigInteger bigInt = iv.getDelegate().integerValue();
        byte[] bigIntAsByteArrUnsigned = this.toZOrderByteArray(bigInt);
        long[] componentsAsLongArr = this.fromZOrderByteArray(bigIntAsByteArrUnsigned);
        return componentsAsLongArr;
    }

    public String toComponentString(int startPos, int endPos, LiteralExtensionIV iv) {
        long[] longArr = this.asLongArray(iv);
        return this.longArrAsComponentString(startPos, endPos, longArr);
    }

    public byte[] toZOrderByteArray(BigInteger bigInt) {
        int i;
        int numDimensions = this.sd.getNumDimensions();
        byte[] bigIntAsByteArr = bigInt.toByteArray();
        int paddedArraySize = numDimensions * 8 + 1;
        byte[] bigIntAsByteArrPad = new byte[paddedArraySize];
        int idx = 0;
        for (i = 0; i < paddedArraySize - bigIntAsByteArr.length; ++i) {
            bigIntAsByteArrPad[idx++] = 0;
        }
        for (i = 0; i < bigIntAsByteArr.length; ++i) {
            bigIntAsByteArrPad[idx++] = bigIntAsByteArr[i];
        }
        byte[] bigIntAsByteArrUnsigned = this.unpadLeadingZero(bigIntAsByteArrPad);
        return bigIntAsByteArrUnsigned;
    }

    public byte[] toZOrderByteArray(AbstractLiteralIV<BigdataLiteral, ?> literalIV) {
        if (!(literalIV instanceof XSDIntegerIV)) {
            throw new RuntimeException("zOrder value IV must be XSDInteger");
        }
        return this.toZOrderByteArray(literalIV.integerValue());
    }

    public long[] fromZOrderByteArray(byte[] byteArr) {
        this.kb.reset();
        for (int i = 0; i < byteArr.length; ++i) {
            this.kb.append(byteArr[i]);
        }
        long[] componentsAsLongArr = this.kb.fromZOrder(this.sd.getNumDimensions());
        for (int i = 0; i < componentsAsLongArr.length; ++i) {
            Long minValue = this.sd.getSchemaFieldDescription(i).getMinValue();
            if (minValue == null) continue;
            componentsAsLongArr[i] = this.decodeRangeShift(componentsAsLongArr[i], minValue);
        }
        return componentsAsLongArr;
    }

    protected Long decodeRangeShift(Long val, Long minValue) {
        if (minValue == null) {
            return val;
        }
        return val - Long.MIN_VALUE + minValue;
    }

    public String longArrAsComponentString(int startPos, int endPos, long[] arr) {
        Object[] componentArr = this.longArrAsComponentArr(arr);
        StringBuffer buf = new StringBuffer();
        for (int i = startPos; i <= endPos; ++i) {
            if (i > startPos) {
                buf.append(COMPONENT_SEPARATOR);
            }
            buf.append(componentArr[i]);
        }
        return buf.toString();
    }

    public final Object[] longArrAsComponentArr(long[] arr) {
        int numDimensions = this.sd.getNumDimensions();
        if (arr.length != numDimensions) {
            throw new IllegalArgumentException("Encoding has wrong format. Expected " + numDimensions + " components for datatype.");
        }
        StringBuffer buf = new StringBuffer();
        Object[] componentArr = new Object[arr.length];
        block4: for (int i = 0; i < arr.length; ++i) {
            SchemaFieldDescription sfd = this.sd.getSchemaFieldDescription(i);
            double precisionAdjustment = sfd.getPrecision();
            if (i > 0) {
                buf.append(COMPONENT_SEPARATOR);
            }
            switch (sfd.getDatatype()) {
                case DOUBLE: {
                    componentArr[i] = (double)arr[i] / precisionAdjustment;
                    continue block4;
                }
                case LONG: {
                    componentArr[i] = arr[i] / (long)precisionAdjustment;
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Uncovered decoding case. Please fix code.");
                }
            }
        }
        return componentArr;
    }

    public byte[] unpadLeadingZero(byte[] arr) {
        byte[] ret = new byte[arr.length - 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = arr[i + 1];
        }
        return ret;
    }

    public int getNumDimensions() {
        return this.sd.getNumDimensions();
    }

    private static SchemaDescription defaultSchemaDescription() {
        return GeoSpatialConfig.getInstance().getSchemaDescription();
    }

    public static class SchemaFieldDescription {
        public Long minValue;
        private final Datatype datatype;
        private final long precision;

        public SchemaFieldDescription(Datatype datatype, long precision) {
            this(datatype, precision, null);
        }

        public SchemaFieldDescription(Datatype datatype, long precision, Long minValue) {
            this.datatype = datatype;
            this.precision = precision;
            this.minValue = minValue;
        }

        public Datatype getDatatype() {
            return this.datatype;
        }

        public long getPrecision() {
            return this.precision;
        }

        public Long getMinValue() {
            return this.minValue;
        }

        public static enum Datatype {
            LONG,
            DOUBLE;

        }
    }

    public static class SchemaDescription {
        private final List<SchemaFieldDescription> fields;

        public SchemaDescription(List<SchemaFieldDescription> fields) {
            this.fields = fields;
        }

        public int getNumDimensions() {
            return this.fields.size();
        }

        public SchemaFieldDescription getSchemaFieldDescription(int index) {
            return this.fields.get(index);
        }
    }
}

