/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.openrdf.model.Literal;

public class LangBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 7391999162162545704L;

    public LangBOp(IValueExpression<? extends IV> x, GlobalAnnotations globals) {
        super(x, globals, new NV[0]);
    }

    public LangBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
        if (this.getProperty(IVValueExpression.Annotations.NAMESPACE) == null) {
            throw new IllegalArgumentException();
        }
    }

    public LangBOp(LangBOp op) {
        super(op);
    }

    public IV get(IBindingSet bs) {
        Literal literal = this.getAndCheckLiteralValue(0, bs);
        String langTag = literal.getLanguage();
        if (langTag == null) {
            langTag = "";
        }
        BigdataValueFactory vf = this.getValueFactory();
        BigdataLiteral lang = vf.createLiteral(langTag);
        return super.asIV(lang, bs);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }
}

